/*
 * Decompiled with CFR 0.152.
 */
package net.hibiscus.naturespirit.world.trunk;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.hibiscus.naturespirit.world.HibiscusWorldGen;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3746;
import net.minecraft.class_4643;
import net.minecraft.class_4647;
import net.minecraft.class_5141;
import net.minecraft.class_5142;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6017;
import net.minecraft.class_6885;
import net.minecraft.class_6895;
import net.minecraft.class_7924;

public class CoconutTrunkPlacer
extends class_5141 {
    public static final Codec<CoconutTrunkPlacer> CODEC = RecordCodecBuilder.create(instance -> CoconutTrunkPlacer.method_28904((RecordCodecBuilder.Instance)instance).and(instance.group((App)class_6017.field_33451.fieldOf("trunk_steps").forGetter(trunkPlacer -> trunkPlacer.trunkSteps), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("fork_probability").forGetter(trunkPlacer -> Float.valueOf(trunkPlacer.forkProbability)), (App)class_6895.method_40340((class_5321)class_7924.field_41254).fieldOf("can_grow_through").forGetter(trunkPlacer -> trunkPlacer.canGrowThrough))).apply((Applicative)instance, CoconutTrunkPlacer::new));
    private final class_6017 trunkSteps;
    private final float forkProbability;
    private final class_6885<class_2248> canGrowThrough;

    public CoconutTrunkPlacer(int baseHeight, int firstRandomHeight, int secondRandomHeight, class_6017 trunkSteps, float forkProbability, class_6885<class_2248> canGrowThrough) {
        super(baseHeight, firstRandomHeight, secondRandomHeight);
        this.trunkSteps = trunkSteps;
        this.forkProbability = forkProbability;
        this.canGrowThrough = canGrowThrough;
    }

    protected class_5142<?> method_28903() {
        return HibiscusWorldGen.COCONUT_TRUNK_PLACER;
    }

    public List<class_4647.class_5208> method_26991(class_3746 world, BiConsumer<class_2338, class_2680> replacer, class_5819 random, int height, class_2338 startPos, class_4643 config) {
        ArrayList list = Lists.newArrayList();
        class_2338.class_2339 mutable = new class_2338.class_2339().method_10103(startPos.method_10263(), startPos.method_10264() - 1, startPos.method_10260());
        class_2338.class_2339 forkedMutable = new class_2338.class_2339().method_10103(startPos.method_10263(), startPos.method_10264() + 1, startPos.method_10260());
        boolean forked = random.method_43057() < this.forkProbability;
        int steps = this.trunkSteps.method_35008(random);
        int increment = random.method_39332(0, 1);
        int forkedIncrement = random.method_39332(0, 1);
        class_2350 offsetDirection = class_2350.class_2353.field_11062.method_10183(random);
        class_2350 offsetDirection2 = class_2350.class_2353.field_11062.method_10183(random);
        int forkedOffset = random.method_39332(0, 2);
        int forkedHeight = height - forkedOffset;
        for (int i = 0; i < height; ++i) {
            class_2338.class_2339 pos = mutable.method_10100(0, 1, 0);
            this.method_35375(world, replacer, random, (class_2338)pos, config);
            if (i < 2) continue;
            if (forked && i < forkedHeight) {
                class_2338.class_2339 forkedPos = forkedMutable.method_10100(0, 1, 0);
                this.method_35375(world, replacer, random, (class_2338)forkedPos, config);
                if (i == forkedHeight - 1) {
                    list.add(new class_4647.class_5208(forkedPos.method_10086(1), 0, false));
                }
            }
            if (i == height - 1) {
                list.add(new class_4647.class_5208(pos.method_10086(1), 0, false));
            }
            if (increment == 0) {
                mutable.method_10098(offsetDirection);
                if (offsetDirection2 != offsetDirection) {
                    mutable.method_10098(offsetDirection2);
                }
                increment = height / steps - random.method_39332(-1, 1);
            }
            if (forkedIncrement == 0) {
                forkedMutable.method_10098(offsetDirection.method_10153());
                if (offsetDirection2 != offsetDirection && random.method_43056()) {
                    forkedMutable.method_10098(offsetDirection2.method_10153());
                }
                forkedIncrement = forkedHeight / steps - random.method_39332(-1, 1);
            }
            --increment;
            --forkedIncrement;
        }
        return list;
    }

    protected boolean method_43196(class_3746 world, class_2338 pos) {
        return super.method_43196(world, pos) || world.method_16358(pos, state -> state.method_40143(this.canGrowThrough));
    }
}

