/*
 * Decompiled with CFR 0.152.
 */
package net.hibiscus.naturespirit.world.trunk;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.hibiscus.naturespirit.world.HibiscusWorldGen;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2465;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3746;
import net.minecraft.class_4643;
import net.minecraft.class_4647;
import net.minecraft.class_5141;
import net.minecraft.class_5142;
import net.minecraft.class_5699;
import net.minecraft.class_5819;
import net.minecraft.class_6017;
import net.minecraft.class_6019;

public class MapleTrunkPlacer
extends class_5141 {
    private static final Codec<class_6019> BRANCH_START_OFFSET_FROM_TOP_CODEC = class_5699.method_48112((Codec)class_6019.field_29949, branchStartOffsetFromTop -> branchStartOffsetFromTop.method_35011() - branchStartOffsetFromTop.method_35009() < 1 ? DataResult.error(() -> "Need at least 2 blocks variation for the branch starts to fit both branches") : DataResult.success((Object)branchStartOffsetFromTop));
    public static final Codec<MapleTrunkPlacer> CODEC = RecordCodecBuilder.create(instance -> MapleTrunkPlacer.method_28904((RecordCodecBuilder.Instance)instance).and(instance.group((App)class_6017.method_35004((int)1, (int)5).fieldOf("branch_count").forGetter(trunkPlacer -> trunkPlacer.branchCount), (App)class_6017.method_35004((int)1, (int)16).fieldOf("branch_horizontal_length").forGetter(trunkPlacer -> trunkPlacer.branchHorizontalLength), (App)class_6017.method_49103((int)-16, (int)0, BRANCH_START_OFFSET_FROM_TOP_CODEC).fieldOf("branch_start_offset_from_top").forGetter(trunkPlacer -> trunkPlacer.branchStartOffsetFromTop), (App)class_6017.method_35004((int)-16, (int)16).fieldOf("branch_end_offset_from_top").forGetter(trunkPlacer -> trunkPlacer.branchEndOffsetFromTop))).apply((Applicative)instance, MapleTrunkPlacer::new));
    private final class_6017 branchCount;
    private final class_6017 branchHorizontalLength;
    private final class_6019 branchStartOffsetFromTop;
    private final class_6019 secondBranchStartOffsetFromTop;
    private final class_6017 branchEndOffsetFromTop;

    public MapleTrunkPlacer(int baseHeight, int firstRandomHeight, int secondRandomHeight, class_6017 branchCount, class_6017 branchHorizontalLength, class_6019 branchStartOffsetFromTop, class_6017 branchEndOffsetFromTop) {
        super(baseHeight, firstRandomHeight, secondRandomHeight);
        this.branchCount = branchCount;
        this.branchHorizontalLength = branchHorizontalLength;
        this.branchStartOffsetFromTop = branchStartOffsetFromTop;
        this.secondBranchStartOffsetFromTop = class_6019.method_35017((int)branchStartOffsetFromTop.method_35009(), (int)(branchStartOffsetFromTop.method_35011() - 1));
        this.branchEndOffsetFromTop = branchEndOffsetFromTop;
    }

    protected class_5142<?> method_28903() {
        return HibiscusWorldGen.MAPLE_TRUNK_PLACER;
    }

    public List<class_4647.class_5208> method_26991(class_3746 world, BiConsumer<class_2338, class_2680> replacer, class_5819 random, int height, class_2338 startPos, class_4643 config) {
        boolean bl4;
        int k;
        MapleTrunkPlacer.method_27400((class_3746)world, replacer, (class_5819)random, (class_2338)startPos.method_10074(), (class_4643)config);
        int i = Math.max(0, height - 1 + this.branchStartOffsetFromTop.method_35008(random));
        int j = Math.max(0, height - 1 + this.secondBranchStartOffsetFromTop.method_35008(random));
        if (j >= i) {
            ++j;
        }
        boolean bl = (k = this.branchCount.method_35008(random)) >= 3;
        boolean bl2 = k >= 2;
        boolean bl3 = k >= 4;
        boolean bl5 = bl4 = k == 5;
        int l = bl ? height : (bl2 ? Math.max(i, j) + 1 : i + 1);
        for (int m = 0; m < l; ++m) {
            this.method_35375(world, replacer, random, startPos.method_10086(m), config);
        }
        ArrayList<class_4647.class_5208> list = new ArrayList<class_4647.class_5208>();
        if (bl) {
            list.add(new class_4647.class_5208(startPos.method_10086(l), 0, false));
        }
        class_2338.class_2339 mutable = new class_2338.class_2339();
        class_2350 direction = class_2350.class_2353.field_11062.method_10183(random);
        class_2350 direction2 = direction.method_35833(class_2350.class_2351.field_11052);
        Function<class_2680, class_2680> function = state -> (class_2680)state.method_47968((class_2769)class_2465.field_11459, (Comparable)direction.method_10166());
        Function<class_2680, class_2680> function2 = state -> (class_2680)state.method_47968((class_2769)class_2465.field_11459, (Comparable)direction2.method_10166());
        list.add(this.generateBranch(world, replacer, random, height, startPos, config, function, direction, i, i < l - 1, mutable));
        if (bl2) {
            list.add(this.generateBranch(world, replacer, random, height, startPos, config, function, direction.method_10153(), j, j < l - 1, mutable));
        }
        if (bl3) {
            list.add(this.generateBranch(world, replacer, random, height, startPos, config, function2, direction2, j, j < l - 1, mutable));
        }
        if (bl4) {
            list.add(this.generateBranch(world, replacer, random, height, startPos, config, function2, direction2.method_10153(), j, j < l - 1, mutable));
        }
        return list;
    }

    private class_4647.class_5208 generateBranch(class_3746 world, BiConsumer<class_2338, class_2680> replacer, class_5819 random, int height, class_2338 startPos, class_4643 config, Function<class_2680, class_2680> withAxisFunction, class_2350 direction, int branchStartOffset, boolean branchBelowHeight, class_2338.class_2339 mutablePos) {
        class_2350 direction2;
        mutablePos.method_10101((class_2382)startPos).method_10104(class_2350.field_11036, branchStartOffset);
        int i = height - 1 + this.branchEndOffsetFromTop.method_35008(random);
        boolean bl = branchBelowHeight || i < branchStartOffset;
        int j = this.branchHorizontalLength.method_35008(random) + (bl ? 1 : 0);
        class_2338 blockPos = startPos.method_10079(direction, j).method_10086(i);
        int k = bl ? 2 : 1;
        for (int l = 0; l < k; ++l) {
            this.method_27402(world, replacer, random, (class_2338)mutablePos.method_10098(direction), config, withAxisFunction);
        }
        class_2350 class_23502 = direction2 = blockPos.method_10264() > mutablePos.method_10264() ? class_2350.field_11036 : class_2350.field_11033;
        int m;
        while ((m = mutablePos.method_19455((class_2382)blockPos)) != 0) {
            float f = (float)Math.abs(blockPos.method_10264() - mutablePos.method_10264()) / (float)m;
            boolean bl2 = random.method_43057() < f;
            mutablePos.method_10098(bl2 ? direction2 : direction);
            this.method_27402(world, replacer, random, (class_2338)mutablePos, config, bl2 ? Function.identity() : withAxisFunction);
        }
        return new class_4647.class_5208(blockPos.method_10084(), 0, false);
    }
}

