/*
 * Decompiled with CFR 0.152.
 */
package net.hibiscus.naturespirit.world.trunk;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.hibiscus.naturespirit.world.HibiscusWorldGen;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2465;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3746;
import net.minecraft.class_4643;
import net.minecraft.class_4647;
import net.minecraft.class_5141;
import net.minecraft.class_5142;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6017;
import net.minecraft.class_6885;
import net.minecraft.class_6895;
import net.minecraft.class_7924;

public class SugiTrunkPlacer
extends class_5141 {
    public static final Codec<SugiTrunkPlacer> CODEC = RecordCodecBuilder.create(instance -> SugiTrunkPlacer.method_28904((RecordCodecBuilder.Instance)instance).and(instance.group((App)class_6017.field_33451.fieldOf("extra_branch_steps").forGetter(trunkPlacer -> trunkPlacer.extraBranchSteps), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("place_branch_per_log_probability").forGetter(trunkPlacer -> Float.valueOf(trunkPlacer.placeBranchPerLogProbability)), (App)class_6017.field_33450.fieldOf("extra_branch_length").forGetter(trunkPlacer -> trunkPlacer.extraBranchLength), (App)class_6895.method_40340((class_5321)class_7924.field_41254).fieldOf("can_grow_through").forGetter(trunkPlacer -> trunkPlacer.canGrowThrough))).apply((Applicative)instance, SugiTrunkPlacer::new));
    private final class_6017 extraBranchSteps;
    private final float placeBranchPerLogProbability;
    private final class_6017 extraBranchLength;
    private final class_6885<class_2248> canGrowThrough;

    public SugiTrunkPlacer(int baseHeight, int firstRandomHeight, int secondRandomHeight, class_6017 extraBranchSteps, float placeBranchPerLogProbability, class_6017 extraBranchLength, class_6885<class_2248> canGrowThrough) {
        super(baseHeight, firstRandomHeight, secondRandomHeight);
        this.extraBranchSteps = extraBranchSteps;
        this.placeBranchPerLogProbability = placeBranchPerLogProbability;
        this.extraBranchLength = extraBranchLength;
        this.canGrowThrough = canGrowThrough;
    }

    protected class_5142<?> method_28903() {
        return HibiscusWorldGen.SUGI_TRUNK_PLACER;
    }

    public List<class_4647.class_5208> method_26991(class_3746 world, BiConsumer<class_2338, class_2680> replacer, class_5819 random, int height, class_2338 startPos, class_4643 config) {
        ArrayList list = Lists.newArrayList();
        class_2338.class_2339 mutable = new class_2338.class_2339();
        class_2350 direction = class_2350.class_2353.field_11062.method_10183(random);
        for (int i = 0; i < height; ++i) {
            int j = startPos.method_10264() + i;
            if (this.method_35375(world, replacer, random, (class_2338)mutable.method_10103(startPos.method_10263(), j, startPos.method_10260()), config) && i < height - 1 && i > 3) {
                direction = direction.method_10170();
                class_2350 direction2 = direction.method_10170();
                class_2350 direction3 = direction2.method_10170();
                int m = height - i - 2;
                this.generateExtraBranch(world, replacer, random, height, config, list, mutable, j, direction, Math.min(m, 5), i);
                if ((double)random.method_43057() < (double)this.placeBranchPerLogProbability - 0.25) {
                    this.generateExtraBranch(world, replacer, random, height, config, list, mutable, j, direction2, Math.min(m, 5), i);
                }
                if ((double)random.method_43057() < (double)this.placeBranchPerLogProbability - 0.35) {
                    this.generateExtraBranch(world, replacer, random, height, config, list, mutable, j, direction3, Math.min(m, 5), i);
                }
            }
            if (i != height - 1) continue;
            list.add(new class_4647.class_5208((class_2338)mutable.method_10103(startPos.method_10263(), j + 1, startPos.method_10260()), 0, false));
            list.add(new class_4647.class_5208((class_2338)mutable.method_10103(startPos.method_10263(), j, startPos.method_10260()), 0, false));
        }
        return list;
    }

    private void generateExtraBranch(class_3746 world, BiConsumer<class_2338, class_2680> replacer, class_5819 random, int height, class_4643 config, List<class_4647.class_5208> nodes, class_2338.class_2339 pos, int yOffset, class_2350 direction, int steps, int b) {
        int j = pos.method_10263();
        int k = pos.method_10260();
        boolean bl = random.method_43057() < 0.5f;
        class_2350 direction2 = bl ? direction.method_10170() : direction.method_10160();
        for (int l = 0; l < height && steps > 0 && steps < (bl ? 7 : 10); ++l, --steps) {
            if (l < 1) continue;
            k = bl ? (k += Math.max(0, direction2.method_10165() - random.method_43048(2))) : (k += direction.method_10165());
            this.method_27402(world, replacer, random, (class_2338)pos.method_10103(j += direction.method_10148(), yOffset, k), config, blockState -> (class_2680)blockState.method_47968((class_2769)class_2465.field_11459, (Comparable)direction.method_10166()));
            if (l != height - 1 && steps != 1) continue;
            class_2338 blockPos = new class_2338(j, yOffset, k);
            nodes.add(new class_4647.class_5208(blockPos, b > 5 ? 0 : 1, false));
        }
    }

    protected boolean method_43196(class_3746 world, class_2338 pos) {
        return super.method_43196(world, pos) || world.method_16358(pos, state -> state.method_40143(this.canGrowThrough));
    }
}

