/*
 * Decompiled with CFR 0.152.
 */
package net.hibiscus.naturespirit.world.trunk;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.hibiscus.naturespirit.world.HibiscusWorldGen;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3746;
import net.minecraft.class_4643;
import net.minecraft.class_4647;
import net.minecraft.class_5141;
import net.minecraft.class_5142;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6017;
import net.minecraft.class_6885;
import net.minecraft.class_6895;
import net.minecraft.class_7924;

public class WisteriaTrunkPlacer
extends class_5141 {
    public static final Codec<WisteriaTrunkPlacer> CODEC = RecordCodecBuilder.create(instance -> WisteriaTrunkPlacer.method_28904((RecordCodecBuilder.Instance)instance).and(instance.group((App)class_6017.field_33451.fieldOf("extra_branch_steps").forGetter(WisteriaTrunkPlacer2 -> WisteriaTrunkPlacer2.extraBranchSteps), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("place_branch_per_log_probability").forGetter(WisteriaTrunkPlacer2 -> Float.valueOf(WisteriaTrunkPlacer2.placeBranchPerLogProbability)), (App)class_6017.field_33450.fieldOf("extra_branch_length").forGetter(WisteriaTrunkPlacer2 -> WisteriaTrunkPlacer2.extraBranchLength), (App)class_6895.method_40340((class_5321)class_7924.field_41254).fieldOf("can_grow_through").forGetter(WisteriaTrunkPlacer2 -> WisteriaTrunkPlacer2.canGrowThrough))).apply((Applicative)instance, WisteriaTrunkPlacer::new));
    private final class_6017 extraBranchSteps;
    private final float placeBranchPerLogProbability;
    private final class_6017 extraBranchLength;
    private final class_6885<class_2248> canGrowThrough;

    public WisteriaTrunkPlacer(int baseHeight, int firstRandomHeight, int secondRandomHeight, class_6017 extraBranchSteps, float placeBranchPerLogProbability, class_6017 extraBranchLength, class_6885<class_2248> canGrowThrough) {
        super(baseHeight, firstRandomHeight, secondRandomHeight);
        this.extraBranchSteps = extraBranchSteps;
        this.placeBranchPerLogProbability = placeBranchPerLogProbability;
        this.extraBranchLength = extraBranchLength;
        this.canGrowThrough = canGrowThrough;
    }

    protected class_5142<?> method_28903() {
        return HibiscusWorldGen.WISTERIA_TRUNK_PLACER;
    }

    public List<class_4647.class_5208> method_26991(class_3746 world, BiConsumer<class_2338, class_2680> replacer, class_5819 random, int height, class_2338 startPos, class_4643 config) {
        ArrayList list = Lists.newArrayList();
        class_2338.class_2339 mutable = new class_2338.class_2339();
        for (int i = 0; i < height; ++i) {
            int j = startPos.method_10264() + i;
            if (this.method_35375(world, replacer, random, (class_2338)mutable.method_10103(startPos.method_10263(), j, startPos.method_10260()), config) && i < height - 3 && i > 2 && random.method_43057() < this.placeBranchPerLogProbability) {
                class_2350 direction = class_2350.class_2353.field_11062.method_10183(random);
                int k = this.extraBranchLength.method_35008(random);
                int l = Math.max(0, k - this.extraBranchLength.method_35008(random) - 1);
                int m = this.extraBranchSteps.method_35008(random);
                int g = startPos.method_10264() + i - 1;
                this.placeBranch(world, replacer, random, height, config, list, mutable, j, direction, l, m);
            }
            if (i + 1 != height) continue;
            list.add(new class_4647.class_5208((class_2338)mutable.method_10103(startPos.method_10263(), j, startPos.method_10260()), -1, false));
        }
        return list;
    }

    private void placeBranch(class_3746 world, BiConsumer<class_2338, class_2680> replacer, class_5819 random, int height, class_4643 config, List<class_4647.class_5208> nodes, class_2338.class_2339 pos, int yOffset, class_2350 direction, int length, int steps) {
        int i = yOffset + length;
        int j = pos.method_10263();
        int k = pos.method_10260();
        for (int l = length; l < height && steps > 0; ++l, --steps) {
            if (l < 1) continue;
            int m = yOffset + l;
            i = m;
            if (!this.method_35375(world, replacer, random, (class_2338)pos.method_10103(j += direction.method_10148(), m, k += direction.method_10165()), config)) continue;
            i = m + 1;
        }
        if (i - yOffset > 1) {
            class_2338 blockPos = new class_2338(j, i, k);
            nodes.add(new class_4647.class_5208(blockPos, 0, false));
        }
    }

    protected boolean method_43196(class_3746 levelSimulatedReader, class_2338 blockPos) {
        return super.method_43196(levelSimulatedReader, blockPos) || levelSimulatedReader.method_16358(blockPos, blockState -> blockState.method_40143(this.canGrowThrough));
    }
}

