/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.claims.player;

import java.util.Deque;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_2960;
import xaero.pac.common.claims.player.IPlayerChunkClaim;
import xaero.pac.common.claims.player.IPlayerClaimPosList;
import xaero.pac.common.claims.player.IPlayerDimensionClaims;
import xaero.pac.common.claims.player.PlayerChunkClaim;
import xaero.pac.common.claims.player.PlayerClaimInfo;
import xaero.pac.common.claims.player.PlayerDimensionClaims;
import xaero.pac.common.parties.party.IPartyPlayerInfo;
import xaero.pac.common.parties.party.ally.IPartyAlly;
import xaero.pac.common.parties.party.member.IPartyMember;
import xaero.pac.common.server.IServerData;
import xaero.pac.common.server.claims.IServerClaimsManager;
import xaero.pac.common.server.claims.IServerDimensionClaimsManager;
import xaero.pac.common.server.claims.IServerRegionClaims;
import xaero.pac.common.server.claims.player.IServerPlayerClaimInfo;
import xaero.pac.common.server.claims.player.ServerPlayerClaimInfoManager;
import xaero.pac.common.server.claims.player.task.PlayerClaimReplaceSpreadoutTask;
import xaero.pac.common.server.config.ServerConfig;
import xaero.pac.common.server.expiration.ObjectManagerIOExpirableObject;
import xaero.pac.common.server.info.ServerInfo;
import xaero.pac.common.server.parties.party.IServerParty;
import xaero.pac.common.server.player.config.IPlayerConfig;
import xaero.pac.common.server.player.config.IPlayerConfigManager;
import xaero.pac.common.server.player.config.PlayerConfig;
import xaero.pac.common.server.player.config.api.PlayerConfigOptions;

public final class ServerPlayerClaimInfo
extends PlayerClaimInfo<ServerPlayerClaimInfo, ServerPlayerClaimInfoManager>
implements IServerPlayerClaimInfo<PlayerDimensionClaims>,
ObjectManagerIOExpirableObject {
    private IPlayerConfig playerConfig;
    private boolean dirty;
    protected boolean beenUsed;
    private long registeredActivity;
    private boolean replacementInProgress;
    private final Deque<PlayerClaimReplaceSpreadoutTask> replaceTaskQueue;

    public ServerPlayerClaimInfo(IPlayerConfig playerConfig, String username, UUID playerId, Map<class_2960, PlayerDimensionClaims> claims, ServerPlayerClaimInfoManager manager, Deque<PlayerClaimReplaceSpreadoutTask> replaceSpreadoutTasks) {
        super(username, playerId, claims, manager);
        this.playerConfig = playerConfig;
        this.replaceTaskQueue = replaceSpreadoutTasks;
        if (manager.getExpirationHandler() != null) {
            this.registeredActivity = manager.getExpirationHandler().getServerInfo().getTotalUseTime();
        }
    }

    @Override
    public void onClaim(IPlayerConfigManager configManager, class_2960 dimension, PlayerChunkClaim claim, int x, int z) {
        super.onClaim(configManager, dimension, claim, x, z);
        if (claim.isForceloadable()) {
            ((ServerPlayerClaimInfoManager)this.manager).getTicketManager().addTicket(configManager, dimension, this.playerId, x, z);
        }
        this.setDirty(true);
        this.beenUsed = true;
        if (((ServerPlayerClaimInfoManager)this.manager).isLoaded()) {
            ((ServerPlayerClaimInfoManager)this.manager).getClaimsManager().getClaimsManagerSynchronizer().trySyncClaimLimits(configManager, this.playerId);
        }
    }

    @Override
    public void onUnclaim(IPlayerConfigManager configManager, class_2960 dimension, PlayerChunkClaim claim, int x, int z) {
        super.onUnclaim(configManager, dimension, claim, x, z);
        if (claim.isForceloadable()) {
            ((ServerPlayerClaimInfoManager)this.manager).getTicketManager().removeTicket(configManager, dimension, this.playerId, x, z);
        }
        this.setDirty(true);
        this.beenUsed = true;
        if (((ServerPlayerClaimInfoManager)this.manager).isLoaded()) {
            ((ServerPlayerClaimInfoManager)this.manager).getClaimsManager().getClaimsManagerSynchronizer().trySyncClaimLimits(configManager, this.playerId);
        }
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void setDirty(boolean dirty) {
        if (dirty && !((ServerPlayerClaimInfoManager)this.manager).isLoaded()) {
            return;
        }
        if (!this.dirty && dirty) {
            ((ServerPlayerClaimInfoManager)this.manager).addToSave(this);
        }
        this.dirty = dirty;
    }

    @Override
    public String getFileName() {
        return this.playerId.toString();
    }

    @Override
    public void setPlayerUsername(String playerUsername) {
        boolean changed = !Objects.equals(this.getPlayerUsername(), playerUsername);
        super.setPlayerUsername(playerUsername);
        if (changed) {
            if (this.beenUsed) {
                this.setDirty(true);
            }
            ((ServerPlayerClaimInfoManager)this.manager).getClaimsManager().getClaimsManagerSynchronizer().syncToPlayersClaimOwnerPropertiesUpdate(this);
        }
    }

    @Override
    protected Stream<Map.Entry<class_2960, PlayerDimensionClaims>> getDimensionClaimCountStream() {
        return this.getTypedStream();
    }

    @Override
    protected Stream<Map.Entry<class_2960, PlayerDimensionClaims>> getDimensionForceloadCountStream() {
        boolean unclaimableForceloadsAllowed = Objects.equals(this.playerId, PlayerConfig.SERVER_CLAIM_UUID) || (Boolean)ServerConfig.CONFIG.allowExistingClaimsInUnclaimableDimensions.get() != false && (Boolean)ServerConfig.CONFIG.allowExistingForceloadsInUnclaimableDimensions.get() != false;
        return this.claims.entrySet().stream().filter(e -> unclaimableForceloadsAllowed || ((ServerPlayerClaimInfoManager)this.manager).isClaimable((class_2960)e.getKey()));
    }

    @Override
    @Nonnull
    public Stream<Map.Entry<class_2960, PlayerDimensionClaims>> getTypedStream() {
        boolean unclaimableClaimsAllowed = Objects.equals(this.playerId, PlayerConfig.SERVER_CLAIM_UUID) || (Boolean)ServerConfig.CONFIG.allowExistingClaimsInUnclaimableDimensions.get() != false;
        return this.claims.entrySet().stream().filter(e -> unclaimableClaimsAllowed || ((ServerPlayerClaimInfoManager)this.manager).isClaimable((class_2960)e.getKey()));
    }

    @Override
    public Stream<Map.Entry<class_2960, PlayerDimensionClaims>> getFullStream() {
        return this.claims.entrySet().stream();
    }

    @Override
    public void registerActivity(ServerInfo serverInfo) {
        if (serverInfo.getTotalUseTime() < this.registeredActivity) {
            return;
        }
        this.registeredActivity = serverInfo.getTotalUseTime();
        this.setDirty(true);
    }

    public void setRegisteredActivity(long registeredActivity) {
        this.registeredActivity = registeredActivity;
    }

    @Override
    public long getRegisteredActivity() {
        return this.registeredActivity;
    }

    @Override
    public String getClaimsName() {
        return this.playerConfig.getEffective(PlayerConfigOptions.CLAIMS_NAME);
    }

    @Override
    public int getClaimsColor() {
        return this.playerConfig.getEffective(PlayerConfigOptions.CLAIMS_COLOR);
    }

    @Override
    @Nullable
    public String getClaimsName(int subConfigIndex) {
        IPlayerConfig subConfig = this.playerConfig.getEffectiveSubConfig(subConfigIndex);
        if (subConfig.getSubIndex() != subConfigIndex) {
            return null;
        }
        return subConfig.getRaw(PlayerConfigOptions.CLAIMS_NAME);
    }

    @Override
    @Nullable
    public Integer getClaimsColor(int subConfigIndex) {
        IPlayerConfig subConfig = this.playerConfig.getEffectiveSubConfig(subConfigIndex);
        if (subConfig.getSubIndex() != subConfigIndex) {
            return null;
        }
        return subConfig.getRaw(PlayerConfigOptions.CLAIMS_COLOR);
    }

    @Override
    @Nullable
    public String getClaimsName(@Nonnull String subId) {
        IPlayerConfig subConfig = this.playerConfig.getSubConfig(subId);
        if (subConfig == null) {
            return null;
        }
        return subConfig.getRaw(PlayerConfigOptions.CLAIMS_NAME);
    }

    @Override
    public Integer getClaimsColor(@Nonnull String subId) {
        IPlayerConfig subConfig = this.playerConfig.getSubConfig(subId);
        if (subConfig == null) {
            return null;
        }
        return subConfig.getRaw(PlayerConfigOptions.CLAIMS_COLOR);
    }

    @Override
    public boolean isReplacementInProgress() {
        return this.replacementInProgress;
    }

    @Override
    public void setReplacementInProgress(boolean replacementInProgress) {
        this.replacementInProgress = replacementInProgress;
    }

    @Override
    public boolean hasReplacementTasks() {
        return this.replacementInProgress || !this.replaceTaskQueue.isEmpty();
    }

    @Override
    public void addReplacementTask(PlayerClaimReplaceSpreadoutTask task, IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData) {
        if (!this.replacementInProgress) {
            ((ServerPlayerClaimInfoManager)this.manager).getClaimsManager().getClaimReplaceTaskHandler().addTask(task, serverData);
        } else {
            this.replaceTaskQueue.add(task);
        }
    }

    @Override
    public PlayerClaimReplaceSpreadoutTask removeNextReplacementTask() {
        return this.replaceTaskQueue.removeFirst();
    }

    @Override
    public IPlayerConfig getConfig() {
        return this.playerConfig;
    }
}

