/*
 * Decompiled with CFR 0.152.
 */
package su.plo.lib.api;

public final class MathLib {
    public static int floor(float value) {
        int i = (int)value;
        return value < (float)i ? i - 1 : i;
    }

    public static int fastFloor(double value) {
        return (int)(value + 1024.0) - 1024;
    }

    public static int floor(double value) {
        int i = (int)value;
        return value < (double)i ? i - 1 : i;
    }

    public static long lfloor(double value) {
        long l = (long)value;
        return value < (double)l ? l - 1L : l;
    }

    public static int ceil(float value) {
        int i = (int)value;
        return value > (float)i ? i + 1 : i;
    }

    public static int ceil(double value) {
        int i = (int)value;
        return value > (double)i ? i + 1 : i;
    }

    public static byte clamp(byte value, byte min, byte max) {
        if (value < min) {
            return min;
        }
        return value > max ? max : value;
    }

    public static int clamp(int value, int min, int max) {
        if (value < min) {
            return min;
        }
        return Math.min(value, max);
    }

    public static long clamp(long value, long min, long max) {
        if (value < min) {
            return min;
        }
        return Math.min(value, max);
    }

    public static float clamp(float value, float min, float max) {
        if (value < min) {
            return min;
        }
        return Math.min(value, max);
    }

    public static double clamp(double value, double min, double max) {
        if (value < min) {
            return min;
        }
        return Math.min(value, max);
    }

    public static double clampedLerp(double start2, double end, double delta) {
        if (delta < 0.0) {
            return start2;
        }
        return delta > 1.0 ? end : MathLib.lerp(delta, start2, end);
    }

    public static float clampedLerp(float start2, float end, float delta) {
        if (delta < 0.0f) {
            return start2;
        }
        return delta > 1.0f ? end : MathLib.lerp(delta, start2, end);
    }

    public static float lerp(float delta, float start2, float end) {
        return start2 + delta * (end - start2);
    }

    public static double lerp(double delta, double start2, double end) {
        return start2 + delta * (end - start2);
    }

    private MathLib() {
    }
}

