/*
 * Decompiled with CFR 0.152.
 */
package su.plo.lib.api.server.command;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import su.plo.lib.api.server.command.MinecraftCommand;
import su.plo.lib.api.server.command.MinecraftCommandSource;

public abstract class MinecraftCommandManager<T extends MinecraftCommand> {
    protected final Map<String, T> commandByName = Maps.newHashMap();
    protected boolean registered;

    public synchronized void register(@NotNull String name, @NotNull T command2, String ... aliases) {
        if (this.registered) {
            throw new IllegalStateException("register after commands registration is not supported");
        }
        if (this.commandByName.containsKey(name)) {
            throw new IllegalArgumentException("Command with name '" + name + "' already exist");
        }
        for (String alias : aliases) {
            if (!this.commandByName.containsKey(alias)) continue;
            throw new IllegalArgumentException("Command with name '" + alias + "' already exist");
        }
        this.commandByName.put(name, command2);
        for (String alias : aliases) {
            this.commandByName.put(alias, command2);
        }
    }

    public synchronized Map<String, MinecraftCommand> getRegisteredCommands() {
        return ImmutableMap.copyOf(this.commandByName);
    }

    public synchronized void clear() {
        this.commandByName.clear();
        this.registered = false;
    }

    public abstract MinecraftCommandSource getCommandSource(@NotNull Object var1);
}

