/*
 * Decompiled with CFR 0.152.
 */
package su.plo.lib.mod.client.gui.components;

import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import su.plo.lib.api.chat.MinecraftTextComponent;
import su.plo.lib.mod.client.gui.components.AbstractButton;
import su.plo.lib.mod.client.gui.narration.NarrationOutput;
import su.plo.voice.universal.UMatrixStack;

public class Button
extends AbstractButton {
    public static final OnTooltip NO_TOOLTIP = (button, render, mouseX, mouseY) -> {};
    public static final OnPress NO_ACTION = button -> {};
    protected final OnPress pressAction;
    protected final OnTooltip tooltipAction;

    public Button(int x, int y, int width, int height, @NotNull MinecraftTextComponent text, @NotNull OnPress pressAction, @NotNull OnTooltip tooltipAction) {
        super(x, y, width, height, text);
        this.pressAction = pressAction;
        this.tooltipAction = tooltipAction;
    }

    @Override
    public void onPress() {
        this.pressAction.onPress(this);
    }

    @Override
    public void renderButton(@NotNull UMatrixStack stack, int mouseX, int mouseY, float delta) {
        super.renderButton(stack, mouseX, mouseY, delta);
        if (this.isHoveredOrFocused()) {
            this.renderToolTip(stack, mouseX, mouseY);
        }
    }

    @Override
    public void renderToolTip(@NotNull UMatrixStack stack, int mouseX, int mouseY) {
        this.tooltipAction.onTooltip(this, stack, mouseX, mouseY);
    }

    @Override
    public void updateNarration(@NotNull NarrationOutput narrationOutput) {
        super.updateNarration(narrationOutput);
        this.tooltipAction.narrateTooltip(component -> narrationOutput.add(NarrationOutput.Type.HINT, (MinecraftTextComponent)component));
    }

    public static interface OnPress {
        public void onPress(Button var1);
    }

    public static interface OnTooltip {
        public void onTooltip(Button var1, UMatrixStack var2, int var3, int var4);

        default public void narrateTooltip(Consumer<MinecraftTextComponent> consumer2) {
        }
    }
}

