/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.api.client.config.keybind;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface KeyBinding {
    @NotNull
    public String getName();

    public Set<Key> getKeys();

    public void setKeys(@NotNull Set<Key> var1);

    public boolean isAnyContext();

    public boolean isPressed();

    public void resetState();

    public void updateState(@NotNull Action var1);

    public void addPressListener(@NotNull OnPress var1);

    public void removePressListener(@NotNull OnPress var1);

    public void clearPressListener();

    public void addKeysChangeListener(@NotNull OnKeysChange var1);

    public void removeKeysChangeListener(@NotNull OnKeysChange var1);

    public void clearKeysChangeListeners();

    public static final class Key {
        @NotNull
        private final Type type;
        private final int code;

        public boolean equals(@Nullable Object object) {
            if (this == object) {
                return true;
            }
            if (object != null && this.getClass() == object.getClass()) {
                Key key = (Key)object;
                return this.code == key.code && this.type == key.type;
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type, this.code});
        }

        public Key(@NotNull Type type, int code) {
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            this.type = type;
            this.code = code;
        }

        @NotNull
        public Type getType() {
            return this.type;
        }

        public int getCode() {
            return this.code;
        }
    }

    public static enum Type {
        KEYSYM,
        SCANCODE,
        MOUSE;

        private final Map<Integer, Key> keys = Maps.newHashMap();

        public Key getOrCreate(int keyCode) {
            return this.keys.computeIfAbsent(keyCode, k -> new Key(this, keyCode));
        }
    }

    public static enum Action {
        UP,
        DOWN,
        UNKNOWN;


        public static Action fromInt(int action) {
            return action == 0 ? UP : (action == 1 ? DOWN : UNKNOWN);
        }
    }

    @FunctionalInterface
    public static interface OnKeysChange {
        public void onKeysChange(@NotNull Set<Key> var1);
    }

    @FunctionalInterface
    public static interface OnPress {
        public void onPress(@NotNull Action var1);
    }
}

