/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.api.server.audio.capture;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.voice.api.server.audio.source.ServerAudioSource;
import su.plo.voice.api.server.connection.UdpConnectionManager;
import su.plo.voice.api.server.player.VoicePlayer;
import su.plo.voice.api.server.socket.UdpConnection;
import su.plo.voice.proto.data.audio.source.SelfSourceInfo;
import su.plo.voice.proto.data.audio.source.SourceInfo;
import su.plo.voice.proto.packets.tcp.clientbound.SelfSourceInfoPacket;
import su.plo.voice.proto.packets.udp.clientbound.SelfAudioInfoPacket;
import su.plo.voice.proto.packets.udp.clientbound.SourceAudioPacket;

public final class SelfActivationInfo {
    @NotNull
    private final UdpConnectionManager<? extends VoicePlayer, ? extends UdpConnection> udpConnections;
    private final Map<UUID, UUID> lastPlayerActivationIds = Maps.newConcurrentMap();

    public void sendAudioInfo(@NotNull VoicePlayer player, @NotNull ServerAudioSource<?> source, @NotNull UUID activationId, @NotNull SourceAudioPacket packet) {
        this.sendAudioInfo(player, source, activationId, packet, false);
    }

    public void sendAudioInfo(@NotNull VoicePlayer player, @NotNull ServerAudioSource<?> source, @NotNull UUID activationId, @NotNull SourceAudioPacket packet, boolean dataChanged) {
        UUID lastActivationId = this.lastPlayerActivationIds.put(player.getInstance().getUUID(), activationId);
        if (lastActivationId == null || !lastActivationId.equals(activationId)) {
            this.updateSelfSourceInfo(player, source, null);
        }
        this.udpConnections.getConnectionByPlayerId(player.getInstance().getUUID()).ifPresent(connection -> connection.sendPacket(new SelfAudioInfoPacket(source.getId(), packet.getSequenceNumber(), dataChanged ? packet.getData() : null, packet.getDistance())));
    }

    public void updateSelfSourceInfo(@NotNull VoicePlayer player, @NotNull ServerAudioSource<?> source, @Nullable SourceInfo sourceInfo) {
        UUID lastActivationId = this.lastPlayerActivationIds.get(player.getInstance().getUUID());
        if (lastActivationId == null) {
            return;
        }
        if (sourceInfo == null) {
            sourceInfo = source.getSourceInfo();
        }
        player.sendPacket(new SelfSourceInfoPacket(new SelfSourceInfo(sourceInfo, player.getInstance().getUUID(), lastActivationId, -1L)));
    }

    public SelfActivationInfo(@NotNull UdpConnectionManager<? extends VoicePlayer, ? extends UdpConnection> udpConnections) {
        if (udpConnections == null) {
            throw new NullPointerException("udpConnections is marked non-null but is null");
        }
        this.udpConnections = udpConnections;
    }

    public Map<UUID, UUID> getLastPlayerActivationIds() {
        return this.lastPlayerActivationIds;
    }
}

