/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.audio.codec.opus;

import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import su.plo.voice.BaseVoice;
import su.plo.voice.api.audio.codec.CodecSupplier;
import su.plo.voice.audio.codec.opus.BaseOpusDecoder;
import su.plo.voice.audio.codec.opus.BaseOpusEncoder;
import su.plo.voice.audio.codec.opus.JavaOpusDecoder;
import su.plo.voice.audio.codec.opus.JavaOpusEncoder;
import su.plo.voice.audio.codec.opus.NativeOpusDecoder;
import su.plo.voice.audio.codec.opus.NativeOpusEncoder;
import su.plo.voice.proto.data.audio.codec.CodecInfo;
import su.plo.voice.proto.data.audio.codec.opus.OpusEncoderInfo;
import su.plo.voice.util.NativesKt;

public final class OpusCodecSupplier
implements CodecSupplier<BaseOpusEncoder, BaseOpusDecoder> {
    @Override
    @NotNull
    public BaseOpusEncoder createEncoder(int sampleRate, boolean stereo, int bufferSize, int mtuSize, @NotNull CodecInfo codecInfo) {
        OpusEncoderInfo opusEncoderInfo;
        try {
            opusEncoderInfo = new OpusEncoderInfo(codecInfo);
        }
        catch (IOException e) {
            throw new IllegalStateException("Bad codec info received", e);
        }
        BaseOpusEncoder encoder2 = null;
        if (NativesKt.isNativesSupported()) {
            try {
                Class.forName("su.plo.opus.Opus");
                encoder2 = new NativeOpusEncoder(sampleRate, stereo, bufferSize, opusEncoderInfo.getMode(), mtuSize);
                encoder2.open();
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (Exception | LinkageError e) {
                encoder2 = null;
                BaseVoice.DEBUG_LOGGER.warn("Failed to load native opus. Falling back to pure java impl", e);
            }
        }
        if (encoder2 == null) {
            try {
                encoder2 = new JavaOpusEncoder(sampleRate, stereo, bufferSize, opusEncoderInfo.getMode(), mtuSize);
                encoder2.open();
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to open java opus encoder", e);
            }
        }
        encoder2.setBitrate(opusEncoderInfo.getBitrate());
        BaseVoice.DEBUG_LOGGER.log("Opus encoder bitrate is {}", encoder2.getBitrate());
        return encoder2;
    }

    @Override
    @NotNull
    public BaseOpusDecoder createDecoder(int sampleRate, boolean stereo, int bufferSize, int mtuSize, @NotNull CodecInfo codecInfo) {
        if (NativesKt.isNativesSupported()) {
            try {
                Class.forName("su.plo.opus.Opus");
                NativeOpusDecoder decoder = new NativeOpusDecoder(sampleRate, stereo, bufferSize, mtuSize);
                decoder.open();
                return decoder;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (Exception | LinkageError e) {
                BaseVoice.DEBUG_LOGGER.warn("Failed to load native opus. Falling back to pure java impl", e);
            }
        }
        try {
            JavaOpusDecoder decoder = new JavaOpusDecoder(sampleRate, stereo, bufferSize, mtuSize);
            decoder.open();
            return decoder;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to open java opus encoder", e);
        }
    }

    @Override
    @NotNull
    public String getName() {
        return "opus";
    }
}

