/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.audio.device;

import javax.sound.sampled.AudioFormat;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.openal.ALC10;
import org.lwjgl.openal.ALC11;
import su.plo.voice.api.client.PlasmoVoiceClient;
import su.plo.voice.api.client.audio.device.DeviceException;
import su.plo.voice.api.client.audio.device.InputDevice;
import su.plo.voice.api.client.event.audio.device.DeviceClosedEvent;
import su.plo.voice.api.client.event.audio.device.DeviceOpenEvent;
import su.plo.voice.api.client.event.audio.device.DevicePreOpenEvent;
import su.plo.voice.client.audio.AlUtil;
import su.plo.voice.client.audio.device.BaseAudioDevice;

public final class AlInputDevice
extends BaseAudioDevice
implements InputDevice {
    private static final Logger LOGGER = LogManager.getLogger(AlInputDevice.class);
    private long devicePointer;
    private boolean hasDisconnectEXT;
    private boolean started = false;
    private boolean disconnected = false;

    public AlInputDevice(PlasmoVoiceClient client, @NotNull String name, @NotNull AudioFormat format) throws DeviceException {
        super(client, name, format);
        this.open();
    }

    @Override
    public void close() {
        if (this.isOpen()) {
            this.stop();
            ALC11.alcCaptureCloseDevice((long)this.devicePointer);
            this.devicePointer = 0L;
            LOGGER.info("Device {} closed", (Object)this.getName());
        } else if (this.disconnected) {
            this.devicePointer = 0L;
            LOGGER.info("Device {} closed", (Object)this.getName());
        }
        this.getVoiceClient().getEventBus().call(new DeviceClosedEvent(this));
    }

    @Override
    public boolean isOpen() {
        if (this.devicePointer != 0L && this.hasDisconnectEXT && ALC11.alcGetInteger((long)this.devicePointer, (int)787) == 0 && !this.disconnected) {
            this.disconnected = true;
        }
        return this.devicePointer != 0L && !this.disconnected;
    }

    @Override
    public synchronized void start() {
        if (!this.isOpen() || this.started) {
            return;
        }
        ALC11.alcCaptureStart((long)this.devicePointer);
        if (AlUtil.checkAlcErrors(this.devicePointer, "Start device")) {
            return;
        }
        this.started = true;
    }

    @Override
    public synchronized void stop() {
        if (!this.isOpen() || !this.started) {
            return;
        }
        ALC11.alcCaptureStop((long)this.devicePointer);
        AlUtil.checkAlcErrors(this.devicePointer, "Stop capture device");
        this.started = false;
        int available = this.available();
        short[] data = new short[available];
        ALC11.alcCaptureSamples((long)this.devicePointer, (short[])data, (int)data.length);
        AlUtil.checkAlcErrors(this.devicePointer, "Capture available samples");
    }

    @Override
    public int available() {
        if (!this.isOpen() || !this.started) {
            return 0;
        }
        int samples = ALC11.alcGetInteger((long)this.devicePointer, (int)786);
        AlUtil.checkAlcErrors(this.devicePointer, "Get available samples count");
        return samples;
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    @Override
    public short[] read(int bufferSize) {
        if (!this.isOpen() || bufferSize > this.available()) {
            return null;
        }
        short[] shorts = new short[bufferSize * this.getFormat().getChannels()];
        ALC11.alcCaptureSamples((long)this.devicePointer, (short[])shorts, (int)bufferSize);
        AlUtil.checkAlcErrors(this.devicePointer, "Capture samples");
        return shorts;
    }

    @Override
    protected void open() throws DeviceException {
        if (this.isOpen()) {
            throw new DeviceException("Device is already open");
        }
        DevicePreOpenEvent preOpenEvent = new DevicePreOpenEvent(this);
        this.getVoiceClient().getEventBus().call(preOpenEvent);
        if (preOpenEvent.isCancelled()) {
            throw new DeviceException("Device opening has been canceled");
        }
        this.devicePointer = this.openDevice();
        this.disconnected = false;
        this.hasDisconnectEXT = ALC10.alcIsExtensionPresent((long)this.devicePointer, (CharSequence)"ALC_EXT_disconnect");
        LOGGER.info("Device {} initialized", (Object)this.getName());
        this.getVoiceClient().getEventBus().call(new DeviceOpenEvent(this));
    }

    private long openDevice() throws DeviceException {
        AudioFormat format = this.getFormat();
        String deviceName = this.getName();
        int alFormat = format.getChannels() == 2 ? 4355 : 4353;
        long devicePointer = ALC11.alcCaptureOpenDevice((CharSequence)deviceName, (int)((int)format.getSampleRate()), (int)alFormat, (int)this.getBufferSize());
        if (devicePointer == 0L || AlUtil.checkAlcErrors(devicePointer, "Open device")) {
            throw new DeviceException("Failed to open OpenAL device");
        }
        return devicePointer;
    }
}

