/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.audio.filter;

import org.jetbrains.annotations.NotNull;
import su.plo.config.entry.ConfigEntry;
import su.plo.voice.BaseVoice;
import su.plo.voice.api.util.AudioUtil;
import su.plo.voice.client.audio.filter.LimiterFilter;
import su.plo.voice.rnnoise.Denoiser;
import su.plo.voice.util.NativesKt;

public final class NoiseSuppressionFilter
extends LimiterFilter {
    private final ConfigEntry<Boolean> activeEntry;
    private Denoiser instance;

    public NoiseSuppressionFilter(int sampleRate, @NotNull ConfigEntry<Boolean> activeEntry) {
        super(sampleRate, Float.valueOf(-6.0f));
        this.activeEntry = activeEntry;
        if (!NativesKt.isNativesSupported()) {
            activeEntry.set(false);
            activeEntry.setDisabled(true);
        } else if (activeEntry.value().booleanValue()) {
            this.toggle(true);
        }
        activeEntry.clearChangeListeners();
        activeEntry.addChangeListener(this::toggle);
    }

    private void toggle(boolean value) {
        if (value) {
            try {
                this.instance = new Denoiser();
            }
            catch (Exception | LinkageError e) {
                BaseVoice.LOGGER.error("RNNoise is not available on this platform");
                this.activeEntry.set(false);
                this.activeEntry.setDisabled(true);
            }
        } else if (this.instance != null) {
            this.instance.close();
            this.instance = null;
        }
    }

    @Override
    @NotNull
    public String getName() {
        return "noise_suppression";
    }

    @Override
    public short[] process(short[] samples) {
        super.process(samples);
        float[] floats = AudioUtil.shortsToFloats(samples);
        samples = AudioUtil.floatsToShorts(this.instance.process(floats));
        return samples;
    }

    @Override
    public boolean isEnabled() {
        return this.instance != null && this.activeEntry.value() != false;
    }
}

