/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.gui.settings.widget;

import org.jetbrains.annotations.NotNull;
import su.plo.config.entry.IntConfigEntry;
import su.plo.lib.api.chat.MinecraftTextComponent;
import su.plo.lib.mod.client.gui.components.AbstractSlider;
import su.plo.voice.client.gui.settings.widget.UpdatableWidget;

public final class IntSliderWidget
extends AbstractSlider
implements UpdatableWidget {
    private final IntConfigEntry entry;
    private final String suffix;

    public IntSliderWidget(@NotNull IntConfigEntry entry, @NotNull String suffix, int x, int y, int width, int height) {
        super(x, y, width, height);
        this.entry = entry;
        this.suffix = suffix;
        this.updateValue();
    }

    @Override
    protected void updateText() {
        if (this.suffix != null) {
            this.setText(MinecraftTextComponent.literal(String.valueOf(this.calculateValue(this.value))).append(MinecraftTextComponent.literal(" " + this.suffix)));
        } else {
            this.setText(MinecraftTextComponent.literal(String.valueOf(this.calculateValue(this.value))));
        }
    }

    @Override
    protected void applyValue() {
        this.entry.set(this.calculateValue(this.value));
    }

    @Override
    public void updateValue() {
        this.value = (double)((Integer)this.entry.value() - this.entry.getMin()) / (double)(this.entry.getMax() - this.entry.getMin());
        this.updateText();
    }

    @Override
    public boolean isHoveredOrFocused() {
        return this.active && super.isHoveredOrFocused();
    }

    private int calculateValue(double value) {
        return (int)(value * (double)(this.entry.getMax() - this.entry.getMin()) + (double)this.entry.getMin());
    }
}

