/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.proto.data.audio.source;

import com.google.common.base.Preconditions;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import java.io.IOException;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.voice.proto.data.audio.codec.CodecInfo;
import su.plo.voice.proto.data.audio.source.SourceInfo;
import su.plo.voice.proto.data.pos.Pos3d;

public final class StaticSourceInfo
extends SourceInfo {
    private Pos3d position;
    private Pos3d lookAngle;

    public StaticSourceInfo(@NotNull String addonId, @NotNull UUID sourceId, @NotNull UUID lineId, @Nullable String sourceName, byte state, @Nullable CodecInfo decoderInfo, boolean stereo, boolean iconVisible, int angle, Pos3d position, Pos3d lookAngle) {
        super(addonId, sourceId, lineId, sourceName, state, decoderInfo, stereo, iconVisible, angle);
        this.position = position;
        this.lookAngle = lookAngle;
    }

    @Override
    public void deserialize(ByteArrayDataInput in) throws IOException {
        super.deserialize(in);
        this.position = new Pos3d();
        this.position.deserialize(in);
        this.lookAngle = new Pos3d();
        this.lookAngle.deserialize(in);
    }

    @Override
    public void serialize(ByteArrayDataOutput out) throws IOException {
        super.serialize(out);
        ((Pos3d)Preconditions.checkNotNull((Object)this.position, (Object)"position")).serialize(out);
        ((Pos3d)Preconditions.checkNotNull((Object)this.lookAngle, (Object)"lookAngle")).serialize(out);
    }

    @Override
    public SourceInfo.Type getType() {
        return SourceInfo.Type.STATIC;
    }

    public StaticSourceInfo() {
    }

    @Override
    public String toString() {
        return "StaticSourceInfo(super=" + super.toString() + ", position=" + this.getPosition() + ", lookAngle=" + this.getLookAngle() + ")";
    }

    public Pos3d getPosition() {
        return this.position;
    }

    public Pos3d getLookAngle() {
        return this.lookAngle;
    }
}

