/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.rnnoise;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import java.io.Closeable;
import java.io.File;
import java.util.concurrent.atomic.AtomicBoolean;

public class Denoiser
implements Closeable {
    private static final int FRAME_SIZE = 480;
    private Pointer state;
    private final AtomicBoolean stopped = new AtomicBoolean(false);
    private static Boolean platformSupported = null;

    public Denoiser() {
        this.state = RNNoise.INSTANCE.rnnoise_create(null);
    }

    @Override
    public void close() {
        if (this.stopped.getAndSet(true)) {
            return;
        }
        RNNoise.INSTANCE.rnnoise_destroy(this.state);
        this.state = null;
    }

    public float[] process(float[] floats) {
        if (floats.length % 480 != 0) {
            return null;
        }
        float[] chunk = new float[480];
        float[] processedChunk = new float[480];
        float[] processed = new float[floats.length];
        for (int i = 0; i < floats.length / 480; ++i) {
            System.arraycopy(floats, 480 * i, chunk, 0, 480);
            RNNoise.INSTANCE.rnnoise_process_frame(this.state, processedChunk, chunk);
            System.arraycopy(processedChunk, 0, processed, 480 * i, 480);
        }
        return processed;
    }

    private static String getExtension(String platform) {
        switch (platform) {
            case "darwin": {
                return "dylib";
            }
            case "win32-x86": 
            case "win32-x86-64": {
                return "dll";
            }
        }
        return "so";
    }

    public static boolean platformSupported() {
        if (platformSupported != null) {
            return platformSupported;
        }
        try {
            platformSupported = RNNoise.INSTANCE != null;
            return platformSupported;
        }
        catch (UnsatisfiedLinkError ignored) {
            platformSupported = false;
            return false;
        }
    }

    public static String loadFromJar() {
        String platform = Platform.RESOURCE_PREFIX;
        return String.format("/natives/rnnoise/%s/rnnoise.%s", platform, Denoiser.getExtension(platform));
    }

    public static interface RNNoise
    extends Library {
        public static final RNNoise INSTANCE = (RNNoise)Native.loadLibrary((String)NativeLibrary.getInstance((String)Denoiser.loadFromJar()).getFile().getAbsolutePath(), RNNoise.class);

        public int rnnoise_get_size();

        public int rnnoise_get_frame_size();

        public int rnnoise_init(Pointer var1, Pointer var2);

        public Pointer rnnoise_create(Pointer var1);

        public void rnnoise_destroy(Pointer var1);

        public float rnnoise_process_frame(Pointer var1, float[] var2, float[] var3);

        public Pointer rnnoise_model_from_file(File var1);

        public void rnnoise_model_free(Pointer var1);
    }
}

