/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.server.command;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.lib.api.chat.MinecraftTextComponent;
import su.plo.lib.api.server.MinecraftServerLib;
import su.plo.lib.api.server.command.MinecraftCommand;
import su.plo.lib.api.server.command.MinecraftCommandSource;
import su.plo.lib.api.server.entity.MinecraftServerPlayerEntity;
import su.plo.voice.api.server.mute.MuteDurationUnit;
import su.plo.voice.server.BaseVoiceServer;
import su.plo.voice.server.command.Suggestions;
import su.plo.voice.server.mute.VoiceMuteManager;

public final class VoiceMuteCommand
implements MinecraftCommand {
    private static final Pattern DURATION_PATTERN = Pattern.compile("^([0-9]*)([mhdwsu]|permanent)?$");
    private static final Pattern INTEGER_PATTERN = Pattern.compile("^([0-9]*)$");
    private final BaseVoiceServer voiceServer;
    private final MinecraftServerLib minecraftServer;

    @Override
    public void execute(@NotNull MinecraftCommandSource source, @NotNull String[] arguments) {
        String durationArg;
        Matcher matcher;
        if (arguments.length == 0) {
            source.sendMessage(MinecraftTextComponent.translatable("pv.error.no_permissions", new Object[0]));
            return;
        }
        Optional<MinecraftServerPlayerEntity> player = this.minecraftServer.getPlayerByName(arguments[0]);
        if (!player.isPresent()) {
            source.sendMessage(MinecraftTextComponent.translatable("pv.error.player_not_found", new Object[0]));
            return;
        }
        VoiceMuteManager muteManager = (VoiceMuteManager)this.voiceServer.getMuteManager();
        if (muteManager.getMute(player.get().getUUID()).isPresent()) {
            source.sendMessage(MinecraftTextComponent.translatable("pv.command.mute.already_muted", player.get().getName()));
            return;
        }
        int reasonSpaceIndex = 1;
        MuteDurationUnit durationUnit = null;
        long duration = 0L;
        if (arguments.length > 1 && (matcher = DURATION_PATTERN.matcher(durationArg = arguments[1])).find()) {
            String type = matcher.group(2);
            if (type == null || !type.equals("permanent")) {
                durationUnit = this.parseDurationUnit(type);
            }
            duration = this.parseDuration(matcher.group(1), durationUnit);
            reasonSpaceIndex = 2;
        }
        String reason = null;
        if (arguments.length > reasonSpaceIndex) {
            reason = String.join((CharSequence)" ", Arrays.copyOfRange(arguments, reasonSpaceIndex, arguments.length));
        }
        if (durationUnit == null) {
            source.sendMessage(MinecraftTextComponent.translatable("pv.command.mute.permanently_muted", player.get().getName(), muteManager.formatMuteReason(reason)));
        } else {
            try {
                source.sendMessage(MinecraftTextComponent.translatable("pv.command.mute.temporarily_muted", player.get().getName(), durationUnit.translate(duration), muteManager.formatMuteReason(reason)));
            }
            catch (IllegalArgumentException e) {
                source.sendMessage(MinecraftTextComponent.literal(e.getMessage()));
            }
        }
        UUID mutedBy = null;
        if (source instanceof MinecraftServerPlayerEntity) {
            mutedBy = ((MinecraftServerPlayerEntity)source).getUUID();
        }
        muteManager.mute(player.get().getUUID(), mutedBy, duration, durationUnit, reason, false);
    }

    @Override
    public boolean hasPermission(@NotNull MinecraftCommandSource source, @Nullable String[] arguments) {
        return source.hasPermission("pv.mute");
    }

    @Override
    public List<String> suggest(@NotNull MinecraftCommandSource source, @NotNull String[] arguments) {
        if (arguments.length <= 1) {
            return Suggestions.players(this.minecraftServer, source, arguments.length > 0 ? arguments[0] : "");
        }
        if (arguments.length == 2) {
            if (arguments[1].isEmpty()) {
                return ImmutableList.of((Object)"permanent");
            }
            if ("permanent".startsWith(arguments[1])) {
                return ImmutableList.of((Object)"permanent");
            }
            Matcher matcher = INTEGER_PATTERN.matcher(arguments[1]);
            if (matcher.find()) {
                ArrayList<String> durations = new ArrayList<String>();
                durations.add(arguments[1] + "s");
                durations.add(arguments[1] + "m");
                durations.add(arguments[1] + "h");
                durations.add(arguments[1] + "d");
                durations.add(arguments[1] + "w");
                return durations;
            }
        }
        return MinecraftCommand.super.suggest(source, arguments);
    }

    private long parseDuration(@NotNull String durationString, @Nullable MuteDurationUnit durationUnit) {
        if (durationUnit == null) {
            return 0L;
        }
        long duration = Long.parseLong(durationString);
        if (durationUnit == MuteDurationUnit.TIMESTAMP) {
            return duration * 1000L;
        }
        return duration;
    }

    private MuteDurationUnit parseDurationUnit(@Nullable String type) {
        switch (Strings.nullToEmpty((String)type)) {
            case "m": {
                return MuteDurationUnit.MINUTE;
            }
            case "h": {
                return MuteDurationUnit.HOUR;
            }
            case "d": {
                return MuteDurationUnit.DAY;
            }
            case "w": {
                return MuteDurationUnit.WEEK;
            }
            case "u": {
                return MuteDurationUnit.TIMESTAMP;
            }
        }
        return MuteDurationUnit.SECOND;
    }

    public VoiceMuteCommand(BaseVoiceServer voiceServer, MinecraftServerLib minecraftServer) {
        this.voiceServer = voiceServer;
        this.minecraftServer = minecraftServer;
    }
}

