/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.server.command;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.lib.api.chat.MinecraftTextComponent;
import su.plo.lib.api.server.command.MinecraftCommand;
import su.plo.lib.api.server.command.MinecraftCommandSource;
import su.plo.voice.api.server.player.VoicePlayer;
import su.plo.voice.api.server.player.VoiceServerPlayer;
import su.plo.voice.server.BaseVoiceServer;

public final class VoiceReloadCommand
implements MinecraftCommand {
    private final BaseVoiceServer voiceServer;

    @Override
    public void execute(@NotNull MinecraftCommandSource source, @NotNull String[] arguments) {
        this.voiceServer.loadConfig(true);
        this.voiceServer.getPlayerManager().getPlayers().stream().filter(VoicePlayer::hasVoiceChat).forEach(player -> this.voiceServer.getTcpConnectionManager().sendConfigInfo((VoiceServerPlayer)player));
        source.sendMessage(MinecraftTextComponent.translatable("pv.command.reload.message", new Object[0]));
    }

    @Override
    public boolean hasPermission(@NotNull MinecraftCommandSource source, @Nullable String[] arguments) {
        return source.hasPermission("pv.reload");
    }

    public VoiceReloadCommand(BaseVoiceServer voiceServer) {
        this.voiceServer = voiceServer;
    }
}

