/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.server.player;

import org.jetbrains.annotations.NotNull;
import su.plo.lib.api.server.entity.MinecraftServerPlayerEntity;
import su.plo.voice.api.server.PlasmoVoiceServer;
import su.plo.voice.api.server.event.connection.TcpPacketSendEvent;
import su.plo.voice.api.server.player.VoiceServerPlayer;
import su.plo.voice.proto.data.player.VoicePlayerInfo;
import su.plo.voice.proto.packets.Packet;
import su.plo.voice.proto.packets.tcp.PacketTcpCodec;
import su.plo.voice.server.player.BaseVoicePlayer;

public final class VoiceServerPlayerEntity
extends BaseVoicePlayer<MinecraftServerPlayerEntity>
implements VoiceServerPlayer {
    private final PlasmoVoiceServer voiceServer;

    public VoiceServerPlayerEntity(@NotNull PlasmoVoiceServer voiceServer, @NotNull MinecraftServerPlayerEntity player) {
        super(voiceServer, player);
        this.voiceServer = voiceServer;
    }

    @Override
    public void sendPacket(@NotNull Packet<?> packet) {
        byte[] encoded = PacketTcpCodec.encode(packet);
        TcpPacketSendEvent event = new TcpPacketSendEvent(this, packet);
        if (!this.voiceServer.getEventBus().call(event)) {
            return;
        }
        ((MinecraftServerPlayerEntity)this.instance).sendPacket("plasmo:voice/v2", encoded);
    }

    @Override
    public boolean hasVoiceChat() {
        return this.voiceServer.getUdpConnectionManager().getConnectionByPlayerId(((MinecraftServerPlayerEntity)this.instance).getUUID()).isPresent();
    }

    @Override
    public VoicePlayerInfo createPlayerInfo() {
        if (!this.hasVoiceChat()) {
            throw new IllegalStateException("Player is not connected to UDP server");
        }
        return new VoicePlayerInfo(((MinecraftServerPlayerEntity)this.instance).getUUID(), ((MinecraftServerPlayerEntity)this.instance).getName(), this.voiceServer.getMuteManager().getMute(((MinecraftServerPlayerEntity)this.instance).getUUID()).isPresent(), this.isVoiceDisabled(), this.isMicrophoneMuted());
    }

    @Override
    public String toString() {
        return "VoiceServerPlayerEntity(super=" + super.toString() + ", voiceServer=" + this.voiceServer + ")";
    }
}

