/*
 * Decompiled with CFR 0.152.
 */
package com.seacroak.plushables.block;

import com.seacroak.plushables.block.tile.BasketBlockEntity;
import com.seacroak.plushables.config.ClientConfigValues;
import com.seacroak.plushables.config.PlushablesConfig;
import com.seacroak.plushables.item.PlushableBlockItem;
import com.seacroak.plushables.networking.PlushablesNetworking;
import com.seacroak.plushables.networking.SoundPacketHandler;
import com.seacroak.plushables.registry.assets.SoundRegistry;
import com.seacroak.plushables.registry.uncommon.TileRegistry;
import java.util.List;
import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1927;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2464;
import net.minecraft.class_2498;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_6575;
import org.jetbrains.annotations.Nullable;

public class BasketBlock
extends class_2237 {
    public static class_6575 random;
    final class_265 blockShape = this.getShape();

    public BasketBlock() {
        super((class_4970.class_2251)FabricBlockSettings.create().sounds(class_2498.field_11547).strength(1.0f).nonOpaque());
        random = new class_6575(100L);
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return BasketBlock.method_31618(type, TileRegistry.BASKET_TILE, BasketBlockEntity::tick);
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_1799 heldStack;
        if (!player.method_7294()) {
            return class_1269.field_21466;
        }
        BasketBlockEntity be = (BasketBlockEntity)world.method_8321(pos);
        float randomPitch = 0.85f + random.method_43057() / 4.0f;
        if (be == null) {
            return class_1269.field_5814;
        }
        if (!player.method_5715()) {
            class_3218 serverWorld;
            class_1799 heldItem = player.method_6118(class_1304.field_6173);
            if (heldItem.method_31574(class_1802.field_8162)) {
                return class_1269.field_21466;
            }
            if (world.field_9236) {
                if (!ClientConfigValues.allow_all_block_items_in_baskets && !(heldItem.method_7909() instanceof PlushableBlockItem)) {
                    return class_1269.field_21466;
                }
            } else if (world instanceof class_3218) {
                serverWorld = (class_3218)world;
                if (!PlushablesConfig.allow_all_block_items_in_baskets && !(heldItem.method_7909() instanceof PlushableBlockItem)) {
                    return class_1269.field_21466;
                }
            }
            if (be.pushPlush(player)) {
                if (world instanceof class_3218) {
                    serverWorld = (class_3218)world;
                    SoundPacketHandler.sendPlayerPacketToClients(serverWorld, new SoundPacketHandler.PlayerSoundPacket(player, pos, SoundRegistry.BASKET_IN, randomPitch));
                } else if (world.field_9236) {
                    PlushablesNetworking.playSoundOnClient(SoundRegistry.BASKET_IN, world, pos, 1.0f, randomPitch);
                }
                return class_1269.field_5812;
            }
            return class_1269.field_21466;
        }
        if (player.method_5715() && (heldStack = player.method_6118(class_1304.field_6173)).method_31574(class_1802.field_8162)) {
            if (be.popPlush(player)) {
                if (world instanceof class_3218) {
                    class_3218 serverWorld = (class_3218)world;
                    SoundPacketHandler.sendPlayerPacketToClients(serverWorld, new SoundPacketHandler.PlayerSoundPacket(player, pos, SoundRegistry.BASKET_OUT, randomPitch));
                } else if (world.field_9236) {
                    PlushablesNetworking.playSoundOnClient(SoundRegistry.BASKET_OUT, world, pos, 1.0f, randomPitch);
                }
                return class_1269.field_5812;
            }
            return class_1269.field_21466;
        }
        return class_1269.field_5812;
    }

    public void method_9606(class_2680 state, class_1937 world, class_2338 pos, class_1657 player) {
        if (!player.method_7294()) {
            return;
        }
        float randomPitch = 0.85f + random.method_43057() / 4.0f;
        class_2586 be = world.method_8321(pos);
        if (!(be instanceof BasketBlockEntity)) {
            return;
        }
        class_1799[] poppedStack = ((BasketBlockEntity)be).popAll(player);
        if (poppedStack[0].method_31574(class_1802.field_8162)) {
            return;
        }
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            SoundPacketHandler.sendPlayerPacketToClients(serverWorld, new SoundPacketHandler.PlayerSoundPacket(player, pos, SoundRegistry.BASKET_ATTACK, randomPitch));
            for (class_1799 plush : poppedStack) {
                class_1264.method_5449((class_1937)world, (double)((double)pos.method_10263() + 0.5 + 0.5 * (double)(2.0f * random.method_43057() - 1.0f)), (double)((double)pos.method_10264() + 0.5 + (double)random.method_43057()), (double)((double)pos.method_10260() + 0.5 + 0.5 * (double)(2.0f * random.method_43057() - 1.0f)), (class_1799)plush);
            }
        } else if (world.field_9236) {
            PlushablesNetworking.playSoundOnClient(SoundRegistry.BASKET_ATTACK, world, pos, 1.0f, randomPitch);
        }
        super.method_9606(state, world, pos, player);
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        if (state.method_27852(newState.method_26204())) {
            return;
        }
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof BasketBlockEntity) {
            world.method_8455(pos, (class_2248)this);
        }
        super.method_9536(state, world, pos, newState, moved);
    }

    public class_265 getShape() {
        class_265 shape = class_259.method_1073();
        shape = class_259.method_1084((class_265)shape, (class_265)class_259.method_1081((double)0.125, (double)0.00625, (double)0.125, (double)0.875, (double)0.06875, (double)0.875));
        shape = class_259.method_1084((class_265)shape, (class_265)class_259.method_1081((double)0.875, (double)0.0, (double)0.125, (double)0.9375, (double)0.9375, (double)0.875));
        shape = class_259.method_1084((class_265)shape, (class_265)class_259.method_1081((double)0.0625, (double)0.0, (double)0.125, (double)0.125, (double)0.9375, (double)0.875));
        shape = class_259.method_1084((class_265)shape, (class_265)class_259.method_1081((double)0.125, (double)0.0, (double)0.0625, (double)0.875, (double)0.9375, (double)0.125));
        shape = class_259.method_1084((class_265)shape, (class_265)class_259.method_1081((double)0.125, (double)0.0, (double)0.875, (double)0.875, (double)0.9375, (double)0.9375));
        return shape;
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return this.blockShape;
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return TileRegistry.BASKET_TILE.method_11032(pos, state);
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    public void method_9568(class_1799 stack, @Nullable class_1922 world, List<class_2561> tooltip, class_1836 options) {
        if (!ClientConfigValues.enable_baskets) {
            tooltip.add((class_2561)class_2561.method_43471((String)"block.plushables.disabled"));
        } else {
            tooltip.add((class_2561)class_2561.method_43471((String)"block.plushables.basket.tooltip.line_1"));
            tooltip.add((class_2561)class_2561.method_43471((String)"block.plushables.basket.tooltip.line_2"));
            tooltip.add((class_2561)class_2561.method_43471((String)"block.plushables.basket.tooltip.line_3"));
        }
        if (ClientConfigValues.allow_all_block_items_in_baskets) {
            tooltip.add((class_2561)class_2561.method_43471((String)"block.plushables.basket.tooltip.experimental_enabled"));
        }
        super.method_9568(stack, world, tooltip, options);
    }

    public void method_9586(class_1937 world, class_2338 pos, class_1927 explosion) {
        super.method_9586(world, pos, explosion);
        if (world instanceof class_3218) {
            class_3218 serverworld = (class_3218)world;
            class_1264.method_5449((class_1937)world, (double)(pos.method_10263() + 2), (double)pos.method_10264(), (double)(pos.method_10260() + 2), (class_1799)new class_1799((class_1935)class_1802.field_8600));
            class_1264.method_5449((class_1937)world, (double)(pos.method_10263() - 2), (double)pos.method_10264(), (double)(pos.method_10260() + 2), (class_1799)new class_1799((class_1935)class_1802.field_8600));
            class_1264.method_5449((class_1937)world, (double)(pos.method_10263() + 2), (double)pos.method_10264(), (double)(pos.method_10260() - 2), (class_1799)new class_1799((class_1935)class_1802.field_8600));
            class_1264.method_5449((class_1937)world, (double)(pos.method_10263() - 2), (double)pos.method_10264(), (double)(pos.method_10260() - 2), (class_1799)new class_1799((class_1935)class_1802.field_8600));
        }
    }

    public boolean method_9533(class_1927 explosion) {
        return false;
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 itemStack) {
        super.method_9567(world, pos, state, placer, itemStack);
        if (world.field_9236) {
            if (!ClientConfigValues.enable_baskets) {
                world.method_8501(pos, class_2246.field_10124.method_9564());
            }
        } else if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            if (!PlushablesConfig.enable_baskets) {
                world.method_8501(pos, class_2246.field_10124.method_9564());
            }
        }
        if (!ClientConfigValues.enable_baskets && !PlushablesConfig.enable_baskets) {
            assert (placer != null);
            if (world.field_9236) {
                placer.method_43496((class_2561)class_2561.method_43471((String)"block.plushables.disabled"));
            }
        }
    }
}

