/*
 * Decompiled with CFR 0.152.
 */
package com.recipeessentials.mixin;

import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.recipeessentials.RecipeEssentials;
import com.recipeessentials.recipecache.CachedRecipeList;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_3956;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1863.class}, priority=50)
public abstract class RecipeManagerMixin {
    @Shadow
    private Map<class_2960, class_1860<?>> field_36308;
    @Unique
    private Long2ObjectOpenHashMap<CachedRecipeList> recipeCache = new Long2ObjectOpenHashMap();
    @Unique
    private Object2IntOpenHashMap<class_1860> recipeIndexes = new Object2IntOpenHashMap();

    @Shadow
    public abstract <C extends class_1263, T extends class_1860<C>> List<T> method_17877(class_3956<T> var1, C var2, class_1937 var3);

    @Inject(method={"getRecipeFor(Lnet/minecraft/world/item/crafting/RecipeType;Lnet/minecraft/world/Container;Lnet/minecraft/world/level/Level;)Ljava/util/Optional;"}, at={@At(value="HEAD")}, cancellable=true)
    public <C extends class_1263, T extends class_1860<C>> void onGetRecipe(class_3956<T> recipeTypeIn, C inventoryIn, class_1937 worldIn, CallbackInfoReturnable<Optional> c) {
        CachedRecipeList recipes = (CachedRecipeList)this.recipeCache.get(this.calcHash(inventoryIn, recipeTypeIn));
        if (recipes != null && recipes.useCount > 10 && RecipeEssentials.rand.nextInt(recipes.useCount) != 0) {
            ++recipes.useCount;
            int recipesSize = recipes.recipes.size();
            for (int i = 0; i < recipesSize; ++i) {
                class_1860 recipe = recipes.recipes.get(i);
                if (!recipe.method_8115(inventoryIn, worldIn)) continue;
                c.setReturnValue(Optional.of(recipe));
                return;
            }
        } else {
            this.method_17877(recipeTypeIn, inventoryIn, worldIn);
        }
    }

    @Inject(method={"getRecipeFor(Lnet/minecraft/world/item/crafting/RecipeType;Lnet/minecraft/world/Container;Lnet/minecraft/world/level/Level;)Ljava/util/Optional;"}, at={@At(value="RETURN")})
    private <C extends class_1263, T extends class_1860<C>> void onEndGetRecipe(class_3956<T> recipeTypeIn, C inventoryIn, class_1937 worldIn, CallbackInfoReturnable<Optional<T>> c) {
        long hash;
        Optional val = (Optional)c.getReturnValue();
        if (val.isPresent() && (hash = this.calcHash(inventoryIn, recipeTypeIn)) != -1L) {
            CachedRecipeList recipeList = (CachedRecipeList)this.recipeCache.get(hash);
            if (recipeList == null) {
                recipeList = new CachedRecipeList(recipeTypeIn, inventoryIn);
                this.recipeCache.put(hash, (Object)recipeList);
            }
            ++recipeList.useCount;
            if (!recipeList.recipes.contains(val.get())) {
                recipeList.recipes.add((class_1860)val.get());
                recipeList.recipes.sort(Comparator.comparingInt(arg_0 -> this.recipeIndexes.getInt(arg_0)));
            }
        }
    }

    @Inject(method={"getRecipeFor(Lnet/minecraft/world/item/crafting/RecipeType;Lnet/minecraft/world/Container;Lnet/minecraft/world/level/Level;Lnet/minecraft/resources/ResourceLocation;)Ljava/util/Optional;"}, at={@At(value="INVOKE", target="Ljava/util/Map;entrySet()Ljava/util/Set;", remap=false)}, cancellable=true)
    public <C extends class_1263, T extends class_1860<C>> void onGetRecipe(class_3956<T> recipeTypeIn, C inventoryIn, class_1937 worldIn, class_2960 p_220252_, CallbackInfoReturnable<Optional<Pair<class_2960, T>>> cir) {
        CachedRecipeList recipes = (CachedRecipeList)this.recipeCache.get(this.calcHash(inventoryIn, recipeTypeIn));
        if (recipes != null && recipes.useCount > 10 && RecipeEssentials.rand.nextInt(recipes.useCount) != 0) {
            ++recipes.useCount;
            int recipesSize = recipes.recipes.size();
            for (int i = 0; i < recipesSize; ++i) {
                class_1860 recipe = recipes.recipes.get(i);
                if (!recipe.method_8115(inventoryIn, worldIn)) continue;
                cir.setReturnValue(Optional.of(new Pair((Object)recipe.method_8114(), (Object)recipe)));
                return;
            }
        } else {
            this.method_17877(recipeTypeIn, inventoryIn, worldIn);
        }
    }

    @Inject(method={"getRecipeFor(Lnet/minecraft/world/item/crafting/RecipeType;Lnet/minecraft/world/Container;Lnet/minecraft/world/level/Level;Lnet/minecraft/resources/ResourceLocation;)Ljava/util/Optional;"}, at={@At(value="TAIL")})
    private <C extends class_1263, T extends class_1860<C>> void onEndGetRecipe(class_3956<T> recipeTypeIn, C inventoryIn, class_1937 p_220251_, class_2960 p_220252_, CallbackInfoReturnable<Optional<Pair<class_2960, T>>> cir) {
        long hash;
        Optional val = (Optional)cir.getReturnValue();
        if (val.isPresent() && (hash = this.calcHash(inventoryIn, recipeTypeIn)) != -1L) {
            CachedRecipeList recipeList = (CachedRecipeList)this.recipeCache.get(hash);
            if (recipeList == null) {
                recipeList = new CachedRecipeList(recipeTypeIn, inventoryIn);
                this.recipeCache.put(hash, (Object)recipeList);
            }
            ++recipeList.useCount;
            if (!recipeList.recipes.contains(((Pair)val.get()).getSecond())) {
                recipeList.recipes.add((class_1860)((Pair)val.get()).getSecond());
                recipeList.recipes.sort(Comparator.comparingInt(arg_0 -> this.recipeIndexes.getInt(arg_0)));
            }
        }
    }

    @Inject(method={"getRecipesFor"}, at={@At(value="HEAD")}, cancellable=true)
    private <C extends class_1263, T extends class_1860<C>> void onGetRecipes(class_3956<T> recipeTypeIn, C inventoryIn, class_1937 worldIn, CallbackInfoReturnable c) {
        CachedRecipeList recipes = (CachedRecipeList)this.recipeCache.get(this.calcHash(inventoryIn, recipeTypeIn));
        if (recipes != null && recipes.useCount > 10 && RecipeEssentials.rand.nextInt(recipes.useCount) != 0) {
            ++recipes.useCount;
            ArrayList<class_1860> matches = new ArrayList<class_1860>();
            for (class_1860 recipe2 : recipes.recipes) {
                if (!recipe2.method_8115(inventoryIn, worldIn)) continue;
                matches.add(recipe2);
            }
            if (!matches.isEmpty()) {
                matches.sort(Comparator.comparing(recipe -> recipe.method_8110(worldIn.method_30349()).method_7922()));
                c.setReturnValue(matches);
                return;
            }
        }
    }

    @Inject(method={"getRecipesFor"}, at={@At(value="RETURN")})
    private <C extends class_1263, T extends class_1860<C>> void onEndgetRecipes(class_3956<T> recipeTypeIn, C inventoryIn, class_1937 worldIn, CallbackInfoReturnable<List<T>> c) {
        long hash;
        List recipes = (List)c.getReturnValue();
        if (recipes != null && (hash = this.calcHash(inventoryIn, recipeTypeIn)) != -1L) {
            CachedRecipeList recipeList = (CachedRecipeList)this.recipeCache.get(hash);
            if (recipeList == null) {
                recipeList = new CachedRecipeList(recipeTypeIn, inventoryIn);
                this.recipeCache.put(hash, (Object)recipeList);
            } else {
                ArrayList<class_1860> matches = new ArrayList<class_1860>();
                for (class_1860 recipe2 : recipeList.recipes) {
                    if (!recipe2.method_8115(inventoryIn, worldIn)) continue;
                    matches.add(recipe2);
                }
                matches.sort(Comparator.comparing(recipe -> recipe.method_8110(worldIn.method_30349()).method_7922()));
                if (!recipes.equals(matches)) {
                    recipeList.report(recipeTypeIn, inventoryIn, recipes);
                }
            }
            ++recipeList.useCount;
            boolean added = false;
            for (class_1860 recipe2 : recipes) {
                if (recipeList.recipes.contains(recipe2)) continue;
                added = true;
                recipeList.recipes.add(recipe2);
            }
            if (added) {
                recipeList.recipes.sort(Comparator.comparingInt(arg_0 -> this.recipeIndexes.getInt(arg_0)));
            }
        }
    }

    @Inject(method={"apply(Ljava/util/Map;Lnet/minecraft/server/packs/resources/ResourceManager;Lnet/minecraft/util/profiling/ProfilerFiller;)V"}, at={@At(value="RETURN")})
    private void onApply(Map<class_2960, JsonElement> p_44037_, class_3300 p_44038_, class_3695 p_44039_, CallbackInfo ci) {
        this.recipeCache = new Long2ObjectOpenHashMap();
        int index = 0;
        for (Map.Entry<class_2960, class_1860<?>> recipe : this.field_36308.entrySet()) {
            if (!recipe.getValue().method_8114().equals((Object)recipe.getKey())) {
                RecipeEssentials.LOGGER.warn("Recipe without matching ID:" + recipe.getValue().method_8114());
            }
            this.recipeIndexes.put(recipe.getValue(), index++);
        }
    }

    @Inject(method={"replaceRecipes"}, at={@At(value="RETURN")})
    private void onReplace(Iterable<class_1860<?>> p_44025_, CallbackInfo ci) {
        this.recipeCache = new Long2ObjectOpenHashMap();
        int index = 0;
        for (class_1860<?> recipe : this.field_36308.values()) {
            this.recipeIndexes.put(recipe, index++);
        }
    }

    @Unique
    private long calcHash(class_1263 inventory, class_3956 type) {
        if (inventory == null) {
            return type.hashCode();
        }
        long hash = type.hashCode();
        int size = inventory.method_5439();
        if (inventory.hashCode() != System.identityHashCode(inventory)) {
            hash = 31L * hash + (long)inventory.hashCode();
        }
        for (int i = 0; i < size; ++i) {
            class_1799 stack = inventory.method_5438(i);
            if (stack == null || stack.method_7960()) continue;
            hash = 31L * hash + (long)i;
            hash = 31L * hash + (long)stack.method_7909().hashCode();
        }
        return hash;
    }
}

