/*
 * Decompiled with CFR 0.152.
 */
package com.recipeessentials.recipecache;

import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.recipeessentials.RecipeEssentials;
import com.recipeessentials.recipecache.CachedRecipeList;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_3956;

public class RecipeManager
extends class_1863 {
    private Long2ObjectOpenHashMap<CachedRecipeList> recipeCache = new Long2ObjectOpenHashMap();
    private Object2IntOpenHashMap<class_1860> recipeIndexes = new Object2IntOpenHashMap();

    public <C extends class_1263, T extends class_1860<C>> Optional method_8132(class_3956<T> recipeTypeIn, C inventoryIn, class_1937 worldIn) {
        if (RecipeEssentials.polymorphCompat) {
            return super.method_8132(recipeTypeIn, inventoryIn, worldIn);
        }
        long hash = this.calcHash(inventoryIn, recipeTypeIn);
        CachedRecipeList recipes = (CachedRecipeList)this.recipeCache.get(hash);
        if (recipes != null && recipes.useCount > 10 && RecipeEssentials.rand.nextInt(recipes.useCount) != 0) {
            ++recipes.useCount;
            int recipesSize = recipes.recipes.size();
            for (int i = 0; i < recipesSize; ++i) {
                class_1860 recipe = recipes.recipes.get(i);
                if (!recipe.method_8115(inventoryIn, worldIn)) continue;
                return Optional.of(recipe);
            }
        } else {
            this.method_17877(recipeTypeIn, inventoryIn, worldIn);
        }
        Optional result = super.method_8132(recipeTypeIn, inventoryIn, worldIn);
        if (result.isPresent() && hash != -1L) {
            CachedRecipeList recipeList = (CachedRecipeList)this.recipeCache.get(hash);
            if (recipeList == null) {
                recipeList = new CachedRecipeList(recipeTypeIn, inventoryIn);
                this.recipeCache.put(hash, (Object)recipeList);
            }
            ++recipeList.useCount;
            if (!recipeList.recipes.contains(result.get())) {
                recipeList.recipes.add((class_1860)result.get());
                recipeList.recipes.sort(Comparator.comparingInt(arg_0 -> this.recipeIndexes.getInt(arg_0)));
            }
        }
        return result;
    }

    public <C extends class_1263, T extends class_1860<C>> Optional<Pair<class_2960, T>> method_42299(class_3956<T> recipeTypeIn, C inventoryIn, class_1937 worldIn, class_2960 p_220252_) {
        if (RecipeEssentials.polymorphCompat) {
            return super.method_42299(recipeTypeIn, inventoryIn, worldIn, p_220252_);
        }
        long hash = this.calcHash(inventoryIn, recipeTypeIn);
        CachedRecipeList recipes = (CachedRecipeList)this.recipeCache.get(hash);
        if (recipes != null && recipes.useCount > 10 && RecipeEssentials.rand.nextInt(recipes.useCount) != 0) {
            ++recipes.useCount;
            int recipesSize = recipes.recipes.size();
            for (int i = 0; i < recipesSize; ++i) {
                class_1860 recipe = recipes.recipes.get(i);
                if (!recipe.method_8115(inventoryIn, worldIn)) continue;
                return Optional.of(new Pair((Object)recipe.method_8114(), (Object)recipe));
            }
        } else {
            this.method_17877(recipeTypeIn, inventoryIn, worldIn);
        }
        Optional result = super.method_42299(recipeTypeIn, inventoryIn, worldIn, p_220252_);
        if (result.isPresent() && hash != -1L) {
            CachedRecipeList recipeList = (CachedRecipeList)this.recipeCache.get(hash);
            if (recipeList == null) {
                recipeList = new CachedRecipeList(recipeTypeIn, inventoryIn);
                this.recipeCache.put(hash, (Object)recipeList);
            }
            ++recipeList.useCount;
            if (!recipeList.recipes.contains(((Pair)result.get()).getSecond())) {
                recipeList.recipes.add((class_1860)((Pair)result.get()).getSecond());
                recipeList.recipes.sort(Comparator.comparingInt(arg_0 -> this.recipeIndexes.getInt(arg_0)));
            }
        }
        return result;
    }

    public <C extends class_1263, T extends class_1860<C>> List<T> method_17877(class_3956<T> recipeTypeIn, C inventoryIn, class_1937 worldIn) {
        long hash;
        List result;
        CachedRecipeList recipes = (CachedRecipeList)this.recipeCache.get(this.calcHash(inventoryIn, recipeTypeIn));
        if (recipes != null && recipes.useCount > 10 && RecipeEssentials.rand.nextInt(recipes.useCount) != 0) {
            ++recipes.useCount;
            ArrayList<class_1860> matches = new ArrayList<class_1860>();
            for (class_1860 recipe2 : recipes.recipes) {
                if (!recipe2.method_8115(inventoryIn, worldIn)) continue;
                matches.add(recipe2);
            }
            if (!matches.isEmpty()) {
                matches.sort(Comparator.comparing(recipe -> recipe.method_8110(worldIn.method_30349()).method_7922()));
                return matches;
            }
        }
        if ((result = super.method_17877(recipeTypeIn, inventoryIn, worldIn)) != null && !result.isEmpty() && (hash = this.calcHash(inventoryIn, recipeTypeIn)) != -1L) {
            CachedRecipeList recipeList = (CachedRecipeList)this.recipeCache.get(hash);
            if (recipeList == null) {
                recipeList = new CachedRecipeList(recipeTypeIn, inventoryIn);
                this.recipeCache.put(hash, (Object)recipeList);
            } else {
                ArrayList<class_1860> matches = new ArrayList<class_1860>();
                for (class_1860 recipe3 : recipeList.recipes) {
                    if (!recipe3.method_8115(inventoryIn, worldIn)) continue;
                    matches.add(recipe3);
                }
                matches.sort(Comparator.comparing(recipe -> recipe.method_8110(worldIn.method_30349()).method_7922()));
                if (!result.equals(matches)) {
                    recipeList.report(recipeTypeIn, inventoryIn, result);
                }
            }
            ++recipeList.useCount;
            boolean added = false;
            for (class_1860 recipe3 : result) {
                if (recipeList.recipes.contains(recipe3)) continue;
                added = true;
                recipeList.recipes.add(recipe3);
            }
            if (added) {
                recipeList.recipes.sort(Comparator.comparingInt(arg_0 -> this.recipeIndexes.getInt(arg_0)));
            }
        }
        return result;
    }

    public void method_20705(Map<class_2960, JsonElement> dataMap, class_3300 resourceManager, class_3695 profilerFiller) {
        super.method_20705(dataMap, resourceManager, profilerFiller);
        this.recipeCache = new Long2ObjectOpenHashMap();
        int index = 0;
        for (Map.Entry recipe : this.field_36308.entrySet()) {
            if (!((class_1860)recipe.getValue()).method_8114().equals(recipe.getKey())) {
                RecipeEssentials.LOGGER.warn("Recipe without matching ID:" + ((class_1860)recipe.getValue()).method_8114());
            }
            this.recipeIndexes.put((Object)((class_1860)recipe.getValue()), index++);
        }
    }

    public void method_20702(Iterable<class_1860<?>> recipeIterator) {
        super.method_20702(recipeIterator);
        this.recipeCache = new Long2ObjectOpenHashMap();
        int index = 0;
        for (class_1860 recipe : this.field_36308.values()) {
            this.recipeIndexes.put((Object)recipe, index++);
        }
    }

    private long calcHash(class_1263 inventory, class_3956 type) {
        if (inventory == null) {
            return type.hashCode();
        }
        long hash = type.hashCode();
        int size = inventory.method_5439();
        if (inventory.hashCode() != System.identityHashCode(inventory)) {
            hash = 31L * hash + (long)inventory.hashCode();
        }
        for (int i = 0; i < size; ++i) {
            class_1799 stack = inventory.method_5438(i);
            if (stack == null || stack.method_7960()) continue;
            hash = 31L * hash + (long)i;
            hash = 31L * hash + (long)stack.method_7909().hashCode();
        }
        return hash;
    }
}

