/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mrcrayfish.furniture.refurbished.block.FurnitureHorizontalBlock;
import com.mrcrayfish.furniture.refurbished.block.IKitchenCabinetry;
import com.mrcrayfish.furniture.refurbished.util.VoxelShapeHelper;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.class_1750;
import net.minecraft.class_1936;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3542;
import net.minecraft.class_4970;

public class KitchenCabinetryBlock
extends FurnitureHorizontalBlock
implements IKitchenCabinetry {
    public static final class_2754<Shape> SHAPE = class_2754.method_11850((String)"shape", Shape.class);

    public KitchenCabinetryBlock(class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)((class_2680)((class_2680)this.method_9595().method_11664()).method_11657((class_2769)DIRECTION, (Comparable)class_2350.field_11043)).method_11657(SHAPE, (Comparable)((Object)Shape.DEFAULT)));
    }

    @Override
    protected Map<class_2680, class_265> generateShapes(ImmutableList<class_2680> states) {
        class_265 topShape = class_2248.method_9541((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        class_265 baseShape = class_2248.method_9541((double)2.0, (double)0.0, (double)2.0, (double)16.0, (double)13.0, (double)14.0);
        class_265 baseLeftShape = class_2248.method_9541((double)2.0, (double)0.0, (double)0.0, (double)16.0, (double)13.0, (double)2.0);
        class_265 baseRightShape = class_2248.method_9541((double)2.0, (double)0.0, (double)14.0, (double)16.0, (double)13.0, (double)16.0);
        class_265 insideCornerLeftShape = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)13.0, (double)14.0);
        class_265 insideCornerRightShape = class_2248.method_9541((double)0.0, (double)0.0, (double)2.0, (double)2.0, (double)13.0, (double)16.0);
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (class_2680 state : states) {
            class_2350 direction = (class_2350)state.method_11654((class_2769)DIRECTION);
            Shape shape = (Shape)((Object)state.method_11654(SHAPE));
            ArrayList<class_265> shapes = new ArrayList<class_265>();
            shapes.add(topShape);
            shapes.add(VoxelShapeHelper.rotateHorizontally(baseShape, direction));
            if (shape != Shape.OUTSIDE_CORNER_LEFT) {
                shapes.add(VoxelShapeHelper.rotateHorizontally(baseLeftShape, direction));
            }
            if (shape != Shape.OUTSIDE_CORNER_RIGHT) {
                shapes.add(VoxelShapeHelper.rotateHorizontally(baseRightShape, direction));
            }
            class_265 cornerShape = switch (shape) {
                case Shape.INSIDE_CORNER_LEFT -> insideCornerLeftShape;
                case Shape.INSIDE_CORNER_RIGHT -> insideCornerRightShape;
                default -> class_259.method_1073();
            };
            shapes.add(VoxelShapeHelper.rotateHorizontally(cornerShape, direction));
            builder.put((Object)state, (Object)VoxelShapeHelper.combine(shapes));
        }
        return builder.build();
    }

    @Override
    public class_2680 method_9605(class_1750 context) {
        class_2680 state = super.method_9605(context);
        return state != null ? (class_2680)state.method_11657(SHAPE, (Comparable)((Object)this.getShape(state, (class_1936)context.method_8045(), context.method_8037()))) : null;
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 newState, class_1936 level, class_2338 pos, class_2338 newPos) {
        return (class_2680)state.method_11657(SHAPE, (Comparable)((Object)this.getShape(state, level, pos)));
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{SHAPE});
    }

    public Shape getShape(class_2680 state, class_1936 level, class_2338 pos) {
        class_2350 behind;
        class_2350 facing = (class_2350)state.method_11654((class_2769)DIRECTION);
        class_2350 front = this.getCabinetryDirection(level, pos, ((class_2350)state.method_11654((class_2769)DIRECTION)).method_10153());
        if (front != null) {
            if (front == facing.method_10170()) {
                return Shape.INSIDE_CORNER_RIGHT;
            }
            if (front == facing.method_10160()) {
                return Shape.INSIDE_CORNER_LEFT;
            }
        }
        if ((behind = this.getCabinetryDirection(level, pos, (class_2350)state.method_11654((class_2769)DIRECTION))) != null) {
            if (behind == facing.method_10170()) {
                return Shape.OUTSIDE_CORNER_LEFT;
            }
            if (behind == facing.method_10160()) {
                return Shape.OUTSIDE_CORNER_RIGHT;
            }
        }
        return Shape.DEFAULT;
    }

    public class_2350 getCabinetryDirection(class_1936 level, class_2338 pos, class_2350 side) {
        class_2350 class_23502;
        class_2680 relativeState = level.method_8320(pos.method_10093(side));
        class_2248 class_22482 = relativeState.method_26204();
        if (class_22482 instanceof IKitchenCabinetry) {
            IKitchenCabinetry cabinetry = (IKitchenCabinetry)class_22482;
            class_23502 = cabinetry.getDirection(relativeState);
        } else {
            class_23502 = null;
        }
        return class_23502;
    }

    @Override
    public class_2350 getDirection(class_2680 state) {
        return (class_2350)state.method_11654((class_2769)DIRECTION);
    }

    public static enum Shape implements class_3542
    {
        DEFAULT("default"),
        INSIDE_CORNER_LEFT("inside_corner_left"),
        INSIDE_CORNER_RIGHT("inside_corner_right"),
        OUTSIDE_CORNER_LEFT("outside_corner_left"),
        OUTSIDE_CORNER_RIGHT("outside_corner_right");

        private final String name;

        private Shape(String name) {
            this.name = name;
        }

        public String method_15434() {
            return this.name;
        }
    }
}

