/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.blockentity;

import com.mrcrayfish.framework.network.message.IMessage;
import com.mrcrayfish.furniture.refurbished.Config;
import com.mrcrayfish.furniture.refurbished.block.BasinBlock;
import com.mrcrayfish.furniture.refurbished.blockentity.IWaterTap;
import com.mrcrayfish.furniture.refurbished.blockentity.fluid.FluidContainer;
import com.mrcrayfish.furniture.refurbished.blockentity.fluid.IFluidContainerBlock;
import com.mrcrayfish.furniture.refurbished.core.ModBlockEntities;
import com.mrcrayfish.furniture.refurbished.core.ModParticleTypes;
import com.mrcrayfish.furniture.refurbished.core.ModSounds;
import com.mrcrayfish.furniture.refurbished.network.Network;
import com.mrcrayfish.furniture.refurbished.network.message.MessageWaterTapAnimation;
import com.mrcrayfish.furniture.refurbished.platform.Services;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import it.unimi.dsi.fastutil.Pair;
import java.util.Objects;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3965;

public class BasinBlockEntity
extends class_2586
implements IFluidContainerBlock,
IWaterTap {
    protected final FluidContainer tank;
    private int animationTime;

    public BasinBlockEntity(class_2338 pos, class_2680 state) {
        this((class_2591)ModBlockEntities.BASIN.get(), pos, state);
    }

    public BasinBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.tank = FluidContainer.create((Long)Config.SERVER.basin.fluidCapacity.get(), container -> {
            this.method_5431();
            container.sync(this);
        });
    }

    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    @Override
    public FluidContainer getFluidContainer() {
        return this.tank;
    }

    public class_1269 interact(class_1657 player, class_1268 hand, class_3965 result) {
        if (((Boolean)Config.SERVER.basin.dispenseWater.get()).booleanValue() && player.method_5998(hand).method_7960() && result.method_17780() != class_2350.field_11033) {
            Pair<class_3611, Long> drained;
            long filled;
            if ((this.tank.isEmpty() || this.tank.getStoredFluid().method_15780((class_3611)class_3612.field_15910)) && (filled = this.tank.push((class_3611)class_3612.field_15910, FluidContainer.BUCKET_CAPACITY, false)) > 0L) {
                Network.getPlay().sendToTrackingBlockEntity(() -> this, (IMessage)new MessageWaterTapAnimation(this.field_11867));
                Objects.requireNonNull(this.field_11863).method_45447(null, this.field_11867, (class_3414)ModSounds.BLOCK_KITCHEN_SINK_FILL.get(), class_3419.field_15245);
                return class_1269.field_5812;
            }
            if (this.tank.getStoredAmount() >= FluidContainer.BUCKET_CAPACITY && this.tank.getStoredFluid().method_15780((class_3611)class_3612.field_15908) && (Long)(drained = this.tank.pull(FluidContainer.BUCKET_CAPACITY, true)).right() == FluidContainer.BUCKET_CAPACITY) {
                this.tank.pull(FluidContainer.BUCKET_CAPACITY, false);
                class_243 pos = class_243.method_24955((class_2382)this.field_11867).method_1031(0.0, 1.0, 0.0);
                class_1937 level = Objects.requireNonNull(this.field_11863);
                class_1542 entity = new class_1542(level, pos.field_1352, pos.field_1351, pos.field_1350, new class_1799((class_1935)class_2246.field_10540));
                entity.method_6988();
                level.method_8649((class_1297)entity);
                level.method_45447(null, this.field_11867, class_3417.field_19198, class_3419.field_15245);
                level.method_20290(1501, this.field_11867, 0);
                Network.getPlay().sendToTrackingBlockEntity(() -> this, (IMessage)new MessageWaterTapAnimation(this.field_11867));
                return class_1269.field_5812;
            }
        }
        return Services.FLUID.performInteractionWithBlock(player, hand, this.method_10997(), this.method_11016(), result.method_17780());
    }

    @Override
    public void playWaterAnimation() {
        this.animationTime = 4;
    }

    public static void clientTick(class_1937 level, class_2338 pos, class_2680 state, BasinBlockEntity basin) {
        if (basin.animationTime > 0) {
            class_243 tap = class_243.method_24955((class_2382)pos).method_1031(0.0, Utils.pixels(18.0), 0.0);
            tap = tap.method_43206((class_2350)state.method_11654((class_2769)BasinBlock.DIRECTION), Utils.pixels(2.0));
            for (int i = 0; i < 5; ++i) {
                double x = tap.field_1352 + Utils.pixels(0.5) * level.field_9229.method_43059();
                double z = tap.field_1350 + Utils.pixels(0.5) * level.field_9229.method_43059();
                level.method_8406((class_2394)ModParticleTypes.TAP_WATER.get(), x, tap.field_1351, z, 0.0, 0.0, 0.0);
            }
            --basin.animationTime;
        }
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        this.tank.load(tag.method_10562("FluidTank"));
    }

    protected void method_11007(class_2487 tag) {
        super.method_11007(tag);
        class_2487 tankTag = new class_2487();
        this.tank.save(tankTag);
        tag.method_10566("FluidTank", (class_2520)tankTag);
    }
}

