/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.blockentity;

import com.google.common.collect.ImmutableList;
import com.mrcrayfish.framework.network.message.IMessage;
import com.mrcrayfish.furniture.refurbished.block.RangeHoodBlock;
import com.mrcrayfish.furniture.refurbished.blockentity.FlipAnimation;
import com.mrcrayfish.furniture.refurbished.blockentity.ILevelAudio;
import com.mrcrayfish.furniture.refurbished.client.audio.AudioManager;
import com.mrcrayfish.furniture.refurbished.core.ModBlockEntities;
import com.mrcrayfish.furniture.refurbished.core.ModParticleTypes;
import com.mrcrayfish.furniture.refurbished.core.ModRecipeTypes;
import com.mrcrayfish.furniture.refurbished.core.ModSounds;
import com.mrcrayfish.furniture.refurbished.crafting.ProcessingRecipe;
import com.mrcrayfish.furniture.refurbished.network.Network;
import com.mrcrayfish.furniture.refurbished.network.message.MessageFlipAnimation;
import com.mrcrayfish.furniture.refurbished.platform.Services;
import com.mrcrayfish.furniture.refurbished.util.BlockEntityHelper;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1278;
import net.minecraft.class_1297;
import net.minecraft.class_1303;
import net.minecraft.class_1542;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1863;
import net.minecraft.class_1874;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2802;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3956;

public class GrillBlockEntity
extends class_2586
implements class_1278 {
    public static final int[] ALL_SLOTS = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12};
    public static final int[] GRILL_SLOTS = new int[]{9, 10, 11, 12};
    private final class_2371<class_1799> fuel = class_2371.method_10213((int)9, (Object)class_1799.field_8037);
    private final class_2371<class_1799> cooking = class_2371.method_10213((int)4, (Object)class_1799.field_8037);
    private final ImmutableList<CookingSpace> spaces;
    protected final class_1863.class_7266<class_1263, ? extends ProcessingRecipe> recipeCache;
    protected final class_1863.class_7266<class_1263, ? extends class_1874> campfireCookingCache;
    private int remainingFuel;
    private float storedExperience;

    public GrillBlockEntity(class_2338 pos, class_2680 state) {
        this((class_2591)ModBlockEntities.GRILL.get(), pos, state, (class_3956<? extends ProcessingRecipe>)((class_3956)ModRecipeTypes.GRILL_COOKING.get()));
    }

    protected GrillBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state, class_3956<? extends ProcessingRecipe> recipeType) {
        super(type, pos, state);
        this.recipeCache = class_1863.method_42302(recipeType);
        this.campfireCookingCache = class_1863.method_42302((class_3956)class_3956.field_17549);
        this.spaces = (ImmutableList)class_156.method_656(() -> {
            ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)this.cooking.size());
            IntStream.range(0, this.cooking.size()).forEach(i -> builder.add((Object)new CookingSpace(i, this)));
            return builder.build();
        });
    }

    public CookingSpace getCookingSpace(int position) {
        return (CookingSpace)this.spaces.get(position);
    }

    public class_2371<class_1799> getCookingItems() {
        return this.cooking;
    }

    public class_2371<class_1799> getFuelItems() {
        return this.fuel;
    }

    public boolean addCookingItem(class_1799 stack, int position, int rotation) {
        Optional<? extends ProcessingRecipe> optional;
        if (((class_1799)this.cooking.get(position)).method_7960() && (optional = this.getRecipe(stack)).isPresent()) {
            ProcessingRecipe recipe = optional.get();
            class_1799 copy = stack.method_7972();
            copy.method_7939(1);
            this.cooking.set(position, (Object)copy);
            ((CookingSpace)this.spaces.get(position)).update(recipe.getTime(), 0.0f, rotation);
            this.syncCookingSpace(position);
            this.playPlaceSound((CookingSpace)this.spaces.get(position), false, 0.85f);
            return true;
        }
        return false;
    }

    public boolean addFuel(class_1799 stack) {
        if (stack.method_7909() == class_1802.field_8665) {
            for (int i = 0; i < this.fuel.size(); ++i) {
                if (!((class_1799)this.fuel.get(i)).method_7960()) continue;
                class_1799 fuel = stack.method_7972();
                fuel.method_7939(1);
                this.fuel.set(i, (Object)fuel);
                this.syncFuel();
                return true;
            }
        }
        return false;
    }

    public void flipItem(int position) {
        if (position >= 0 && position < this.cooking.size() && !((class_1799)this.cooking.get(position)).method_7960()) {
            CookingSpace space = (CookingSpace)this.spaces.get(position);
            if (space.isHalfCooked()) {
                space.flip();
                this.sendFlipAnimationToPlayers(position);
                this.syncCookingSpace(position);
                this.method_5431();
            } else if (space.isFullyCooked()) {
                this.removeCookingItem(position);
            }
        }
    }

    private void sendFlipAnimationToPlayers(int position) {
        class_1937 level = Objects.requireNonNull(this.field_11863);
        class_2802 class_28022 = level.method_8398();
        if (class_28022 instanceof class_3215) {
            class_3215 cache = (class_3215)class_28022;
            class_2338 pos = this.method_11016();
            List players = cache.field_17254.method_17210(new class_1923(pos), false);
            players.forEach(player -> Network.getPlay().sendToPlayer(() -> player, (IMessage)new MessageFlipAnimation(pos, position)));
        }
    }

    public boolean flipItems() {
        for (int i = 0; i < 4; ++i) {
            if (((class_1799)this.cooking.get(i)).method_7960() || !((CookingSpace)this.spaces.get(i)).isHalfCooked()) continue;
            this.flipItem(i);
            return true;
        }
        return false;
    }

    public void removeCookingItem(int position) {
        if (position >= 0 && position < this.cooking.size() && !((class_1799)this.cooking.get(position)).method_7960()) {
            double posX = (double)this.field_11867.method_10263() + 0.3 + 0.4 * (double)(position % 2);
            double posY = (double)this.field_11867.method_10264() + 1.0;
            double posZ = (double)this.field_11867.method_10260() + 0.3 + 0.4 * (double)(position / 2);
            class_1542 entity = new class_1542(this.field_11863, posX, posY + 0.1, posZ, ((class_1799)this.cooking.get(position)).method_7972());
            this.field_11863.method_8649((class_1297)entity);
            this.cooking.set(position, (Object)class_1799.field_8037);
            CookingSpace space = (CookingSpace)this.spaces.get(position);
            if (space.isFullyCooked()) {
                this.spawnExperience(posX, posY, posZ, space.getExperience());
            }
            space.update(0, 0.0f, 0);
            class_2487 compound = new class_2487();
            this.writeCookingItems(compound);
            BlockEntityHelper.sendCustomUpdate(this, compound);
        }
    }

    public static void serverTick(class_1937 level, class_2338 pos, class_2680 state, GrillBlockEntity grill) {
        boolean canCook = grill.canCook();
        if (grill.remainingFuel == 0 && canCook) {
            for (int i = grill.fuel.size() - 1; i >= 0; --i) {
                class_1799 fuel = (class_1799)grill.fuel.get(i);
                if (fuel.method_7960()) continue;
                grill.remainingFuel = Services.ITEM.getBurnTime(fuel, class_3956.field_17546);
                grill.fuel.set(i, (Object)class_1799.field_8037);
                class_2487 compound = new class_2487();
                grill.writeFuel(compound);
                grill.writeRemainingFuel(compound);
                BlockEntityHelper.sendCustomUpdate(grill, compound);
                break;
            }
        }
        if (canCook && grill.remainingFuel > 0) {
            grill.cookItems();
            --grill.remainingFuel;
            if (grill.remainingFuel == 0) {
                class_2487 compound = new class_2487();
                grill.writeRemainingFuel(compound);
                BlockEntityHelper.sendCustomUpdate(grill, compound);
            }
        }
    }

    public static void clientTick(class_1937 level, class_2338 pos, class_2680 state, GrillBlockEntity grill) {
        grill.spawnParticles();
        grill.spaces.forEach(space -> {
            AudioManager.get().playLevelAudio((ILevelAudio)space);
            FlipAnimation animation = space.getAnimation();
            boolean wasPlaying = animation.isPlaying();
            animation.tick();
            if (wasPlaying && !animation.isPlaying()) {
                grill.playPlaceSound((CookingSpace)space, true, 1.0f);
            }
        });
    }

    private boolean canCook() {
        for (int i = 0; i < this.cooking.size(); ++i) {
            CookingSpace space = (CookingSpace)this.spaces.get(i);
            if (((class_1799)this.cooking.get(i)).method_7960() || !space.canCook()) continue;
            return true;
        }
        return false;
    }

    private void cookItems() {
        boolean changed = false;
        for (int i = 0; i < this.cooking.size(); ++i) {
            CookingSpace space;
            if (((class_1799)this.cooking.get(i)).method_7960() || !(space = (CookingSpace)this.spaces.get(i)).canCook()) continue;
            space.cook();
            if (!space.isCooked()) continue;
            if (space.isFlipped()) {
                class_1937 level = Objects.requireNonNull(this.field_11863);
                Optional<? extends ProcessingRecipe> optional = this.getRecipe((class_1799)this.cooking.get(i));
                if (optional.isPresent()) {
                    this.cooking.set(i, (Object)optional.get().method_8110(level.method_30349()).method_7972());
                }
            }
            this.syncCookingSpace(i);
            changed = true;
        }
        if (changed) {
            class_2487 compound = new class_2487();
            this.writeCookingItems(compound);
            BlockEntityHelper.sendCustomUpdate(this, compound);
            this.method_5431();
        }
    }

    private void spawnParticles() {
        class_1937 level = this.method_10997();
        if (level != null) {
            if (this.isCooking()) {
                double posX = (double)this.field_11867.method_10263() + 0.2 + 0.6 * level.field_9229.method_43058();
                double posY = (double)this.field_11867.method_10264() + 0.85;
                double posZ = (double)this.field_11867.method_10260() + 0.2 + 0.6 * level.field_9229.method_43058();
                level.method_8406((class_2394)class_2398.field_11240, posX, posY, posZ, 0.0, 0.0, 0.0);
            }
            for (int i = 0; i < this.cooking.size(); ++i) {
                CookingSpace space;
                if (((class_1799)this.cooking.get(i)).method_7960()) continue;
                if (level.field_9229.method_43057() < 0.1f && (space = (CookingSpace)this.spaces.get(i)).isHalfCooked()) {
                    class_243 spacePos = space.getWorldPosition();
                    for (int j = 0; j < 4; ++j) {
                        level.method_8406((class_2394)class_2398.field_11251, spacePos.field_1352, spacePos.field_1351, spacePos.field_1350, 0.0, 0.0, 0.0);
                    }
                }
                space = (CookingSpace)this.spaces.get(i);
                if (this.remainingFuel <= 0 || !space.canCook() || space.isCooked() || space.getAnimation().isPlaying()) continue;
                class_243 spacePos = space.getWorldPosition();
                spacePos = spacePos.method_1031(0.05 * level.field_9229.method_43059(), 0.0, 0.05 * level.field_9229.method_43059());
                this.spawnSteam(level, spacePos.field_1352, spacePos.field_1351, spacePos.field_1350);
            }
        }
    }

    public void spawnSteam(class_1937 level, double x, double y, double z) {
        double ySpeed = 0.01;
        if (this.isRangeHoodPowered(level, this.field_11867.method_10086(2))) {
            ySpeed = 0.05;
        } else if (this.isRangeHoodPowered(level, this.field_11867.method_10086(3))) {
            ySpeed = 0.1;
        }
        level.method_8406((class_2394)ModParticleTypes.STEAM.get(), x, y, z, 0.0, ySpeed, 0.0);
    }

    private boolean isRangeHoodPowered(class_1937 level, class_2338 pos) {
        class_2338 start = this.field_11867.method_10084();
        while (start.method_10264() < pos.method_10264()) {
            if (!level.method_8320(start).method_26215()) {
                return false;
            }
            start = start.method_10084();
        }
        class_2680 state = level.method_8320(pos);
        if (state.method_26204() instanceof RangeHoodBlock) {
            return (Boolean)state.method_11654((class_2769)RangeHoodBlock.POWERED);
        }
        return false;
    }

    private boolean isCooking() {
        for (int i = 0; i < this.cooking.size(); ++i) {
            CookingSpace space = (CookingSpace)this.spaces.get(i);
            if (((class_1799)this.cooking.get(i)).method_7960() || !space.canCook() && !space.isHalfCooked()) continue;
            return this.remainingFuel > 0;
        }
        return false;
    }

    private Optional<? extends ProcessingRecipe> getRecipe(class_1799 stack) {
        Optional<? extends ProcessingRecipe> optional = this.getRecipeFromCache(this.recipeCache, stack);
        optional = optional.isEmpty() ? this.getCookingRecipe(this.campfireCookingCache, stack) : optional;
        return optional;
    }

    private Optional<ProcessingRecipe> getCookingRecipe(class_1863.class_7266<class_1263, ? extends class_1874> cache, class_1799 stack) {
        return cache.method_42303((class_1263)new class_1277(new class_1799[]{stack}), Objects.requireNonNull(this.field_11863)).map(recipe -> ProcessingRecipe.Item.from(recipe, this.field_11863.method_30349()));
    }

    private Optional<? extends ProcessingRecipe> getRecipeFromCache(class_1863.class_7266<class_1263, ? extends ProcessingRecipe> cache, class_1799 stack) {
        return cache.method_42303((class_1263)new class_1277(new class_1799[]{stack}), Objects.requireNonNull(this.field_11863));
    }

    public int method_5439() {
        return this.fuel.size() + this.cooking.size();
    }

    public boolean method_5442() {
        for (class_1799 stack : this.fuel) {
            if (stack.method_7960()) continue;
            return false;
        }
        for (class_1799 stack : this.cooking) {
            if (stack.method_7960()) continue;
            return false;
        }
        return true;
    }

    public class_1799 method_5438(int index) {
        if (index - this.fuel.size() >= 0) {
            return (class_1799)this.cooking.get(index - this.fuel.size());
        }
        return (class_1799)this.fuel.get(index);
    }

    public class_1799 method_5434(int index, int count) {
        if (index - this.fuel.size() >= 0) {
            class_1799 result = class_1262.method_5430(this.cooking, (int)(index -= this.fuel.size()), (int)count);
            if (((class_1799)this.cooking.get(index)).method_7960()) {
                CookingSpace space = (CookingSpace)this.spaces.get(index);
                if (space.isFullyCooked()) {
                    double posX = (double)this.field_11867.method_10263() + 0.3 + 0.4 * (double)(index % 2);
                    double posY = (double)this.field_11867.method_10264() + 1.0;
                    double posZ = (double)this.field_11867.method_10260() + 0.3 + 0.4 * (double)(index / 2);
                    this.spawnExperience(posX, posY, posZ, space.getExperience());
                }
                space.update(0, 0.0f, 0);
            }
            class_2487 compound = new class_2487();
            this.writeCookingItems(compound);
            BlockEntityHelper.sendCustomUpdate(this, compound);
            return result;
        }
        class_1799 result = class_1262.method_5430(this.fuel, (int)index, (int)count);
        this.syncFuel();
        return result;
    }

    public class_1799 method_5441(int index) {
        if (index - this.fuel.size() >= 0) {
            return class_1262.method_5428(this.cooking, (int)(index - this.fuel.size()));
        }
        return class_1262.method_5428(this.fuel, (int)index);
    }

    public void method_5447(int index, class_1799 stack) {
        class_2371<class_1799> inventory = this.fuel;
        if (index - this.fuel.size() >= 0) {
            index -= this.fuel.size();
            inventory = this.cooking;
            Optional<? extends ProcessingRecipe> optional = this.getRecipe(stack);
            if (optional.isPresent()) {
                ProcessingRecipe recipe = optional.get();
                ((CookingSpace)this.spaces.get(index)).update(recipe.getTime(), 0.0f, 0);
                this.syncCookingSpace(index);
            }
        }
        inventory.set(index, (Object)stack);
        if (stack.method_7947() > this.method_5444()) {
            stack.method_7939(this.method_5444());
        }
        class_2487 compound = new class_2487();
        this.writeCookingItems(compound);
        this.writeFuel(compound);
        BlockEntityHelper.sendCustomUpdate(this, compound);
    }

    public int method_5444() {
        return 1;
    }

    public void method_5448() {
        this.fuel.clear();
        this.cooking.clear();
    }

    public void method_11014(class_2487 compound) {
        super.method_11014(compound);
        if (compound.method_10573("Grill", 9)) {
            this.cooking.clear();
            BlockEntityHelper.loadItems("Grill", compound, this.cooking);
        }
        if (compound.method_10573("Fuel", 9)) {
            this.fuel.clear();
            BlockEntityHelper.loadItems("Fuel", compound, this.fuel);
        }
        if (compound.method_10573("RemainingFuel", 3)) {
            this.remainingFuel = compound.method_10550("RemainingFuel");
        }
        if (compound.method_10573("StoredExperience", 5)) {
            this.storedExperience = compound.method_10583("StoredExperience");
        }
        this.readCookingSpaces(compound);
    }

    protected void method_11007(class_2487 tag) {
        super.method_11007(tag);
        this.writeCookingItems(tag);
        this.writeFuel(tag);
        this.writeRemainingFuel(tag);
        this.writeCookingSpaces(tag);
        tag.method_10548("StoredExperience", this.storedExperience);
    }

    private class_2487 writeCookingItems(class_2487 compound) {
        BlockEntityHelper.saveItems("Grill", compound, this.cooking);
        return compound;
    }

    private class_2487 writeFuel(class_2487 compound) {
        BlockEntityHelper.saveItems("Fuel", compound, this.fuel);
        return compound;
    }

    private class_2487 writeRemainingFuel(class_2487 compound) {
        compound.method_10569("RemainingFuel", this.remainingFuel);
        return compound;
    }

    private class_2487 writeCookingSpaces(class_2487 compound) {
        this.writeCookingSpaces(compound, -1);
        return compound;
    }

    private class_2487 writeCookingSpaces(class_2487 compound, int position) {
        class_2499 list = new class_2499();
        if (position >= 0 && position < this.spaces.size()) {
            class_2487 tag = new class_2487();
            ((CookingSpace)this.spaces.get(position)).writeToTag(tag);
            tag.method_10569("Position", position);
            list.add((Object)tag);
        } else if (position == -1) {
            for (int i = 0; i < this.spaces.size(); ++i) {
                class_2487 tag = new class_2487();
                ((CookingSpace)this.spaces.get(i)).writeToTag(tag);
                tag.method_10569("Position", i);
                list.add((Object)tag);
            }
        }
        compound.method_10566("CookingSpaces", (class_2520)list);
        return compound;
    }

    private void readCookingSpaces(class_2487 compound) {
        if (compound.method_10573("CookingSpaces", 9)) {
            class_2499 list = compound.method_10554("CookingSpaces", 10);
            list.forEach(nbt -> {
                int position;
                class_2487 tag = (class_2487)nbt;
                if (tag.method_10573("Position", 3) && (position = tag.method_10550("Position")) >= 0 && position < this.spaces.size()) {
                    ((CookingSpace)this.spaces.get(position)).readFromTag(tag);
                }
            });
        }
    }

    @Nullable
    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    public boolean method_5443(class_1657 player) {
        return class_1263.method_49105((class_2586)this, (class_1657)player);
    }

    public int[] method_5494(class_2350 side) {
        return side == class_2350.field_11033 ? GRILL_SLOTS : ALL_SLOTS;
    }

    public boolean method_5492(int index, class_1799 stack, @Nullable class_2350 direction) {
        if (!this.method_5438(index).method_7960()) {
            return false;
        }
        if (index - this.fuel.size() >= 0) {
            return this.getRecipe(stack).isPresent();
        }
        return stack.method_7909() == class_1802.field_8713 || stack.method_7909() == class_1802.field_8665;
    }

    public boolean method_5493(int index, class_1799 stack, class_2350 direction) {
        if (direction == class_2350.field_11033 && index - this.fuel.size() >= 0 && ((CookingSpace)this.spaces.get(index -= this.fuel.size())).isFullyCooked()) {
            return this.getRecipe(stack).isEmpty();
        }
        return false;
    }

    private void playPlaceSound(CookingSpace space, boolean client, float pitch) {
        class_1937 level = Objects.requireNonNull(this.field_11863);
        class_243 pos = space.getWorldPosition();
        if (client) {
            level.method_8486(pos.field_1352, pos.field_1351, pos.field_1350, (class_3414)ModSounds.BLOCK_FRYING_PAN_PLACE_INGREDIENT.get(), class_3419.field_15248, 1.0f, pitch, false);
            return;
        }
        level.method_43128(null, pos.field_1352, pos.field_1351, pos.field_1350, (class_3414)ModSounds.BLOCK_FRYING_PAN_PLACE_INGREDIENT.get(), class_3419.field_15248, 1.0f, pitch);
    }

    private void syncCookingSpace(int position) {
        class_2487 compound = new class_2487();
        this.writeCookingItems(compound);
        this.writeCookingSpaces(compound, position);
        BlockEntityHelper.sendCustomUpdate(this, compound);
    }

    private void syncFuel() {
        class_2487 compound = new class_2487();
        this.writeFuel(compound);
        BlockEntityHelper.sendCustomUpdate(this, compound);
    }

    private void spawnExperience(double x, double y, double z, float exp) {
        class_1937 class_19372;
        this.storedExperience += Math.max(exp, 0.0f);
        if ((float)class_3532.method_15375((float)this.storedExperience) >= 1.0f && (class_19372 = this.field_11863) instanceof class_3218) {
            class_3218 level = (class_3218)class_19372;
            int amount = class_3532.method_15375((float)this.storedExperience);
            class_1303.method_31493((class_3218)level, (class_243)new class_243(x, y, z), (int)amount);
            this.storedExperience = Math.max(this.storedExperience - (float)amount, 0.0f);
        }
    }

    public void playFlipAnimation(int position) {
        if (Objects.requireNonNull(this.field_11863).method_8608() && position >= 0 && position < this.spaces.size()) {
            ((CookingSpace)this.spaces.get(position)).getAnimation().play();
        }
    }

    public static class CookingSpace
    implements ILevelAudio {
        public static final double MAX_AUDIO_DISTANCE = class_3532.method_34954((int)8);
        private final int index;
        private final GrillBlockEntity grill;
        private int cookingTime = 0;
        private int totalCookingTime = 0;
        private boolean flipped = false;
        private float experience = 0.0f;
        private int rotation = 0;
        private FlipAnimation animation;

        public CookingSpace(int index, GrillBlockEntity grill) {
            this.index = index;
            this.grill = grill;
        }

        public boolean isFlipped() {
            return this.flipped;
        }

        public float getExperience() {
            return this.experience;
        }

        public int getRotation() {
            return this.rotation;
        }

        public void cook() {
            if (this.cookingTime < this.totalCookingTime) {
                ++this.cookingTime;
            }
        }

        public boolean isCooked() {
            return this.cookingTime == this.totalCookingTime;
        }

        public boolean isHalfCooked() {
            return !this.flipped && this.cookingTime == this.totalCookingTime;
        }

        public boolean isFullyCooked() {
            return this.flipped && this.cookingTime == this.totalCookingTime;
        }

        public boolean canCook() {
            return this.cookingTime < this.totalCookingTime;
        }

        public void update(int cookTime, float experience, int rotation) {
            this.cookingTime = 0;
            this.totalCookingTime = cookTime / 2;
            this.flipped = false;
            this.experience = experience;
            this.rotation = rotation;
        }

        public void flip() {
            if (!this.flipped) {
                this.flipped = true;
                this.cookingTime = 0;
            }
        }

        public class_243 getWorldPosition() {
            class_2338 pos = this.grill.field_11867;
            double x = (double)pos.method_10263() + 0.3 + 0.4 * (double)(this.index % 2);
            double y = (double)pos.method_10264() + 1.0;
            double z = (double)pos.method_10260() + 0.3 + 0.4 * (double)(this.index / 2);
            return new class_243(x, y, z);
        }

        public void writeToTag(class_2487 tag) {
            tag.method_10569("CookingTime", this.cookingTime);
            tag.method_10569("TotalCookingTime", this.totalCookingTime);
            tag.method_10556("Flipped", this.flipped);
            tag.method_10548("Experience", this.experience);
            tag.method_10569("Rotation", this.rotation);
        }

        public void readFromTag(class_2487 tag) {
            if (tag.method_10573("CookingTime", 3)) {
                this.cookingTime = tag.method_10550("CookingTime");
            }
            if (tag.method_10573("TotalCookingTime", 3)) {
                this.totalCookingTime = tag.method_10550("TotalCookingTime");
            }
            if (tag.method_10573("Flipped", 1)) {
                this.flipped = tag.method_10577("Flipped");
            }
            if (tag.method_10573("Experience", 5)) {
                this.experience = tag.method_10583("Experience");
            }
            if (tag.method_10573("Rotation", 3)) {
                this.rotation = tag.method_10550("Rotation");
            }
        }

        public FlipAnimation getAnimation() {
            if (this.animation == null) {
                this.animation = new FlipAnimation();
            }
            return this.animation;
        }

        @Override
        public class_3414 getSound() {
            return (class_3414)ModSounds.BLOCK_FRYING_PAN_SIZZLING.get();
        }

        @Override
        public class_3419 getSource() {
            return class_3419.field_15245;
        }

        @Override
        public class_243 getAudioPosition() {
            return this.getWorldPosition();
        }

        @Override
        public boolean canPlayAudio() {
            return !this.grill.method_11015() && this.grill.remainingFuel > 0 && !((class_1799)this.grill.cooking.get(this.index)).method_7960() && (!this.isCooked() || this.isHalfCooked());
        }

        @Override
        public float getAudioVolume() {
            return (this.canCook() && !this.isCooked() || this.isHalfCooked()) && !this.getAnimation().isPlaying() ? 1.0f : 0.0f;
        }

        @Override
        public float getAudioPitch() {
            return this.isHalfCooked() ? 0.8f : 1.0f;
        }

        @Override
        public double getAudioRadiusSqr() {
            return MAX_AUDIO_DISTANCE;
        }

        @Override
        public int getAudioHash() {
            return Objects.hash(this.grill.field_11867, this.index);
        }

        @Override
        public boolean isAudioEqual(ILevelAudio other) {
            return other == this;
        }
    }
}

