/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.blockentity.fluid;

import com.google.common.base.Preconditions;
import com.mrcrayfish.framework.network.message.IMessage;
import com.mrcrayfish.furniture.refurbished.network.Network;
import com.mrcrayfish.furniture.refurbished.network.message.MessageSyncFluid;
import com.mrcrayfish.furniture.refurbished.platform.Services;
import it.unimi.dsi.fastutil.Pair;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2802;
import net.minecraft.class_3215;
import net.minecraft.class_3611;

public abstract class FluidContainer {
    public static final long BUCKET_CAPACITY = Services.FLUID.getBucketCapacity();

    protected FluidContainer() {
    }

    public abstract long getCapacity();

    public abstract boolean isEmpty();

    public abstract class_3611 getStoredFluid();

    public abstract long getStoredAmount();

    protected abstract void setStored(class_3611 var1, long var2);

    public abstract long push(class_3611 var1, long var2, boolean var4);

    public abstract Pair<class_3611, Long> pull(long var1, boolean var3);

    public abstract void load(class_2487 var1);

    public abstract void save(class_2487 var1);

    public final void sync(class_2586 owner) {
        class_1937 level = Objects.requireNonNull(owner.method_10997());
        Preconditions.checkState((!level.method_8608() ? 1 : 0) != 0);
        class_2802 class_28022 = level.method_8398();
        if (class_28022 instanceof class_3215) {
            class_3215 cache = (class_3215)class_28022;
            class_2338 pos = owner.method_11016();
            List players = cache.field_17254.method_17210(new class_1923(pos), false);
            players.forEach(player -> Network.getPlay().sendToPlayer(() -> player, (IMessage)new MessageSyncFluid(pos, this.getStoredFluid(), this.getStoredAmount())));
        }
    }

    public final void handleSync(class_1937 level, class_3611 fluid, long amount) {
        Preconditions.checkState((boolean)level.method_8608());
        this.setStored(fluid, amount);
    }

    public static FluidContainer create(long capacity) {
        return Services.FLUID.createFluidContainer(capacity, null);
    }

    public static FluidContainer create(long capacity, Consumer<FluidContainer> onChange) {
        return Services.FLUID.createFluidContainer(capacity, onChange);
    }
}

