/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.network.message;

import com.mojang.authlib.GameProfile;
import com.mrcrayfish.framework.api.network.MessageContext;
import com.mrcrayfish.framework.api.network.message.PlayMessage;
import com.mrcrayfish.furniture.refurbished.client.ClientMailbox;
import com.mrcrayfish.furniture.refurbished.mail.IMailbox;
import com.mrcrayfish.furniture.refurbished.network.play.ClientPlayHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_2540;

public class MessageUpdateMailboxes
extends PlayMessage<MessageUpdateMailboxes> {
    private Collection<? extends IMailbox> mailboxes;

    public MessageUpdateMailboxes() {
    }

    public MessageUpdateMailboxes(Collection<? extends IMailbox> mailboxes) {
        this.mailboxes = mailboxes;
    }

    public void encode(MessageUpdateMailboxes message, class_2540 buffer) {
        buffer.writeInt(message.mailboxes.size());
        message.mailboxes.forEach(mailbox -> {
            buffer.method_10797(mailbox.getId());
            Optional<GameProfile> ownerId = mailbox.getOwner();
            buffer.writeBoolean(ownerId.isPresent());
            ownerId.ifPresent(profile -> {
                buffer.method_10797(profile.getId());
                String name = profile.getName();
                buffer.writeBoolean(name != null);
                if (name != null) {
                    buffer.method_10814(name);
                }
            });
            Optional<String> customName = mailbox.getCustomName();
            buffer.writeBoolean(customName.isPresent());
            customName.ifPresent(arg_0 -> ((class_2540)buffer).method_10814(arg_0));
        });
    }

    public MessageUpdateMailboxes decode(class_2540 buffer) {
        ArrayList<ClientMailbox> mailboxes = new ArrayList<ClientMailbox>();
        int size = buffer.readInt();
        for (int i = 0; i < size; ++i) {
            UUID id = buffer.method_10790();
            UUID ownerId = buffer.readBoolean() ? buffer.method_10790() : null;
            String ownerName = ownerId != null && buffer.readBoolean() ? buffer.method_19772() : null;
            GameProfile profile = ownerId != null ? new GameProfile(ownerId, ownerName) : null;
            String customName = buffer.readBoolean() ? buffer.method_19772() : null;
            mailboxes.add(new ClientMailbox(id, Optional.ofNullable(profile), Optional.ofNullable(customName)));
        }
        return new MessageUpdateMailboxes(mailboxes);
    }

    public void handle(MessageUpdateMailboxes message, MessageContext context) {
        context.execute(() -> ClientPlayHandler.handleMessageUpdateMailboxes(message));
        context.setHandled(true);
    }

    public Collection<? extends IMailbox> getMailboxes() {
        return this.mailboxes;
    }
}

