/*
 * Decompiled with CFR 0.152.
 */
package me.wesley1808.servercore.common.dynamic;

import me.wesley1808.servercore.common.config.Config;
import me.wesley1808.servercore.common.config.data.dynamic.DynamicConfig;
import me.wesley1808.servercore.common.dynamic.DynamicSetting;
import me.wesley1808.servercore.common.interfaces.IMinecraftServer;
import me.wesley1808.servercore.common.interfaces.IMobCategory;
import net.minecraft.class_1311;
import net.minecraft.class_310;
import net.minecraft.server.MinecraftServer;

public class DynamicManager {
    private final MinecraftServer server;
    private final boolean isClient;
    private double averageTickTime;
    private int count;

    public DynamicManager(MinecraftServer server) {
        this.server = server;
        this.isClient = server.method_3724();
        DynamicConfig config = Config.get().dynamic();
        if (config.enabled()) {
            int maxViewDistance = DynamicSetting.VIEW_DISTANCE.getMax();
            if (server.method_3760().method_14568() > maxViewDistance) {
                this.modifyViewDistance(maxViewDistance);
            }
            int maxSimDistance = DynamicSetting.SIMULATION_DISTANCE.getMax();
            if (server.method_3760().method_38651() > maxSimDistance) {
                this.modifySimulationDistance(maxSimDistance);
            }
            DynamicManager.modifyMobcaps(DynamicSetting.MOBCAP_PERCENTAGE.getMax());
        }
    }

    public static DynamicManager getInstance(MinecraftServer server) {
        return ((IMinecraftServer)server).servercore$getDynamicManager();
    }

    public static void update(MinecraftServer server) {
        if (server.method_3780() % 20 == 0) {
            DynamicManager manager = DynamicManager.getInstance(server);
            manager.updateValues();
            DynamicConfig config = Config.get().dynamic();
            if (config.enabled()) {
                manager.runPerformanceChecks(config);
            }
        }
    }

    private void updateValues() {
        this.averageTickTime = this.calculateAverageTickTime();
        ++this.count;
    }

    protected double calculateAverageTickTime() {
        return this.server.method_3830();
    }

    private void runPerformanceChecks(DynamicConfig config) {
        boolean increase;
        double targetMspt = config.targetMspt();
        boolean decrease = this.averageTickTime > targetMspt + 5.0;
        boolean bl = increase = this.averageTickTime < Math.max(targetMspt - 5.0, 2.0);
        if (decrease || increase) {
            DynamicSetting setting;
            DynamicSetting[] dynamicSettingArray = DynamicSetting.values();
            int n = dynamicSettingArray.length;
            for (int i = 0; !(i >= n || (setting = dynamicSettingArray[i]).shouldRun(this.count) && setting.modify(increase, this)); ++i) {
            }
        }
    }

    public void modifyViewDistance(int distance) {
        this.server.method_3760().method_14608(distance);
        if (this.isClient) {
            class_310.method_1551().field_1690.method_42503().method_41748((Object)distance);
        }
    }

    public void modifySimulationDistance(int distance) {
        this.server.method_3760().method_38650(distance);
        if (this.isClient) {
            class_310.method_1551().field_1690.method_42510().method_41748((Object)distance);
        }
    }

    public static void modifyMobcaps(int percentage) {
        double modifier = (float)percentage / 100.0f;
        for (class_1311 category : class_1311.values()) {
            IMobCategory.modifyCapacity(category, modifier);
        }
    }

    public double getAverageTickTime() {
        return this.averageTickTime;
    }
}

