/*
 * Decompiled with CFR 0.152.
 */
package io.github.maxencedc.sparsestructures.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import io.github.maxencedc.sparsestructures.Constants;
import io.github.maxencedc.sparsestructures.StructureSetsSet;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;

public class DumpStructureSetsCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"dumpstructuresets").requires(cs -> cs.method_9259(2))).executes(context -> {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Dumping structure set..."), false);
            String fileName = new SimpleDateFormat("'structure_sets_dump_'yy_MM_dd_HH_mm'.txt'").format(new Date());
            try {
                DumpStructureSetsCommand.dumpStructureSets(fileName);
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Structure sets dumped to: `" + Paths.get("sparsestructures", fileName) + "`\n(if you're on a server, this is dumped in the server's files)")), false);
                return 1;
            }
            catch (IOException e) {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Failed to dump structure sets, check logs for error"), false);
                Constants.LOG.error("Failed to dump structure sets", (Throwable)e);
                return 0;
            }
        }));
    }

    private static void dumpStructureSets(String fileName) throws IOException {
        Path dumpPath = Path.of("sparsestructures", new String[0]);
        StringBuilder dump = new StringBuilder();
        StructureSetsSet.structureSets.forEach(s -> dump.append("{\n  \"structure\": \"").append((String)s).append("\",\n  \"factor\": 1//REPLACE WITH YOUR CUSTOM SPREADING FACTOR HERE\n},\n"));
        Files.createDirectories(dumpPath, new FileAttribute[0]);
        Files.writeString(dumpPath.resolve(fileName), (CharSequence)dump.toString(), new OpenOption[0]);
    }
}

