/*
 * Decompiled with CFR 0.152.
 */
package io.github.maxencedc.sparsestructures.mixin;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.Decoder;
import io.github.maxencedc.sparsestructures.CustomSpreadFactors;
import io.github.maxencedc.sparsestructures.SparseStructuresCommon;
import io.github.maxencedc.sparsestructures.StructureSetsSet;
import java.io.Reader;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.class_2378;
import net.minecraft.class_2385;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_5321;
import net.minecraft.class_6903;
import net.minecraft.class_7654;
import net.minecraft.class_7655;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={class_7655.class})
public class MakeStructuresSparse {
    @Inject(at={@At(value="INVOKE", target="Lcom/mojang/serialization/Decoder;parse(Lcom/mojang/serialization/DynamicOps;Ljava/lang/Object;)Lcom/mojang/serialization/DataResult;")}, method={"loadRegistryContents"}, locals=LocalCapture.CAPTURE_FAILHARD)
    private static <E> void loadElementFromResource(class_6903.class_7863 registryInfoLookup, class_3300 resourceManager, class_5321<? extends class_2378<E>> resourceKey, class_2385<E> registry, Decoder<E> decoder, Map<class_5321<?>, Exception> map, CallbackInfo ci, String string, class_7654 fileToIdConverter, class_6903 registryOps, Iterator var9, Map.Entry entry, class_2960 resourceLocation, class_5321 resourceKey2, class_3298 resource, Reader reader, JsonElement jsonElement) {
        if (!string.equals("worldgen/structure_set")) {
            return;
        }
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        JsonObject placement = jsonObject.getAsJsonObject("placement");
        if (!placement.get("type").getAsString().equals("minecraft:concentric_rings")) {
            int separation;
            StructureSetsSet.addStructureSet(resourceKey.method_29177().toString());
            double factor = SparseStructuresCommon.config.customSpreadFactors().stream().filter(s -> {
                if (s == null) {
                    return false;
                }
                String structure_set = resourceKey.method_29177().toString();
                return structure_set.equals(s.structure()) || jsonObject.getAsJsonArray("structures").asList().stream().anyMatch(p -> p.getAsJsonObject().get("structure").getAsString().equals(s.structure()));
            }).findFirst().orElse(new CustomSpreadFactors("", SparseStructuresCommon.config.spreadFactor())).factor();
            int spacing = placement.get("spacing") == null ? 1 : (int)(placement.get("spacing").getAsDouble() * factor);
            int n = separation = placement.get("separation") == null ? 1 : (int)(placement.get("separation").getAsDouble() * factor);
            if (separation >= spacing) {
                spacing = Math.max(1, spacing);
                separation = spacing - 1;
            }
            placement.addProperty("spacing", (Number)spacing);
            placement.addProperty("separation", (Number)separation);
        }
    }
}

