/*
 * Decompiled with CFR 0.152.
 */
package net.devtech.stacc;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.devtech.stacc.StaccGlobals;
import net.devtech.stacc.mixin.ItemMaxCountAccess;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_7923;
import org.slf4j.Logger;

public class StaccLoader
implements ModInitializer {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final String MOD_ID = "stacc";

    public void onInitialize() {
        final IdentityHashMap originalSizes = new IdentityHashMap();
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener(new IdentifiableResourceReloadListener(){
            final class_2960 id = StaccLoader.id("cfg");
            final class_2960 resourceId = StaccLoader.id("config.json");

            public class_2960 getFabricId() {
                return this.id;
            }

            public CompletableFuture<Void> method_25931(class_3302.class_4045 synchronizer, class_3300 manager, class_3695 prepareProfiler, class_3695 applyProfiler, Executor prepareExecutor, Executor applyExecutor) {
                return ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
                    HashMap<class_2960, Integer> stackSizes = new HashMap<class_2960, Integer>();
                    List resources = manager.method_14489(this.resourceId);
                    for (class_3298 resource : resources) {
                        try {
                            BufferedReader reader = resource.method_43039();
                            try {
                                JsonObject keys = class_3518.method_15255((Reader)reader);
                                for (Map.Entry entry : keys.entrySet()) {
                                    class_2960 itemId = new class_2960((String)entry.getKey());
                                    JsonElement value = (JsonElement)entry.getValue();
                                    if (value.isJsonNull()) {
                                        stackSizes.remove(itemId);
                                        continue;
                                    }
                                    if (value.isJsonArray() || value.isJsonObject()) {
                                        throw new IOException("Invalid stack size for %s: %s! Must be: {[0-1,000,000,000], \"default\", or null}".formatted(itemId, value));
                                    }
                                    if (!(value instanceof JsonPrimitive)) continue;
                                    JsonPrimitive p = (JsonPrimitive)value;
                                    if (p.isNumber()) {
                                        int size = p.getAsNumber().intValue();
                                        if (size < 0 || size > 1000000000) {
                                            throw new IOException("Invalid stack size for %s: %s! Must be: {[0-1,000,000,000], \"default\", or null}".formatted(itemId, size));
                                        }
                                        stackSizes.put(itemId, size);
                                        continue;
                                    }
                                    if (p.isString() && p.getAsString().equals("default")) {
                                        stackSizes.remove(itemId);
                                        continue;
                                    }
                                    throw new IOException("Invalid stack size for %s: %s! Must be: {[0-1,000,000,000], \"default\", or null}".formatted(itemId, value));
                                }
                            }
                            finally {
                                if (reader == null) continue;
                                reader.close();
                            }
                        }
                        catch (IOException e) {
                            throw StaccLoader.rethrow(new IOException("Invalid stack:config.json in pack \"%s\", format is {\"item:id\": 43, \"item:id2\": 5785, ...}!".formatted(resource.method_45304().method_14409()), e));
                        }
                    }
                    return stackSizes;
                }, prepareExecutor).thenCompose(arg_0 -> ((class_3302.class_4045)synchronizer).method_18352(arg_0))).thenAcceptAsync(u -> {
                    HashMap<class_1792, Integer> restore = new HashMap<class_1792, Integer>(originalSizes);
                    for (Map.Entry entry : u.entrySet()) {
                        class_2960 key = (class_2960)entry.getKey();
                        Integer value = (Integer)entry.getValue();
                        class_1792 item2 = (class_1792)class_7923.field_41178.method_10223(key);
                        originalSizes.putIfAbsent(item2, item2.method_7882());
                        restore.remove(item2);
                        if (item2 == class_1802.field_8162) {
                            LOGGER.warn("No item found for: %s".formatted(key));
                            continue;
                        }
                        int old = item2.method_7882();
                        ((ItemMaxCountAccess)item2).setMaxCount(value);
                        LOGGER.info("Changed max count of %s from %s to %s!".formatted(key, old, value));
                    }
                    restore.forEach((item, originalCount) -> {
                        ((ItemMaxCountAccess)item).setMaxCount((int)originalCount);
                        originalSizes.remove(item);
                    });
                    StaccGlobals.lastSize = -1;
                }, applyExecutor);
            }
        });
    }

    public static class_2960 id(String path) {
        return new class_2960(MOD_ID, path);
    }

    public static <T extends Throwable> RuntimeException rethrow(Throwable throwable) throws T {
        throw throwable;
    }
}

