/*
 * Decompiled with CFR 0.152.
 */
package com.axperty.storagedelight.registry;

import com.axperty.storagedelight.block.entity.CabinetVariantBlockEntity;
import com.axperty.storagedelight.block.entity.DrawerBlockEntity;
import com.axperty.storagedelight.block.entity.DrawerDoorBlockEntity;
import com.axperty.storagedelight.block.entity.GlassCabinetBlockEntity;
import com.axperty.storagedelight.registry.BlocksRegistry;
import java.util.Arrays;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.object.builder.v1.block.entity.FabricBlockEntityTypeBuilder;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public enum BlockEntityTypesRegistry {
    DRAWER("drawer", DrawerBlockEntity.class, (FabricBlockEntityTypeBuilder.Factory<? extends class_2586>)((FabricBlockEntityTypeBuilder.Factory)DrawerBlockEntity::new), BlocksRegistry.OAK_DRAWER, BlocksRegistry.BIRCH_DRAWER, BlocksRegistry.SPRUCE_DRAWER, BlocksRegistry.JUNGLE_DRAWER, BlocksRegistry.ACACIA_DRAWER, BlocksRegistry.DARK_OAK_DRAWER, BlocksRegistry.MANGROVE_DRAWER, BlocksRegistry.CHERRY_DRAWER, BlocksRegistry.BAMBOO_DRAWER, BlocksRegistry.CRIMSON_DRAWER, BlocksRegistry.WARPED_DRAWER),
    DRAWER_DOOR("drawer_door", DrawerDoorBlockEntity.class, (FabricBlockEntityTypeBuilder.Factory<? extends class_2586>)((FabricBlockEntityTypeBuilder.Factory)DrawerDoorBlockEntity::new), BlocksRegistry.OAK_DRAWER_WITH_DOOR, BlocksRegistry.BIRCH_DRAWER_WITH_DOOR, BlocksRegistry.SPRUCE_DRAWER_WITH_DOOR, BlocksRegistry.JUNGLE_DRAWER_WITH_DOOR, BlocksRegistry.ACACIA_DRAWER_WITH_DOOR, BlocksRegistry.DARK_OAK_DRAWER_WITH_DOOR, BlocksRegistry.MANGROVE_DRAWER_WITH_DOOR, BlocksRegistry.CHERRY_DRAWER_WITH_DOOR, BlocksRegistry.BAMBOO_DRAWER_WITH_DOOR, BlocksRegistry.CRIMSON_DRAWER_WITH_DOOR, BlocksRegistry.WARPED_DRAWER_WITH_DOOR),
    GLASS_CABINET("glass_cabinet", GlassCabinetBlockEntity.class, (FabricBlockEntityTypeBuilder.Factory<? extends class_2586>)((FabricBlockEntityTypeBuilder.Factory)GlassCabinetBlockEntity::new), BlocksRegistry.GLASS_OAK_CABINET, BlocksRegistry.GLASS_BIRCH_CABINET, BlocksRegistry.GLASS_SPRUCE_CABINET, BlocksRegistry.GLASS_JUNGLE_CABINET, BlocksRegistry.GLASS_ACACIA_CABINET, BlocksRegistry.GLASS_DARK_OAK_CABINET, BlocksRegistry.GLASS_MANGROVE_CABINET, BlocksRegistry.GLASS_CHERRY_CABINET, BlocksRegistry.GLASS_BAMBOO_CABINET, BlocksRegistry.GLASS_CRIMSON_CABINET, BlocksRegistry.GLASS_WARPED_CABINET),
    CABINET_VARIANT("cabinet_variant", CabinetVariantBlockEntity.class, (FabricBlockEntityTypeBuilder.Factory<? extends class_2586>)((FabricBlockEntityTypeBuilder.Factory)CabinetVariantBlockEntity::new), BlocksRegistry.OAK_CABINET_WITH_GLASS_DOORS, BlocksRegistry.BIRCH_CABINET_WITH_GLASS_DOORS, BlocksRegistry.SPRUCE_CABINET_WITH_GLASS_DOORS, BlocksRegistry.JUNGLE_CABINET_WITH_GLASS_DOORS, BlocksRegistry.ACACIA_CABINET_WITH_GLASS_DOORS, BlocksRegistry.DARK_OAK_CABINET_WITH_GLASS_DOORS, BlocksRegistry.MANGROVE_CABINET_WITH_GLASS_DOORS, BlocksRegistry.CHERRY_CABINET_WITH_GLASS_DOORS, BlocksRegistry.BAMBOO_CABINET_WITH_GLASS_DOORS, BlocksRegistry.CRIMSON_CABINET_WITH_GLASS_DOORS, BlocksRegistry.WARPED_CABINET_WITH_GLASS_DOORS, BlocksRegistry.OAK_SINGLE_DOOR_CABINET, BlocksRegistry.BIRCH_SINGLE_DOOR_CABINET, BlocksRegistry.SPRUCE_SINGLE_DOOR_CABINET, BlocksRegistry.JUNGLE_SINGLE_DOOR_CABINET, BlocksRegistry.ACACIA_SINGLE_DOOR_CABINET, BlocksRegistry.DARK_OAK_SINGLE_DOOR_CABINET, BlocksRegistry.MANGROVE_SINGLE_DOOR_CABINET, BlocksRegistry.CHERRY_SINGLE_DOOR_CABINET, BlocksRegistry.BAMBOO_SINGLE_DOOR_CABINET, BlocksRegistry.CRIMSON_SINGLE_DOOR_CABINET, BlocksRegistry.WARPED_SINGLE_DOOR_CABINET);

    private final String pathName;
    private final Class<? extends class_2586> blockEntityClass;
    private final Supplier<class_2591<? extends class_2586>> blockEntityTypeSupplier;
    private class_2591<? extends class_2586> blockEntityType;

    private BlockEntityTypesRegistry(String pathName, Class<? extends class_2586> blockEntityClass, FabricBlockEntityTypeBuilder.Factory<? extends class_2586> blockEntitySupplier, BlocksRegistry ... blockRegistryArray) {
        this.pathName = pathName;
        this.blockEntityClass = blockEntityClass;
        this.blockEntityTypeSupplier = () -> FabricBlockEntityTypeBuilder.create((FabricBlockEntityTypeBuilder.Factory)blockEntitySupplier, (class_2248[])((class_2248[])Arrays.stream(blockRegistryArray).map(BlocksRegistry::get).toArray(class_2248[]::new))).build(null);
    }

    public static void registerAll() {
        for (BlockEntityTypesRegistry value : BlockEntityTypesRegistry.values()) {
            class_2378.method_10230((class_2378)class_7923.field_41181, (class_2960)new class_2960("storagedelight", value.pathName), value.get());
        }
    }

    public <T extends class_2586> class_2591<T> get() {
        return this.get(this.blockEntityClass);
    }

    private <T extends class_2586> class_2591<T> get(Class<T> clazz) {
        if (this.blockEntityType == null) {
            this.blockEntityType = this.blockEntityTypeSupplier.get();
        }
        return this.blockEntityType;
    }

    public String getId() {
        return class_7923.field_41181.method_10221(this.get()).toString();
    }
}

