/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.registry;

import com.supermartijn642.core.CoreLib;
import com.supermartijn642.core.data.condition.ResourceConditionSerializer;
import com.supermartijn642.core.data.tag.CustomTagEntrySerializer;
import com.supermartijn642.core.registry.Registries;
import com.supermartijn642.core.registry.RegistryUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1291;
import net.minecraft.class_1299;
import net.minecraft.class_1320;
import net.minecraft.class_1535;
import net.minecraft.class_1792;
import net.minecraft.class_1842;
import net.minecraft.class_1865;
import net.minecraft.class_1887;
import net.minecraft.class_2248;
import net.minecraft.class_2396;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3448;
import net.minecraft.class_3611;
import net.minecraft.class_3917;
import org.jetbrains.annotations.ApiStatus;

public class RegistrationHandler {
    private static final Map<String, RegistrationHandler> REGISTRATION_HELPER_MAP = new HashMap<String, RegistrationHandler>();
    private static boolean hasBeenRegistered = false;
    private final String modid;
    private final Map<Registries.Registry<?>, Map<class_2960, Supplier<?>>> entryMap = new HashMap();
    private final Map<Registries.Registry<?>, List<Consumer<Helper<?>>>> callbacks = new HashMap();

    @Deprecated
    @ApiStatus.Internal
    public static void registerInternal() {
        hasBeenRegistered = true;
        REGISTRATION_HELPER_MAP.values().forEach(RegistrationHandler::registerAll);
    }

    public static synchronized RegistrationHandler get(String modid) {
        if (!RegistryUtil.isValidNamespace(modid)) {
            throw new IllegalArgumentException("Modid '" + modid + "' must only contain characters [a-z0-9_.-]!");
        }
        if (modid.equals("minecraft")) {
            CoreLib.LOGGER.warn("Mod is requesting registration helper for modid '" + modid + "'!");
        } else {
            ModContainer container = FabricLoader.getInstance().getModContainer(modid).orElse(null);
            if (container == null) {
                CoreLib.LOGGER.warn("Mod is requesting registration helper for unknown modid '" + modid + "'!");
            }
        }
        return REGISTRATION_HELPER_MAP.computeIfAbsent(modid, RegistrationHandler::new);
    }

    private RegistrationHandler(String modid) {
        this.modid = modid;
    }

    public void registerBlock(String identifier, Supplier<class_2248> block) {
        this.addEntry(Registries.BLOCKS, identifier, block);
    }

    public void registerBlock(String identifier, class_2248 block) {
        this.addEntry(Registries.BLOCKS, identifier, () -> block);
    }

    public void registerBlockOverride(String namespace, String identifier, Supplier<class_2248> block) {
        this.addEntry(Registries.BLOCKS, namespace, identifier, block);
    }

    public void registerBlockOverride(String namespace, String identifier, class_2248 block) {
        this.addEntry(Registries.BLOCKS, namespace, identifier, () -> block);
    }

    public void registerBlockCallback(Consumer<Helper<class_2248>> callback) {
        this.addCallback(Registries.BLOCKS, callback);
    }

    public void registerFluid(String identifier, Supplier<class_3611> fluid) {
        this.addEntry(Registries.FLUIDS, identifier, fluid);
    }

    public void registerFluid(String identifier, class_3611 fluid) {
        this.addEntry(Registries.FLUIDS, identifier, () -> fluid);
    }

    public void registerFluidOverride(String namespace, String identifier, Supplier<class_3611> fluid) {
        this.addEntry(Registries.FLUIDS, namespace, identifier, fluid);
    }

    public void registerFluidOverride(String namespace, String identifier, class_3611 fluid) {
        this.addEntry(Registries.FLUIDS, namespace, identifier, () -> fluid);
    }

    public void registerFluidCallback(Consumer<Helper<class_3611>> callback) {
        this.addCallback(Registries.FLUIDS, callback);
    }

    public void registerItem(String identifier, Supplier<class_1792> item) {
        this.addEntry(Registries.ITEMS, identifier, item);
    }

    public void registerItem(String identifier, class_1792 item) {
        this.addEntry(Registries.ITEMS, identifier, () -> item);
    }

    public void registerItemOverride(String namespace, String identifier, Supplier<class_1792> item) {
        this.addEntry(Registries.ITEMS, namespace, identifier, item);
    }

    public void registerItemOverride(String namespace, String identifier, class_1792 item) {
        this.addEntry(Registries.ITEMS, namespace, identifier, () -> item);
    }

    public void registerItemCallback(Consumer<Helper<class_1792>> callback) {
        this.addCallback(Registries.ITEMS, callback);
    }

    public void registerMobEffect(String identifier, Supplier<class_1291> effect) {
        this.addEntry(Registries.MOB_EFFECTS, identifier, effect);
    }

    public void registerMobEffect(String identifier, class_1291 effect) {
        this.addEntry(Registries.MOB_EFFECTS, identifier, () -> effect);
    }

    public void registerMobEffectOverride(String namespace, String identifier, Supplier<class_1291> effect) {
        this.addEntry(Registries.MOB_EFFECTS, namespace, identifier, effect);
    }

    public void registerMobEffectOverride(String namespace, String identifier, class_1291 effect) {
        this.addEntry(Registries.MOB_EFFECTS, namespace, identifier, () -> effect);
    }

    public void registerMobEffectCallback(Consumer<Helper<class_1291>> callback) {
        this.addCallback(Registries.MOB_EFFECTS, callback);
    }

    public void registerSoundEvent(String identifier, Supplier<class_3414> sound) {
        this.addEntry(Registries.SOUND_EVENTS, identifier, sound);
    }

    public void registerSoundEvent(String identifier, class_3414 sound) {
        this.addEntry(Registries.SOUND_EVENTS, identifier, () -> sound);
    }

    public void registerSoundEventOverride(String namespace, String identifier, Supplier<class_3414> sound) {
        this.addEntry(Registries.SOUND_EVENTS, namespace, identifier, sound);
    }

    public void registerSoundEventOverride(String namespace, String identifier, class_3414 sound) {
        this.addEntry(Registries.SOUND_EVENTS, namespace, identifier, () -> sound);
    }

    public void registerSoundEventCallback(Consumer<Helper<class_3414>> callback) {
        this.addCallback(Registries.SOUND_EVENTS, callback);
    }

    public void registerPotion(String identifier, Supplier<class_1842> potion) {
        this.addEntry(Registries.POTIONS, identifier, potion);
    }

    public void registerPotion(String identifier, class_1842 potion) {
        this.addEntry(Registries.POTIONS, identifier, () -> potion);
    }

    public void registerPotionOverride(String namespace, String identifier, Supplier<class_1842> potion) {
        this.addEntry(Registries.POTIONS, namespace, identifier, potion);
    }

    public void registerPotionOverride(String namespace, String identifier, class_1842 potion) {
        this.addEntry(Registries.POTIONS, namespace, identifier, () -> potion);
    }

    public void registerPotionCallback(Consumer<Helper<class_1842>> callback) {
        this.addCallback(Registries.POTIONS, callback);
    }

    public void registerEnchantment(String identifier, Supplier<class_1887> enchantment) {
        this.addEntry(Registries.ENCHANTMENTS, identifier, enchantment);
    }

    public void registerEnchantment(String identifier, class_1887 enchantment) {
        this.addEntry(Registries.ENCHANTMENTS, identifier, () -> enchantment);
    }

    public void registerEnchantmentOverride(String namespace, String identifier, Supplier<class_1887> enchantment) {
        this.addEntry(Registries.ENCHANTMENTS, namespace, identifier, enchantment);
    }

    public void registerEnchantmentOverride(String namespace, String identifier, class_1887 enchantment) {
        this.addEntry(Registries.ENCHANTMENTS, namespace, identifier, () -> enchantment);
    }

    public void registerEnchantmentCallback(Consumer<Helper<class_1887>> callback) {
        this.addCallback(Registries.ENCHANTMENTS, callback);
    }

    public void registerEntityType(String identifier, Supplier<class_1299<?>> entityType) {
        this.addEntry(Registries.ENTITY_TYPES, identifier, entityType);
    }

    public void registerEntityType(String identifier, class_1299<?> entityType) {
        this.addEntry(Registries.ENTITY_TYPES, identifier, () -> entityType);
    }

    public void registerEntityTypeOverride(String namespace, String identifier, Supplier<class_1299<?>> entityType) {
        this.addEntry(Registries.ENTITY_TYPES, namespace, identifier, entityType);
    }

    public void registerEntityTypeOverride(String namespace, String identifier, class_1299<?> entityType) {
        this.addEntry(Registries.ENTITY_TYPES, namespace, identifier, () -> entityType);
    }

    public void registerEntityTypeCallback(Consumer<Helper<class_1299<?>>> callback) {
        this.addCallback(Registries.ENTITY_TYPES, callback);
    }

    public void registerBlockEntityType(String identifier, Supplier<class_2591<?>> blockEntityType) {
        this.addEntry(Registries.BLOCK_ENTITY_TYPES, identifier, blockEntityType);
    }

    public void registerBlockEntityType(String identifier, class_2591<?> blockEntityType) {
        this.addEntry(Registries.BLOCK_ENTITY_TYPES, identifier, () -> blockEntityType);
    }

    public void registerBlockEntityTypeOverride(String namespace, String identifier, Supplier<class_2591<?>> blockEntityType) {
        this.addEntry(Registries.BLOCK_ENTITY_TYPES, namespace, identifier, blockEntityType);
    }

    public void registerBlockEntityTypeOverride(String namespace, String identifier, class_2591<?> blockEntityType) {
        this.addEntry(Registries.BLOCK_ENTITY_TYPES, namespace, identifier, () -> blockEntityType);
    }

    public void registerBlockEntityTypeCallback(Consumer<Helper<class_2591<?>>> callback) {
        this.addCallback(Registries.BLOCK_ENTITY_TYPES, callback);
    }

    public void registerParticleType(String identifier, Supplier<class_2396<?>> particleType) {
        this.addEntry(Registries.PARTICLE_TYPES, identifier, particleType);
    }

    public void registerParticleType(String identifier, class_2396<?> particleType) {
        this.addEntry(Registries.PARTICLE_TYPES, identifier, () -> particleType);
    }

    public void registerParticleTypeOverride(String namespace, String identifier, Supplier<class_2396<?>> particleType) {
        this.addEntry(Registries.PARTICLE_TYPES, namespace, identifier, particleType);
    }

    public void registerParticleTypeOverride(String namespace, String identifier, class_2396<?> particleType) {
        this.addEntry(Registries.PARTICLE_TYPES, namespace, identifier, () -> particleType);
    }

    public void registerParticleTypeCallback(Consumer<Helper<class_2396<?>>> callback) {
        this.addCallback(Registries.PARTICLE_TYPES, callback);
    }

    public void registerMenuType(String identifier, Supplier<class_3917<?>> menuType) {
        this.addEntry(Registries.MENU_TYPES, identifier, menuType);
    }

    public void registerMenuType(String identifier, class_3917<?> menuType) {
        this.addEntry(Registries.MENU_TYPES, identifier, () -> menuType);
    }

    public void registerMenuTypeOverride(String namespace, String identifier, Supplier<class_3917<?>> menuType) {
        this.addEntry(Registries.MENU_TYPES, namespace, identifier, menuType);
    }

    public void registerMenuTypeOverride(String namespace, String identifier, class_3917<?> menuType) {
        this.addEntry(Registries.MENU_TYPES, namespace, identifier, () -> menuType);
    }

    public void registerMenuTypeCallback(Consumer<Helper<class_3917<?>>> callback) {
        this.addCallback(Registries.MENU_TYPES, callback);
    }

    public void registerPaintingVariant(String identifier, Supplier<class_1535> paintingVariant) {
        this.addEntry(Registries.PAINTING_VARIANTS, identifier, paintingVariant);
    }

    public void registerPaintingVariant(String identifier, class_1535 paintingVariant) {
        this.addEntry(Registries.PAINTING_VARIANTS, identifier, () -> paintingVariant);
    }

    public void registerPaintingVariantOverride(String namespace, String identifier, Supplier<class_1535> paintingVariant) {
        this.addEntry(Registries.PAINTING_VARIANTS, namespace, identifier, paintingVariant);
    }

    public void registerPaintingVariantOverride(String namespace, String identifier, class_1535 paintingVariant) {
        this.addEntry(Registries.PAINTING_VARIANTS, namespace, identifier, () -> paintingVariant);
    }

    public void registerPaintingVariantCallback(Consumer<Helper<class_1535>> callback) {
        this.addCallback(Registries.PAINTING_VARIANTS, callback);
    }

    public void registerRecipeSerializer(String identifier, Supplier<class_1865<?>> recipeSerializer) {
        this.addEntry(Registries.RECIPE_SERIALIZERS, identifier, recipeSerializer);
    }

    public void registerRecipeSerializer(String identifier, class_1865<?> recipeSerializer) {
        this.addEntry(Registries.RECIPE_SERIALIZERS, identifier, () -> recipeSerializer);
    }

    public void registerRecipeSerializerOverride(String namespace, String identifier, Supplier<class_1865<?>> recipeSerializer) {
        this.addEntry(Registries.RECIPE_SERIALIZERS, namespace, identifier, recipeSerializer);
    }

    public void registerRecipeSerializerOverride(String namespace, String identifier, class_1865<?> recipeSerializer) {
        this.addEntry(Registries.RECIPE_SERIALIZERS, namespace, identifier, () -> recipeSerializer);
    }

    public void registerRecipeSerializerCallback(Consumer<Helper<class_1865<?>>> callback) {
        this.addCallback(Registries.RECIPE_SERIALIZERS, callback);
    }

    public void registerAttribute(String identifier, Supplier<class_1320> attribute) {
        this.addEntry(Registries.ATTRIBUTES, identifier, attribute);
    }

    public void registerAttribute(String identifier, class_1320 attribute) {
        this.addEntry(Registries.ATTRIBUTES, identifier, () -> attribute);
    }

    public void registerAttributeOverride(String namespace, String identifier, Supplier<class_1320> attribute) {
        this.addEntry(Registries.ATTRIBUTES, namespace, identifier, attribute);
    }

    public void registerAttributeOverride(String namespace, String identifier, class_1320 attribute) {
        this.addEntry(Registries.ATTRIBUTES, namespace, identifier, () -> attribute);
    }

    public void registerAttributeCallback(Consumer<Helper<class_1320>> callback) {
        this.addCallback(Registries.ATTRIBUTES, callback);
    }

    public void registerStatType(String identifier, Supplier<class_3448<?>> statType) {
        this.addEntry(Registries.STAT_TYPES, identifier, statType);
    }

    public void registerStatType(String identifier, class_3448<?> statType) {
        this.addEntry(Registries.STAT_TYPES, identifier, () -> statType);
    }

    public void registerStatTypeOverride(String namespace, String identifier, Supplier<class_3448<?>> statType) {
        this.addEntry(Registries.STAT_TYPES, namespace, identifier, statType);
    }

    public void registerStatTypeOverride(String namespace, String identifier, class_3448<?> statType) {
        this.addEntry(Registries.STAT_TYPES, namespace, identifier, () -> statType);
    }

    public void registerStatTypeCallback(Consumer<Helper<class_3448<?>>> callback) {
        this.addCallback(Registries.STAT_TYPES, callback);
    }

    public void registerResourceConditionSerializer(String identifier, Supplier<ResourceConditionSerializer<?>> conditionSerializer) {
        this.addEntry(Registries.RESOURCE_CONDITION_SERIALIZERS, identifier, conditionSerializer);
    }

    public void registerResourceConditionSerializer(String identifier, ResourceConditionSerializer<?> conditionSerializer) {
        this.addEntry(Registries.RESOURCE_CONDITION_SERIALIZERS, identifier, () -> conditionSerializer);
    }

    public void registerResourceConditionSerializerOverride(String namespace, String identifier, Supplier<ResourceConditionSerializer<?>> conditionSerializer) {
        this.addEntry(Registries.RESOURCE_CONDITION_SERIALIZERS, namespace, identifier, conditionSerializer);
    }

    public void registerResourceConditionSerializerOverride(String namespace, String identifier, ResourceConditionSerializer<?> conditionSerializer) {
        this.addEntry(Registries.RESOURCE_CONDITION_SERIALIZERS, namespace, identifier, () -> conditionSerializer);
    }

    public void registerResourceConditionSerializerCallback(Consumer<Helper<ResourceConditionSerializer<?>>> callback) {
        this.addCallback(Registries.RESOURCE_CONDITION_SERIALIZERS, callback);
    }

    public void registerCustomTagEntrySerializer(String identifier, Supplier<CustomTagEntrySerializer<?>> serializer) {
        this.addEntry(Registries.CUSTOM_TAG_ENTRY_SERIALIZERS, identifier, serializer);
    }

    public void registerCustomTagEntrySerializer(String identifier, CustomTagEntrySerializer<?> serializer) {
        this.addEntry(Registries.CUSTOM_TAG_ENTRY_SERIALIZERS, identifier, () -> serializer);
    }

    public void registerCustomTagEntrySerializerOverride(String namespace, String identifier, Supplier<CustomTagEntrySerializer<?>> serializer) {
        this.addEntry(Registries.CUSTOM_TAG_ENTRY_SERIALIZERS, namespace, identifier, serializer);
    }

    public void registerCustomTagEntrySerializerOverride(String namespace, String identifier, CustomTagEntrySerializer<?> serializer) {
        this.addEntry(Registries.CUSTOM_TAG_ENTRY_SERIALIZERS, namespace, identifier, () -> serializer);
    }

    public void registerCustomTagEntrySerializerCallback(Consumer<Helper<CustomTagEntrySerializer<?>>> callback) {
        this.addCallback(Registries.CUSTOM_TAG_ENTRY_SERIALIZERS, callback);
    }

    private <T> void addEntry(Registries.Registry<T> registry, String identifier, Supplier<T> entry) {
        this.addEntry(registry, this.modid, identifier, entry);
    }

    private <T> void addEntry(Registries.Registry<T> registry, String namespace, String identifier, Supplier<T> entry) {
        if (hasBeenRegistered) {
            throw new IllegalStateException("Cannot register new entries after mod initialization!");
        }
        if (!RegistryUtil.isValidNamespace(namespace)) {
            throw new IllegalArgumentException("Namespace '" + namespace + "' must only contain characters [a-z0-9_.-]!");
        }
        if (!RegistryUtil.isValidPath(identifier)) {
            throw new IllegalArgumentException("Identifier '" + identifier + "' must only contain characters [a-z0-9_./-]!");
        }
        if (entry == null) {
            throw new IllegalArgumentException("Entry supplier for '" + namespace + ":" + identifier + "' must not be null!");
        }
        class_2960 fullIdentifier = new class_2960(namespace, identifier);
        Map entries = this.entryMap.computeIfAbsent(registry, o -> new LinkedHashMap());
        if (entries.containsKey(fullIdentifier)) {
            throw new RuntimeException("Duplicate entry '" + String.valueOf(fullIdentifier) + "' for registry '" + String.valueOf(registry.getRegistryIdentifier()) + "'!");
        }
        entries.put(fullIdentifier, entry);
    }

    private <T> void addCallback(Registries.Registry<T> registry, Consumer<Helper<T>> callback) {
        if (hasBeenRegistered) {
            throw new IllegalStateException("Cannot register new entries after mod initialization!");
        }
        if (callback == null) {
            throw new IllegalArgumentException("Registration callback must not be null!");
        }
        this.callbacks.computeIfAbsent(registry, o -> new ArrayList()).add(callback);
    }

    private void registerAll() {
        for (Registries.Registry<?> registry : Registries.REGISTRATION_ORDER) {
            this.handleRegistry(registry);
        }
    }

    private <T> void handleRegistry(Registries.Registry<T> registry) {
        if (this.entryMap.containsKey(registry)) {
            this.registerEntries(registry);
        }
        if (this.callbacks.containsKey(registry)) {
            this.callCallbacks(registry);
        }
    }

    private <T> void registerEntries(Registries.Registry<T> registry) {
        Map<class_2960, Supplier<?>> entries = this.entryMap.get(registry);
        for (Map.Entry<class_2960, Supplier<?>> entry : entries.entrySet()) {
            Object object = entry.getValue().get();
            registry.register(entry.getKey(), object);
        }
    }

    private void callCallbacks(Registries.Registry<?> registry) {
        Helper helper = new Helper(registry);
        List<Consumer<Helper<?>>> callbacks = this.callbacks.get(registry);
        for (Consumer<Helper<?>> callback : callbacks) {
            callback.accept(helper);
        }
    }

    public class Helper<T> {
        private final Registries.Registry<T> registry;

        public Helper(Registries.Registry<T> registry) {
            this.registry = registry;
        }

        public <X extends T> X register(String identifier, X object) {
            this.register(RegistrationHandler.this.modid, identifier, object);
            return object;
        }

        public <X extends T> X registerOverride(String namespace, String identifier, X object) {
            this.register(namespace, identifier, object);
            return object;
        }

        private void register(String namespace, String identifier, T object) {
            if (!RegistryUtil.isValidNamespace(namespace)) {
                throw new IllegalArgumentException("Namespace '" + namespace + "' must only contain characters [a-z0-9_.-]!");
            }
            if (!RegistryUtil.isValidPath(identifier)) {
                throw new IllegalArgumentException("Identifier '" + identifier + "' must only contain characters [a-z0-9_./-]!");
            }
            class_2960 fullIdentifier = new class_2960(namespace, identifier);
            Map entries = RegistrationHandler.this.entryMap.computeIfAbsent(this.registry, o -> new LinkedHashMap());
            if (entries.containsKey(fullIdentifier)) {
                throw new RuntimeException("Duplicate entry '" + String.valueOf(fullIdentifier) + "' for registry '" + String.valueOf(this.registry.getRegistryIdentifier()) + "'!");
            }
            this.registry.register(fullIdentifier, object);
        }
    }
}

