/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.universalshops.trade;

import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.universalshops.gui.GuiElements;
import eu.pb4.universalshops.gui.selling.AnyStackShopGui;
import eu.pb4.universalshops.gui.selling.SingleItemShopGui;
import eu.pb4.universalshops.gui.setup.ItemModificatorGui;
import eu.pb4.universalshops.other.TextUtil;
import eu.pb4.universalshops.other.USUtil;
import eu.pb4.universalshops.registry.TradeShopBlockEntity;
import eu.pb4.universalshops.trade.GenericHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public abstract class StockHandler
extends GenericHandler {
    public static final Map<String, Definition> TYPES_MAP = new HashMap<String, Definition>();
    public static final List<Definition> TYPES = new ArrayList<Definition>();

    protected StockHandler(Definition definition, TradeShopBlockEntity blockEntity) {
        super(definition, blockEntity);
    }

    public static void init() {
    }

    public abstract void openTradeGui(class_3222 var1);

    @Override
    public final class_2487 writeNbt(class_2487 nbt) {
        nbt.method_10582("StockType", this.definition.type);
        nbt.method_10566("StockValue", this.writeValueNbt());
        return nbt;
    }

    public static StockHandler readNbt(class_2487 nbt, TradeShopBlockEntity blockEntity) {
        String type = nbt.method_10558("StockType");
        Definition definition = TYPES_MAP.get(type);
        return definition != null ? (StockHandler)definition.createFromNbt(nbt.method_10580("StockValue"), blockEntity) : (StockHandler)Invalid.DEFINITION.createInitial(blockEntity);
    }

    public static void register(Definition definition) {
        TYPES.add(definition);
        TYPES_MAP.put(definition.type, definition);
    }

    public abstract class_2561 getStockName();

    @Override
    public class_2561 getText() {
        return class_2561.method_43473();
    }

    static {
        StockHandler.register(Invalid.DEFINITION);
        StockHandler.register(SingleItem.DEFINITION);
        StockHandler.register(SelectedItem.DEFINITION);
    }

    public static abstract class Definition
    extends GenericHandler.Definition<StockHandler> {
        public Definition(String type, class_1792 icon) {
            this(type, (class_2561)TextUtil.of("stockhandler", type, new Object[0]), icon.method_7854());
        }

        public Definition(String type, class_2561 displayName, class_1799 icon) {
            super(type, displayName, icon);
        }
    }

    public static final class Invalid
    extends StockHandler {
        public static final Definition DEFINITION = new Definition("invalid", (class_2561)TextUtil.text("not_set", new Object[0]), GuiElements.HEAD_QUESTION_MARK){

            @Override
            public StockHandler createFromNbt(class_2520 compound, TradeShopBlockEntity blockEntity) {
                return new Invalid(this, blockEntity);
            }

            @Override
            public StockHandler createInitial(TradeShopBlockEntity blockEntity) {
                return new Invalid(this, blockEntity);
            }

            @Override
            public boolean canUse(class_3222 player) {
                return false;
            }
        };

        protected Invalid(Definition create, TradeShopBlockEntity blockEntity) {
            super(create, blockEntity);
        }

        @Override
        public void openTradeGui(class_3222 player) {
        }

        @Override
        public class_1799 icon() {
            return GuiElements.HEAD_QUESTION_MARK.method_7972();
        }

        @Override
        public int getMaxAmount(class_3222 player) {
            return 0;
        }

        @Override
        public boolean isSetup() {
            return false;
        }

        @Override
        protected class_2520 writeValueNbt() {
            return new class_2487();
        }

        @Override
        public boolean canSwitch() {
            return true;
        }

        @Override
        public class_2561 getStockName() {
            return TextUtil.text("not_set", new Object[0]).method_27692(class_124.field_1061);
        }
    }

    public static final class SingleItem
    extends StockHandler
    implements ItemModificatorGui.ItemStackHolder {
        public static final Definition DEFINITION = new Definition("single_item", class_1802.field_22024){

            @Override
            public StockHandler createFromNbt(class_2520 compound, TradeShopBlockEntity blockEntity) {
                return new SingleItem(this, class_1799.method_7915((class_2487)((class_2487)compound)), blockEntity);
            }

            @Override
            public StockHandler createInitial(TradeShopBlockEntity blockEntity) {
                return new SingleItem(this, class_1799.field_8037, blockEntity);
            }
        };
        public class_1799 value;

        protected SingleItem(Definition creator, class_1799 itemStack, TradeShopBlockEntity blockEntity) {
            super(creator, blockEntity);
            this.value = itemStack;
        }

        @Override
        public void openTradeGui(class_3222 player) {
            new SingleItemShopGui(player, this.shop);
        }

        @Override
        public class_1799 icon() {
            return this.value.method_7972();
        }

        @Override
        public GuiElementInterface getSetupElement() {
            return ItemModificatorGui.stackHolderElement(this, true);
        }

        @Override
        public boolean isSetup() {
            return !this.value.method_7960();
        }

        @Override
        protected class_2520 writeValueNbt() {
            return this.value.method_7953(new class_2487());
        }

        @Override
        public boolean canSwitch() {
            return true;
        }

        @Override
        public class_2561 getStockName() {
            return USUtil.asText(this.value);
        }

        @Override
        public int getMaxAmount(class_3222 player) {
            return this.shop.isAdmin() ? Integer.MAX_VALUE : this.transfer(true, a -> true) / this.value.method_7947();
        }

        public int transfer(boolean dryRun, Predicate<class_1799> stackConsumer) {
            if (this.shop.isAdmin()) {
                return stackConsumer.test(this.value.method_7972()) ? this.value.method_7947() : 0;
            }
            return USUtil.transfer(this.shop.getContainer(), b -> USUtil.areStacksMatching(this.value, b), dryRun ? Integer.MAX_VALUE : this.value.method_7947(), dryRun, stackConsumer);
        }

        @Override
        public class_1799 getItemStack() {
            return this.value;
        }

        @Override
        public void setItemStack(class_1799 stack) {
            this.value = stack;
            this.shop.method_5431();
        }
    }

    public static final class SelectedItem
    extends StockHandler {
        public static final Definition DEFINITION = new Definition("selected_item", class_1802.field_8574){

            @Override
            public StockHandler createFromNbt(class_2520 compound, TradeShopBlockEntity blockEntity) {
                return new SelectedItem(this, blockEntity);
            }

            @Override
            public StockHandler createInitial(TradeShopBlockEntity blockEntity) {
                return new SelectedItem(this, blockEntity);
            }
        };

        protected SelectedItem(Definition creator, TradeShopBlockEntity blockEntity) {
            super(creator, blockEntity);
        }

        @Override
        public void openTradeGui(class_3222 player) {
            new AnyStackShopGui(player, this.shop);
        }

        @Override
        public class_1799 icon() {
            class_1263 container = this.shop.getContainer();
            if (container.method_5442()) {
                return GuiElements.HEAD_QUESTION_MARK.method_7972();
            }
            ArrayList<class_1799> list = new ArrayList<class_1799>(container.method_5439());
            for (int i = 0; i < container.method_5439(); ++i) {
                if (container.method_5438(i).method_7960()) continue;
                list.add(container.method_5438(i));
            }
            return ((class_1799)list.get((int)(this.shop.method_10997().method_8510() / 32L % (long)list.size()))).method_7972();
        }

        @Override
        public int getMaxAmount(class_3222 player) {
            if (this.shop.isAdmin()) {
                return Integer.MAX_VALUE;
            }
            int i = 0;
            for (class_1799 stack : USUtil.iterable(this.shop.getContainer())) {
                if (stack.method_7960()) continue;
                ++i;
            }
            return i;
        }

        @Override
        public boolean isSetup() {
            return true;
        }

        @Override
        protected class_2520 writeValueNbt() {
            return new class_2487();
        }

        @Override
        public boolean canSwitch() {
            return true;
        }

        @Override
        public class_2561 getStockName() {
            return TextUtil.text("select_anything", new Object[0]);
        }
    }

    public record Result(boolean success, @Nullable class_2561 failureMessage) {
        public static Result failed(class_2561 value) {
            return new Result(false, value);
        }

        public static Result successful() {
            return new Result(true, null);
        }
    }
}

