/*
 * Decompiled with CFR 0.152.
 */
package com.goby56.wakes.render;

import com.goby56.wakes.WakesClient;
import com.goby56.wakes.config.enums.Resolution;
import com.goby56.wakes.debug.WakesDebugInfo;
import com.goby56.wakes.render.WakeTexture;
import com.goby56.wakes.simulation.Brick;
import com.goby56.wakes.simulation.WakeHandler;
import com.goby56.wakes.simulation.WakeNode;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Map;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import org.joml.Matrix4f;

public class WakeRenderer
implements WorldRenderEvents.AfterTranslucent {
    public static Map<Resolution, WakeTexture> wakeTextures = null;

    private void initTextures() {
        wakeTextures = Map.of(Resolution.EIGHT, new WakeTexture(Resolution.EIGHT.res), Resolution.SIXTEEN, new WakeTexture(Resolution.SIXTEEN.res), Resolution.THIRTYTWO, new WakeTexture(Resolution.THIRTYTWO.res));
    }

    public void afterTranslucent(WorldRenderContext context) {
        WakeHandler wakeHandler;
        if (WakesClient.CONFIG_INSTANCE.disableMod) {
            WakesDebugInfo.quadsRendered = 0;
            return;
        }
        if (wakeTextures == null) {
            this.initTextures();
        }
        if ((wakeHandler = WakeHandler.getInstance()) == null || wakeHandler.resolutionResetScheduled) {
            return;
        }
        ArrayList<Brick> bricks = wakeHandler.getVisible(context.frustum(), Brick.class);
        Matrix4f matrix = context.matrixStack().method_23760().method_23761();
        RenderSystem.enableBlend();
        context.lightmapTextureManager().method_3316();
        Resolution resolution = WakesClient.CONFIG_INSTANCE.wakeResolution;
        if (resolution.res != WakeNode.res) {
            return;
        }
        int n = 0;
        long tRendering = System.nanoTime();
        for (Brick brick : bricks) {
            wakeTextures.get((Object)resolution).render(matrix, context.camera(), brick);
            ++n;
        }
        WakesDebugInfo.renderingTime.add(System.nanoTime() - tRendering);
        WakesDebugInfo.quadsRendered = n;
    }
}

