/*
 * Decompiled with CFR 0.152.
 */
package com.goby56.wakes.simulation;

import com.goby56.wakes.WakesClient;
import com.goby56.wakes.simulation.WakeHandler;
import com.goby56.wakes.utils.WakesUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1690;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;

public class WakeNode {
    public static int res = WakesClient.CONFIG_INSTANCE.wakeResolution.res;
    private static float alpha;
    private static float beta;
    public float[][][] u;
    public float[][] initialValues;
    public final int x;
    public final int y;
    public final int z;
    public static final float WATER_OFFSET = 0.8888889f;
    public WakeNode NORTH = null;
    public WakeNode EAST = null;
    public WakeNode SOUTH = null;
    public WakeNode WEST = null;
    public static int maxAge;
    public int age = 0;
    private boolean dead = false;
    public float t = 0.0f;
    public int floodLevel;

    public WakeNode(class_243 position, int initialStrength) {
        this.initValues();
        this.x = (int)Math.floor(position.field_1352);
        this.y = (int)Math.floor(position.field_1351);
        this.z = (int)Math.floor(position.field_1350);
        int sx = (int)Math.floor((double)res * (position.field_1352 - (double)this.x));
        int sz = (int)Math.floor((double)res * (position.field_1350 - (double)this.z));
        for (int z = -1; z < 2; ++z) {
            for (int x = -1; x < 2; ++x) {
                this.u[0][sz + 1 + z][sx + 1 + x] = initialStrength;
            }
        }
        this.floodLevel = WakesClient.CONFIG_INSTANCE.floodFillDistance;
    }

    private WakeNode(int x, int y, int z, int floodLevel) {
        this.initValues();
        this.x = x;
        this.y = y;
        this.z = z;
        this.floodLevel = floodLevel;
    }

    private WakeNode(long pos, int y) {
        this.initValues();
        int[] xz = WakesUtils.longAsPos(pos);
        this.x = xz[0];
        this.y = y;
        this.z = xz[1];
        this.floodLevel = WakesClient.CONFIG_INSTANCE.floodFillDistance;
    }

    private void initValues() {
        this.u = new float[3][res + 2][res + 2];
        this.initialValues = new float[res + 2][res + 2];
    }

    public void setInitialValue(long pos, int val) {
        float resFactor = (float)res / 16.0f;
        int[] xz = WakesUtils.longAsPos(pos);
        if (xz[0] < 0) {
            xz[0] = xz[0] + res;
        }
        if (xz[1] < 0) {
            xz[1] = xz[1] + res;
        }
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                this.initialValues[xz[1] + i + 1][xz[0] + j + 1] = (float)val * resFactor;
            }
        }
    }

    public static void calculateWaveDevelopmentFactors() {
        float time = 20.0f;
        alpha = (float)Math.pow(WakesClient.CONFIG_INSTANCE.wavePropagationFactor * 16.0f / time, 2.0);
        beta = (float)(Math.log(10.0f * WakesClient.CONFIG_INSTANCE.waveDecayFactor + 10.0f) / Math.log(20.0));
    }

    public boolean tick() {
        int x;
        int z;
        if (this.isDead()) {
            return false;
        }
        if (this.age++ >= maxAge || res != WakesClient.CONFIG_INSTANCE.wakeResolution.res) {
            this.markDead();
            return false;
        }
        this.t = (float)this.age / (float)maxAge;
        for (int i = 2; i >= 1; --i) {
            if (this.NORTH != null) {
                this.u[i][0] = this.NORTH.u[i][res];
            }
            if (this.SOUTH != null) {
                this.u[i][WakeNode.res + 1] = this.SOUTH.u[i][1];
            }
            for (int z2 = 0; z2 < res + 2 && (this.EAST != null || this.WEST != null); ++z2) {
                if (this.EAST != null) {
                    this.u[i][z2][WakeNode.res + 1] = this.EAST.u[i][z2][1];
                }
                if (this.WEST == null) continue;
                this.u[i][z2][0] = this.WEST.u[i][z2][res];
            }
        }
        for (z = 1; z < res + 1; ++z) {
            for (x = 1; x < res + 1; ++x) {
                float[] fArray = this.u[0][z];
                int n = x;
                fArray[n] = fArray[n] + this.initialValues[z][x];
                this.initialValues[z][x] = 0.0f;
                this.u[2][z][x] = this.u[1][z][x];
                this.u[1][z][x] = this.u[0][z][x];
            }
        }
        for (z = 1; z < res + 1; ++z) {
            x = 1;
            while (x < res + 1) {
                this.u[0][z][x] = (float)((double)alpha * (0.5 * (double)this.u[1][z - 1][x] + 0.25 * (double)this.u[1][z - 1][x + 1] + 0.5 * (double)this.u[1][z][x + 1] + 0.25 * (double)this.u[1][z + 1][x + 1] + 0.5 * (double)this.u[1][z + 1][x] + 0.25 * (double)this.u[1][z + 1][x - 1] + 0.5 * (double)this.u[1][z][x - 1] + 0.25 * (double)this.u[1][z - 1][x - 1] - (double)(3.0f * this.u[1][z][x])) + (double)(2.0f * this.u[1][z][x]) - (double)this.u[2][z][x]);
                float[] fArray = this.u[0][z];
                int n = x++;
                fArray[n] = fArray[n] * beta;
            }
        }
        this.floodFill();
        return true;
    }

    public void floodFill() {
        WakeHandler wh = WakeHandler.getInstance();
        if (this.floodLevel > 0 && this.age > WakesClient.CONFIG_INSTANCE.ticksBeforeFill) {
            if (this.NORTH == null) {
                wh.insert(new WakeNode(this.x, this.y, this.z - 1, this.floodLevel - 1));
            } else {
                this.NORTH.updateFloodLevel(this.floodLevel - 1);
            }
            if (this.EAST == null) {
                wh.insert(new WakeNode(this.x + 1, this.y, this.z, this.floodLevel - 1));
            } else {
                this.EAST.updateFloodLevel(this.floodLevel - 1);
            }
            if (this.SOUTH == null) {
                wh.insert(new WakeNode(this.x, this.y, this.z + 1, this.floodLevel - 1));
            } else {
                this.SOUTH.updateFloodLevel(this.floodLevel - 1);
            }
            if (this.WEST == null) {
                wh.insert(new WakeNode(this.x - 1, this.y, this.z, this.floodLevel - 1));
            } else {
                this.WEST.updateFloodLevel(this.floodLevel - 1);
            }
            this.floodLevel = 0;
        }
    }

    public void updateAdjacency(WakeNode node) {
        if (node.x == this.x && node.z == this.z - 1) {
            this.NORTH = node;
            node.SOUTH = this;
            return;
        }
        if (node.x == this.x + 1 && node.z == this.z) {
            this.EAST = node;
            node.WEST = this;
            return;
        }
        if (node.x == this.x && node.z == this.z + 1) {
            this.SOUTH = node;
            node.NORTH = this;
            return;
        }
        if (node.x == this.x - 1 && node.z == this.z) {
            this.WEST = node;
            node.EAST = this;
        }
    }

    public void updateFloodLevel(int newLevel) {
        this.age = 0;
        if (newLevel > this.floodLevel) {
            this.floodLevel = newLevel;
        }
    }

    public boolean validPos() {
        class_3610 fluidState = class_310.method_1551().field_1687.method_8316(this.blockPos());
        class_3610 fluidStateAbove = class_310.method_1551().field_1687.method_8316(this.blockPos().method_10084());
        if (fluidState.method_39360((class_3611)class_3612.field_15910) && fluidStateAbove.method_15769()) {
            return fluidState.method_15771();
        }
        return false;
    }

    public class_238 toBox() {
        return new class_238((double)this.x, (double)this.y, (double)this.z, (double)(this.x + 1), (double)((float)this.y + 0.111111104f), (double)(this.z + 1));
    }

    public void revive(WakeNode node) {
        this.age = 0;
        this.floodLevel = WakesClient.CONFIG_INSTANCE.floodFillDistance;
        this.initialValues = node.initialValues;
    }

    public void markDead() {
        this.dead = true;
    }

    public boolean isDead() {
        return this.dead;
    }

    public class_2338 blockPos() {
        return new class_2338(this.x, this.y, this.z);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WakeNode wakeNode = (WakeNode)o;
        return this.x == wakeNode.x && this.z == wakeNode.z;
    }

    public int hashCode() {
        return Objects.hash(this.x, this.z);
    }

    public String toString() {
        return String.format("WakeNode{%d, %d, %d}", this.x, this.y, this.z);
    }

    static {
        maxAge = 30;
    }

    public static class Factory {
        public static Set<WakeNode> splashNodes(class_1297 entity, int y) {
            int res = WakeNode.res;
            int w = (int)(0.8 * (double)entity.method_17681() * (double)res / 2.0);
            int x = (int)(entity.method_23317() * (double)res);
            int z = (int)(entity.method_23321() * (double)res);
            ArrayList<Long> pixelsAffected = new ArrayList<Long>();
            for (int i = -w; i < w; ++i) {
                for (int j = -w; j < w; ++j) {
                    if (i * i + j * j >= w * w) continue;
                    pixelsAffected.add(WakesUtils.posAsLong(x + i, z + j));
                }
            }
            return Factory.pixelsToNodes(pixelsAffected, y, WakesClient.CONFIG_INSTANCE.splashStrength, Math.abs(entity.method_18798().field_1351));
        }

        public static Set<WakeNode> rowingNodes(class_1690 boat, int y) {
            HashSet<WakeNode> nodesAffected = new HashSet<WakeNode>();
            double velocity = boat.method_18798().method_37267();
            for (int i = 0; i < 2; ++i) {
                double phase;
                if (!boat.method_7556(i) || !(0.19634954631328583 <= (phase = (double)boat.field_7704[i] % (Math.PI * 2))) || !(phase <= 1.178097277879715)) continue;
                class_243 rot = boat.method_5828(1.0f);
                double x = boat.method_23317() + (i == 1 ? -rot.field_1350 : rot.field_1350);
                double z = boat.method_23321() + (i == 1 ? rot.field_1352 : -rot.field_1352);
                class_243 paddlePos = new class_243(x, (double)y, z);
                class_243 dir = class_243.method_1030((float)0.0f, (float)boat.method_36454()).method_1021(velocity);
                class_243 from = paddlePos;
                class_243 to = paddlePos.method_1019(dir.method_1021(2.0));
                nodesAffected.addAll(Factory.nodeTrail(from.field_1352, from.field_1350, to.field_1352, to.field_1350, y, WakesClient.CONFIG_INSTANCE.paddleStrength, velocity));
            }
            return nodesAffected;
        }

        public static Set<WakeNode> nodeTrail(double fromX, double fromZ, double toX, double toZ, int y, float waveStrength, double velocity) {
            int res = WakeNode.res;
            int x1 = (int)(fromX * (double)res);
            int z1 = (int)(fromZ * (double)res);
            int x2 = (int)(toX * (double)res);
            int z2 = (int)(toZ * (double)res);
            ArrayList<Long> pixelsAffected = new ArrayList<Long>();
            WakesUtils.bresenhamLine(x1, z1, x2, z2, pixelsAffected);
            return Factory.pixelsToNodes(pixelsAffected, y, waveStrength, velocity);
        }

        public static Set<WakeNode> thickNodeTrail(double fromX, double fromZ, double toX, double toZ, int y, float waveStrength, double velocity, float width) {
            int res = WakeNode.res;
            int x1 = (int)(fromX * (double)res);
            int z1 = (int)(fromZ * (double)res);
            int x2 = (int)(toX * (double)res);
            int z2 = (int)(toZ * (double)res);
            int w = (int)(0.8 * (double)width * (double)res / 2.0);
            float len = (float)Math.sqrt(Math.pow(z1 - z2, 2.0) + Math.pow(x2 - x1, 2.0));
            float nx = (float)(z1 - z2) / len;
            float nz = (float)(x2 - x1) / len;
            ArrayList<Long> pixelsAffected = new ArrayList<Long>();
            for (int i = -w; i < w; ++i) {
                WakesUtils.bresenhamLine((int)((float)x1 + nx * (float)i), (int)((float)z1 + nz * (float)i), (int)((float)x2 + nx * (float)i), (int)((float)z2 + nz * (float)i), pixelsAffected);
            }
            return Factory.pixelsToNodes(pixelsAffected, y, waveStrength, velocity);
        }

        public static Set<WakeNode> nodeLine(double x, int y, double z, float waveStrength, class_243 velocity, float width) {
            int res = WakeNode.res;
            class_243 dir = velocity.method_1029();
            double nx = -dir.field_1350;
            double nz = dir.field_1352;
            int w = (int)(0.8 * (double)width * (double)res / 2.0);
            int x1 = (int)(x * (double)res - nx * (double)w);
            int z1 = (int)(z * (double)res - nz * (double)w);
            int x2 = (int)(x * (double)res + nx * (double)w);
            int z2 = (int)(z * (double)res + nz * (double)w);
            ArrayList<Long> pixelsAffected = new ArrayList<Long>();
            WakesUtils.bresenhamLine(x1, z1, x2, z2, pixelsAffected);
            return Factory.pixelsToNodes(pixelsAffected, y, waveStrength, velocity.method_37267());
        }

        private static Set<WakeNode> pixelsToNodes(ArrayList<Long> pixelsAffected, int y, float waveStrength, double velocity) {
            int res = WakeNode.res;
            int power = (int)(Math.log(res) / Math.log(2.0));
            HashMap pixelsInNodes = new HashMap();
            for (Long pixel : pixelsAffected) {
                int[] pos = WakesUtils.longAsPos(pixel);
                long k = WakesUtils.posAsLong(pos[0] >> power, pos[1] >> power);
                pos[0] = pos[0] % res;
                pos[1] = pos[1] % res;
                long v = WakesUtils.posAsLong(pos[0], pos[1]);
                if (pixelsInNodes.containsKey(k)) {
                    ((HashSet)pixelsInNodes.get(k)).add(v);
                    continue;
                }
                HashSet<Long> set = new HashSet<Long>();
                set.add(v);
                pixelsInNodes.put(k, set);
            }
            HashSet<WakeNode> nodesAffected = new HashSet<WakeNode>();
            for (Long nodePos : pixelsInNodes.keySet()) {
                WakeNode node = new WakeNode(nodePos, y);
                for (Long subPos : (HashSet)pixelsInNodes.get(nodePos)) {
                    node.setInitialValue(subPos, (int)((double)waveStrength * velocity));
                }
                nodesAffected.add(node);
            }
            return nodesAffected;
        }
    }
}

