/*
 * Decompiled with CFR 0.152.
 */
package com.goby56.wakes.tests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class GreedyMesherTest {
    @Test
    void close2x2() {
        int[] bits = GreedyMesherTest.patternToBits("0 0 0 0 0 0\n1 1 0 0 0 0\n1 1 0 0 0 0\n0 0 0 0 0 0\n0 0 0 0 0 0\n0 0 0 0 0 0\n", 6);
        ArrayList<BasicQuad> quads = GreedyMesherTest.mesher(bits, 6);
        Assertions.assertEquals((int)1, (int)quads.size());
        BasicQuad q = quads.get(0);
        Assertions.assertEquals((int)0, (int)q.x);
        Assertions.assertEquals((int)3, (int)q.z);
        Assertions.assertEquals((int)2, (int)q.w);
        Assertions.assertEquals((int)2, (int)q.h);
    }

    @Test
    void far2x3() {
        int[] bits = GreedyMesherTest.patternToBits("0 0 0 0 0 0\n0 0 0 0 0 0\n0 0 0 1 1 0\n0 0 0 1 1 0\n0 0 0 1 1 0\n0 0 0 0 0 0\n", 6);
        ArrayList<BasicQuad> quads = GreedyMesherTest.mesher(bits, 6);
        Assertions.assertEquals((int)1, (int)quads.size());
        BasicQuad q = quads.get(0);
        Assertions.assertEquals((int)3, (int)q.x);
        Assertions.assertEquals((int)1, (int)q.z);
        Assertions.assertEquals((int)2, (int)q.w);
        Assertions.assertEquals((int)3, (int)q.h);
    }

    @Test
    void complex() {
        int[] bits = GreedyMesherTest.patternToBits("0 0 0 0 0 0\n1 1 1 0 0 0\n0 0 1 0 0 0\n0 0 0 1 1 0\n1 0 0 1 1 0\n1 0 1 0 0 0\n", 6);
        ArrayList<BasicQuad> quads = GreedyMesherTest.mesher(bits, 6);
        Assertions.assertEquals((int)5, (int)quads.size());
        BasicQuad q = quads.get(0);
        Assertions.assertEquals((int)0, (int)q.x);
        Assertions.assertEquals((int)0, (int)q.z);
        Assertions.assertEquals((int)1, (int)q.w);
        Assertions.assertEquals((int)2, (int)q.h);
        q = quads.get(1);
        Assertions.assertEquals((int)0, (int)q.x);
        Assertions.assertEquals((int)4, (int)q.z);
        Assertions.assertEquals((int)3, (int)q.w);
        Assertions.assertEquals((int)1, (int)q.h);
        q = quads.get(2);
        Assertions.assertEquals((int)2, (int)q.x);
        Assertions.assertEquals((int)0, (int)q.z);
        Assertions.assertEquals((int)1, (int)q.w);
        Assertions.assertEquals((int)1, (int)q.h);
        q = quads.get(3);
        Assertions.assertEquals((int)2, (int)q.x);
        Assertions.assertEquals((int)3, (int)q.z);
        Assertions.assertEquals((int)1, (int)q.w);
        Assertions.assertEquals((int)1, (int)q.h);
        q = quads.get(4);
        Assertions.assertEquals((int)3, (int)q.x);
        Assertions.assertEquals((int)1, (int)q.z);
        Assertions.assertEquals((int)2, (int)q.w);
        Assertions.assertEquals((int)2, (int)q.h);
    }

    public static int[] patternToBits(String pattern, int dim) {
        List<String> rows = Arrays.stream(pattern.split("\n")).map(r -> r.replaceAll("\\s", "")).toList();
        int[] bits = new int[dim];
        for (int i = 0; i < dim; ++i) {
            for (int j = 0; j < dim; ++j) {
                int val = Integer.parseInt(String.valueOf(rows.get(dim - j - 1).charAt(i)));
                int n = i;
                bits[n] = bits[n] | val << j;
            }
        }
        return bits;
    }

    @Test
    void patternConverter() {
        String pattern = "1 0 0 0 0 1\n1 1 0 1 0 1\n1 1 0 0 0 0\n0 0 0 1 0 0\n0 1 1 0 1 0\n0 1 0 0 1 1\n";
        int[] bits = GreedyMesherTest.patternToBits(pattern, 6);
        Assertions.assertEquals((int)56, (int)bits[0]);
        Assertions.assertEquals((int)27, (int)bits[1]);
        Assertions.assertEquals((int)2, (int)bits[2]);
        Assertions.assertEquals((int)20, (int)bits[3]);
        Assertions.assertEquals((int)3, (int)bits[4]);
        Assertions.assertEquals((int)49, (int)bits[5]);
    }

    private static ArrayList<BasicQuad> mesher(int[] ints, int dim) {
        ArrayList<BasicQuad> quads = new ArrayList<BasicQuad>();
        for (int i = 0; i < dim; ++i) {
            int j = 0;
            while (j < dim) {
                int nextH;
                if ((j += Integer.numberOfTrailingZeros(ints[i] >>> j)) >= dim) continue;
                int h = Integer.numberOfTrailingZeros(~(ints[i] >>> j));
                int hm = h == 32 ? -1 : (1 << h) - 1;
                int mask = hm << j;
                int w = 1;
                while (i + w < dim && (nextH = ints[i + w] >>> j & hm) == hm) {
                    int n = i + w;
                    ints[n] = ints[n] & ~mask;
                    ++w;
                }
                quads.add(new BasicQuad(i, j, w, h));
                j += h;
            }
        }
        return quads;
    }

    private record BasicQuad(int x, int z, int w, int h) {
    }
}

