/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.chirpycricket.wildlife.client.entity;

import com.mojang.blaze3d.systems.RenderSystem;
import com.yahoo.chirpycricket.wildlife.entity.WildlifeEntity;
import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5617;
import net.minecraft.class_757;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.object.Color;
import software.bernie.geckolib.model.DefaultedEntityGeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;
import vazkii.patchouli.client.book.gui.GuiBookEntry;

public class WildlifeRenderer
extends GeoEntityRenderer<WildlifeEntity> {
    boolean glowing = false;
    float shadRad = 1.0f;
    private final String texturePath = "textures/model/entity/";

    public WildlifeRenderer(class_5617.class_5618 renderManager, DefaultedEntityGeoModel<WildlifeEntity> modelProvider, float shadowRadius, boolean glow) {
        super(renderManager, modelProvider);
        this.field_4673 = shadowRadius;
        this.shadRad = shadowRadius;
        this.glowing = glow;
        this.addRenderLayer(new ArmorOverlayFeatureRenderer((GeoRenderer<WildlifeEntity>)this, new ArmorOverlayEntityRenderer(renderManager, modelProvider)));
    }

    public void render(WildlifeEntity entity, float yaw, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light) {
        this.field_4673 = entity.method_6109() ? this.shadRad * entity.childScale : this.shadRad;
        if (this.glowing) {
            super.method_3936((class_1297)entity, yaw, tickDelta, matrices, vertexConsumers, 255);
        } else {
            super.method_3936((class_1297)entity, yaw, tickDelta, matrices, vertexConsumers, light);
        }
    }

    public class_2960 getTexture(WildlifeEntity entity) {
        String filename = entity.getTextureFile() != null && !entity.getTextureFile().equals("") && !entity.getTextureFile().equals("textures/model/entity/") ? "textures/model/entity/" + entity.getTextureFile() : "textures/model/entity/" + entity.getDefaultTexture();
        if (entity.method_19538().equals((Object)class_243.field_1353) && class_310.method_1551().field_1755 instanceof GuiBookEntry) {
            filename = "textures/model/entity/" + entity.getDefaultTexture();
        }
        return new class_2960("wildlife", filename);
    }

    public class_1921 getRenderType(WildlifeEntity animatable, class_2960 textureLocation, class_4597 bufferSource, float partialTicks) {
        if (class_310.method_1551().field_1755 instanceof GuiBookEntry) {
            return super.getRenderType((GeoAnimatable)animatable, textureLocation, bufferSource, partialTicks);
        }
        return class_1921.method_23689((class_2960)textureLocation);
    }

    public int getBlockLight2(WildlifeEntity mobEntity, class_2338 blockPos) {
        return this.method_24087((class_1297)mobEntity, blockPos);
    }

    public class ArmorOverlayFeatureRenderer
    extends GeoRenderLayer<WildlifeEntity> {
        private final ArmorOverlayEntityRenderer armorOverlayEntityRenderer;
        class_2960 armorTextureLocation;

        public ArmorOverlayFeatureRenderer(GeoRenderer<WildlifeEntity> entityRendererIn, ArmorOverlayEntityRenderer armorOverlayEntityRenderer) {
            super(entityRendererIn);
            this.armorTextureLocation = null;
            this.armorOverlayEntityRenderer = armorOverlayEntityRenderer;
        }

        public void render(class_4587 poseStack, WildlifeEntity entity, BakedGeoModel bakedModel, class_1921 renderType, class_4597 bufferSource, class_4588 buffer, float partialTick, int packedLight, int packedOverlay) {
            if (entity.getTint() != 0xFFFFFF && entity.getTint() > 0) {
                this.armorTextureLocation = WildlifeRenderer.this.getTexture(entity);
                RenderSystem.setShader(class_757::method_34540);
                this.armorOverlayEntityRenderer.defaultRender(poseStack, (GeoAnimatable)entity, bufferSource, class_1921.method_23576((class_2960)this.armorTextureLocation), bufferSource.getBuffer(class_1921.method_23576((class_2960)this.armorTextureLocation)), entity.field_6283, partialTick, packedLight);
            }
        }
    }

    public class ArmorOverlayEntityRenderer
    extends GeoEntityRenderer<WildlifeEntity> {
        protected ArmorOverlayEntityRenderer(class_5617.class_5618 ctx, DefaultedEntityGeoModel<WildlifeEntity> modelProvider) {
            super(ctx, modelProvider);
        }

        public Color getRenderColor(WildlifeEntity entity, float partialTick, int packedLight) {
            if (entity.getTint() != 0xFFFFFF && entity.getTint() > 0) {
                float a = 1.0f;
                float r = 1.0f;
                float g = 1.0f;
                float b = 1.0f;
                int m = entity.getTint();
                r = (float)(m >> 16 & 0xFF) / 255.0f;
                g = (float)(m >> 8 & 0xFF) / 255.0f;
                b = (float)(m & 0xFF) / 255.0f;
                return new Color(m);
            }
            return Color.WHITE;
        }
    }
}

