/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.chirpycricket.wildlife.config;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.yahoo.chirpycricket.wildlife.config.ConfigFileHelper;
import com.yahoo.chirpycricket.wildlife.registry.Entities;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class Settings {
    public static HashMap<Entities.EntityKey, EntitySettings> settings;
    public static HashMap<Entities.EntityKey, Class> classes;
    public static GlobalSettings globalSettings;
    private static JsonObject biomeJson;
    private static JsonObject itemGroupJson;
    private static JsonObject itemGroupCategoryJson;
    private static JsonObject mobJson;
    private static JsonObject spawnCategories;

    public static void init() {
        if (settings != null) {
            return;
        }
        settings = new HashMap();
        classes = Entities.classesForSettings;
        String filename = FabricLoader.getInstance().getConfigDir() + File.separator + "WildlifeConfig.json";
        try {
            JsonObject json = (JsonObject)new Gson().fromJson((Reader)new FileReader(filename), JsonObject.class);
            Settings.parseJson(json);
            int version = 0;
            if (globalSettings != null) {
                version = Settings.globalSettings.configVersion;
            }
            if (version < 5) {
                ConfigFileHelper.createBackupSettingsFile(version);
                if (version < 5) {
                    ConfigFileHelper.createDefaultSettings();
                } else {
                    ConfigFileHelper.createMergedSettings(Settings.mergeJson(json, (JsonObject)new Gson().fromJson("{ \r\n  \"globalSettings\": { \r\n    \"configVersion\": 5, \r\n    \"printBiomes\": false, \r\n    \"globalDebug\": false, \r\n    \"mobCap\": 100, \r\n    \"mobCapRange\": 192 \r\n  }, \r\n  \"biomeGroups\": { \r\n    \"deserts\": [\"mesa\",\"savanna\",\"desert\"], \r\n    \"jungles\": [\"jungles\"], \r\n    \"temperate\": [\"plains\",\"forest\",\"mushroom\"], \r\n    \"shores\": [\"beach\",\"minecraft:stony_shore\",\"minecraft:beach\"], \r\n    \"swamps\": [\"swamp\"], \r\n    \"cold\": [\"mountain\",\"taiga\",\"extreme_hills\"], \r\n    \"snowy\": [\"mountain\",\"icy\"], \r\n    \"mountains\": [\"mountain\",\"extreme_hills\"], \r\n    \"forests\": [\"forest\",\"mushroom\",\"taiga\"], \r\n    \"warmForests\": [\"forest\",\"mushroom\"], \r\n    \"oldForests\": [\"Old Growth Pine Taiga\",\"Old Growth Spruce Taiga\",\"Giant Tree Taiga Hills\",\"Giant Spruce Taiga Hills\",\"Giant Tree Taiga\",\"Giant Spruce Taiga\"], \r\n    \"freshWater\": [\"minecraft:river\",\"minecraft:swamp\"], \r\n    \"saltWater\": [\"ocean\"], \r\n    \"warmOcean\": [\"minecraft:deep_lukewarm_ocean\",\"minecraft:lukewarm_ocean\",\"minecraft:warm_ocean\"], \r\n    \"coldOcean\": [\"minecraft:cold_ocean\",\"minecraft:deep_cold_ocean\",\"minecraft:frozen_ocean\",\"minecraft:deep_frozen_ocean\"], \r\n    \"shallowOcean\": [\"minecraft:ocean\",\"minecraft:frozen_ocean\",\"minecraft:cold_ocean\",\"minecraft:lukewarm_ocean\",\"minecraft:warm_ocean\"], \r\n    \"deepOcean\": [\"minecraft:deep_ocean\",\"minecraft:deep_frozen_ocean\",\"minecraft:deep_cold_ocean\",\"minecraft:deep_lukewarm_ocean\"] \r\n  }, \r\n  \"itemGroups\": { \r\n    \"flowerItems\": [\"sugar\",\"dandelion\",\"poppy\",\"blue_orchid\",\"allium\",\"azure_bluet\",\"red_tulip\",\"orange_tulip\",\"white_tulip\",\"pink_tulip\",\"oxeye_daisy\",\"cornflower\",\"lily_of_the_valley\",\"lilac\",\"rose_bush\",\"peony\",\"flowering_azalea_leaves\"], \r\n    \"grassItems\": [\"hay\",\"grass\",\"fern\",\"tall_grass\",\"large_fern\",\"bamboo\"], \r\n    \"leafItems\": [\"oak_leaves\",\"spruce_leaves\",\"birch_leaves\",\"jungle_leaves\",\"acacia_leaves\",\"dark_oak_leaves\",\"azalea_leaves\",\"flowering_azalea_leaves\",\"lily_pad\",\"small_dripleaf\",\"big_dripleaf\"], \r\n    \"mushroomItems\": [\"brown_mushroom\",\"red_mushroom\",\"crimson_fungus\",\"warped_fungus\"], \r\n    \"rootItems\": [\"cave_vines\",\"vines\",\"hanging_roots\",\"glow_lichen\",\"crimson_roots\",\"warped_roots\",\"nether_wart\",\"cactus\"], \r\n    \"seedItems\": [\"wheat_seeds\",\"melon_seeds\",\"pumpkin_seeds\",\"beetroot_seeds\",\"sweet_berries\"], \r\n    \"vegetableItems\": [\"potato\",\"carrot\",\"beetroot\"], \r\n    \"fruitItems\": [\"sweet_berries\",\"melon_slice\",\"apple\",\"glow_berries\"], \r\n    \"seaweedItems\": [\"seagrass\",\"kelp\",\"tall_seagrass\"], \r\n    \"fishItems\": [\"salmon\",\"cod\",\"tropical_fish\",\"pufferfish\",\"wildlife.raw_anglerfish\",\"wildlife.raw_bettafish\",\"wildlife.raw_bluegill\",\"wildlife.raw_catfish\",\"wildlife.raw_goldfish\",\"wildlife.raw_prawn\",\"wildlife.raw_shrimp\",\"wildlife.raw_rainbow_trout\"], \r\n    \"meatItems\": [\"rabbit\",\"chicken\",\"mutton\",\"beef\",\"porkchop\",\"egg\"], \r\n    \"insectItems\": [\"wildlife:ant\",\"wildlife:cricket\",\"wildlife:dragonfly\",\"wildlife:glasswing_butterfly\",\"wildlife:monarch_butterfly\",\"wildlife:tiger_butterfly\",\"wildlife:spicebush_butterfly\",\"wildlife:morpho_butterfly\",\"wildlife:june_beetle\",\"wildlife:ladybug\",\"wildlife:rhino_beetle\",\"wildlife:snail\",\"wildlife:spider\",\"wildlife:staghorn_beetle\",\"wildlife:stickbug\",\"wildlife:sunflower_beetle\"], \r\n    \"scavengerItems\": [\"egg\",\"rotten_flesh\",\"spider_eye\"] \r\n  }, \r\n  \"itemGroupCategories\": { \r\n    \"nectar\": [\"flowerItems\", \"fruitItems\"], \r\n    \"leafyHerbivore\": [\"grassItems\", \"leafItems\", \"flowerItems\"], \r\n    \"heartyHerbivore\": [\"vegetableItems\", \"fruitItems\", \"mushroomItems\"], \r\n    \"herbivore\": [\"grassItems\", \"leafItems\", \"flowerItems\", \"vegetableItems\", \"fruitItems\", \"mushroomItems\"], \r\n    \"omnivore\": [\"vegetableItems\", \"fruitItems\", \"mushroomItems\", \"meatItems\", \"scavengerItems\"], \r\n    \"carnivore\": [\"meatItems\", \"fishItems\"], \r\n    \"bird\": [\"seedItems\", \"insectItems\"], \r\n    \"bug\": [\"grassItems\", \"leafItems\", \"flowerItems\", \"rootItems\"], \r\n    \"scavenger\": [\"scavengerItems\", \"vegetableItems\", \"fruitItems\", \"mushroomItems\"], \r\n    \"oceanScavenger\": [\"seaweedItems\", \"scavengerItems\", \"fishItems\", \"vegetableItems\"] \r\n  }, \r\n  \"spawnCategories\": { \r\n    \"birdSpawnSettings\": { \r\n      \"shouldSpawn\": true, \r\n      \"spawnDebug\": false, \r\n      \"spawnWeight\": 3, \r\n      \"spawnRandomChance\": 50, \r\n      \"chunkFreq\": 2, \r\n      \"chunkOffset\": 0, \r\n      \"spawnType\": \"overworld\", \r\n      \"minSpawnGroupSize\": 2, \r\n      \"maxSpawnGroupSize\": 4 \r\n    }, \r\n    \"bugSpawnSettings\": { \r\n      \"shouldSpawn\": true, \r\n      \"spawnDebug\": false, \r\n      \"spawnWeight\": 3, \r\n      \"spawnRandomChance\": 50, \r\n      \"chunkFreq\": 2, \r\n      \"chunkOffset\": 1, \r\n      \"spawnType\": \"overworld\", \r\n      \"minSpawnGroupSize\": 2, \r\n      \"maxSpawnGroupSize\": 4 \r\n    }, \r\n    \"smallAnimalSpawnSettings\": { \r\n      \"shouldSpawn\": true, \r\n      \"spawnDebug\": false, \r\n      \"spawnWeight\": 4, \r\n      \"spawnRandomChance\": 50, \r\n      \"chunkFreq\": 3, \r\n      \"chunkOffset\": 0, \r\n      \"spawnType\": \"overworld\", \r\n      \"minSpawnGroupSize\": 2, \r\n      \"maxSpawnGroupSize\": 4 \r\n    }, \r\n    \"mediumAnimalSpawnSettings\": { \r\n      \"shouldSpawn\": true, \r\n      \"spawnDebug\": false, \r\n      \"spawnWeight\": 4, \r\n      \"spawnRandomChance\": 50, \r\n      \"chunkFreq\": 3, \r\n      \"chunkOffset\": 0, \r\n      \"spawnType\": \"overworld\", \r\n      \"minSpawnGroupSize\": 2, \r\n      \"maxSpawnGroupSize\": 4 \r\n    }, \r\n    \"beachSpawnSettings\": { \r\n      \"shouldSpawn\": true, \r\n      \"spawnDebug\": false, \r\n      \"spawnWeight\": 40, \r\n      \"spawnRandomChance\": 100, \r\n      \"chunkFreq\": 1, \r\n      \"chunkOffset\": 0, \r\n      \"spawnType\": \"overworld\", \r\n      \"minSpawnGroupSize\": 4, \r\n      \"maxSpawnGroupSize\": 6 \r\n    }, \r\n    \"seaFloorSpawnSettings\": { \r\n      \"shouldSpawn\": true, \r\n      \"spawnDebug\": false, \r\n      \"spawnWeight\": 20, \r\n      \"spawnRandomChance\": 100, \r\n      \"chunkFreq\": 1, \r\n      \"chunkOffset\": 0, \r\n      \"spawnType\": \"water\", \r\n      \"minSpawnGroupSize\": 2, \r\n      \"maxSpawnGroupSize\": 4 \r\n    }, \r\n    \"fishSpawnSettings\": { \r\n      \"shouldSpawn\": true, \r\n      \"spawnDebug\": false, \r\n      \"spawnWeight\": 10, \r\n      \"spawnRandomChance\": 100, \r\n      \"chunkFreq\": 1, \r\n      \"chunkOffset\": 0, \r\n      \"spawnType\": \"water\", \r\n      \"minSpawnGroupSize\": 3, \r\n      \"maxSpawnGroupSize\": 6 \r\n    } \r\n  }, \r\n  \"mobConfig\": { \r\n    \"SPARROW\": { \r\n      \"spawnCategory\": \"birdSpawnSettings\", \r\n      \"spawnBiomes\": [\"all overworld\"], \r\n      \"health\": 4, \r\n      \"loudness\": 100, \r\n      \"breedingItems\": [\"bird\"] \r\n    }, \r\n    \"COTTONBIRD\": { \r\n      \"spawnCategory\": \"birdSpawnSettings\", \r\n      \"spawnBiomes\": [\"mountains\",\"snowy\"], \r\n      \"health\": 4, \r\n      \"loudness\": 100, \r\n      \"breedingItems\": [\"bird\"] \r\n    }, \r\n    \"WHITE_EYE\": { \r\n      \"spawnCategory\": \"birdSpawnSettings\", \r\n      \"spawnBiomes\": [\"temperate\",\"jungles\",\"swamps\"], \r\n      \"health\": 4, \r\n      \"loudness\": 100, \r\n      \"breedingItems\": [\"bird\"] \r\n    }, \r\n    \"FLYCATCHER\": { \r\n      \"spawnCategory\": \"birdSpawnSettings\", \r\n      \"spawnBiomes\": [\"temperate\",\"jungles\",\"deserts\"], \r\n      \"health\": 4, \r\n      \"loudness\": 100, \r\n      \"breedingItems\": [\"bird\"] \r\n    }, \r\n    \"LARK\": { \r\n      \"spawnCategory\": \"birdSpawnSettings\", \r\n      \"spawnBiomes\": [\"all overworld\"], \r\n      \"health\": 4, \r\n      \"loudness\": 100, \r\n      \"breedingItems\": [\"bird\"] \r\n    }, \r\n    \"ROBIN\": { \r\n      \"spawnCategory\": \"birdSpawnSettings\", \r\n      \"spawnBiomes\": [\"temperate\"], \r\n      \"health\": 4, \r\n      \"loudness\": 100, \r\n      \"breedingItems\": [\"bird\"] \r\n    }, \r\n    \"CHICKADEE\": { \r\n      \"spawnCategory\": \"birdSpawnSettings\", \r\n      \"biomeGroups\": [ \"forests\",\"cold\",\"snowy\",\"mountains\"], \r\n      \"health\": 4, \r\n      \"loudness\": 100, \r\n      \"breedingItems\": [\"bird\"] \r\n    }, \r\n    \"TOWHEE\": { \r\n      \"spawnCategory\": \"birdSpawnSettings\", \r\n      \"spawnBiomes\": [ \"mountains\",\"snowy\",\"cold\"], \r\n      \"health\": 4, \r\n      \"loudness\": 100, \r\n      \"breedingItems\": [\"bird\"] \r\n    }, \r\n    \"WREN\": { \r\n      \"spawnCategory\": \"birdSpawnSettings\", \r\n      \"spawnBiomes\": [\"temperate\",\"jungles\"], \r\n      \"health\": 4, \r\n      \"loudness\": 100, \r\n      \"breedingItems\": [\"bird\"] \r\n    }, \r\n    \"MEADOWLARK\": { \r\n      \"spawnCategory\": \"birdSpawnSettings\", \r\n      \"spawnBiomes\": [\"deserts\",\"cold\"], \r\n      \"spawnWeight\": 3, \r\n      \"health\": 4, \r\n      \"loudness\": 100, \r\n      \"breedingItems\": [\"bird\"] \r\n    }, \r\n    \"ORIOLE\": { \r\n      \"spawnCategory\": \"birdSpawnSettings\", \r\n      \"spawnBiomes\": [\"deserts\",\"jungles\"], \r\n      \"health\": 4, \r\n      \"loudness\": 100, \r\n      \"breedingItems\": [\"bird\"] \r\n    }, \r\n    \"BLUEBIRD\": { \r\n      \"spawnCategory\": \"birdSpawnSettings\", \r\n      \"spawnBiomes\": [\"temperate\",\"mountains\",\"deserts\"], \r\n      \"health\": 4, \r\n      \"loudness\": 100, \r\n      \"breedingItems\": [\"bird\"] \r\n    }, \r\n    \"GOLDFINCH\": { \r\n      \"spawnCategory\": \"birdSpawnSettings\", \r\n      \"spawnBiomes\": [\"temperate\",\"mountains\",\"cold\"], \r\n      \"health\": 4, \r\n      \"loudness\": 100, \r\n      \"breedingItems\": [\"bird\"] \r\n    }, \r\n    \"PHOEBE\": { \r\n      \"spawnCategory\": \"birdSpawnSettings\", \r\n      \"spawnBiomes\": [\"temperate\",\"mountains\",\"cold\",\"snowy\"], \r\n      \"health\": 4, \r\n      \"loudness\": 100, \r\n      \"breedingItems\": [\"bird\"] \r\n    }, \r\n    \"SWALLOW\": { \r\n      \"spawnCategory\": \"birdSpawnSettings\", \r\n      \"spawnBiomes\": [\"swamps\",\"jungles\"], \r\n      \"health\": 4, \r\n      \"loudness\": 100, \r\n      \"breedingItems\": [\"bird\"] \r\n    }, \r\n    \"CRICKET\": { \r\n      \"spawnCategory\": \"bugSpawnSettings\", \r\n      \"spawnBiomes\": [\"temperate\"], \r\n      \"health\": 4, \r\n      \"loudness\": 100, \r\n      \"breedingItems\": [\"bug\"] \r\n    }, \r\n    \"GLASSWING_BUTTERFLY\": { \r\n      \"spawnCategory\": \"bugSpawnSettings\", \r\n      \"spawnBiomes\": [\"temperate\",\"jungles\",\"swamps\",\"deserts\"], \r\n      \"health\": 4, \r\n      \"breedingItems\": [\"nectar\"] \r\n    }, \r\n    \"MONARCH_BUTTERFLY\": { \r\n      \"spawnCategory\": \"bugSpawnSettings\", \r\n      \"spawnBiomes\": [\"temperate\",\"jungles\",\"swamps\",\"warmForests\"], \r\n      \"health\": 4, \r\n      \"breedingItems\": [\"nectar\"] \r\n    }, \r\n    \"MORPHO_BUTTERFLY\": { \r\n      \"spawnCategory\": \"bugSpawnSettings\", \r\n      \"spawnBiomes\": [\"jungles\",\"swamps\"], \r\n      \"health\": 4, \r\n      \"breedingItems\": [\"nectar\"] \r\n    }, \r\n    \"TIGER_BUTTERFLY\": { \r\n      \"spawnCategory\": \"bugSpawnSettings\", \r\n      \"spawnBiomes\": [\"temperate\",\"jungles\",\"swamps\",\"warmForests\"], \r\n      \"health\": 4, \r\n      \"breedingItems\": [\"nectar\"] \r\n    }, \r\n    \"SPICEBUSH_BUTTERFLY\": { \r\n      \"spawnCategory\": \"bugSpawnSettings\", \r\n      \"spawnBiomes\": [\"temperate\",\"jungles\",\"swamps\",\"forests\"], \r\n      \"health\": 4, \r\n      \"breedingItems\": [\"nectar\"] \r\n    }, \r\n    \"DRAGONFLY\": { \r\n      \"spawnCategory\": \"bugSpawnSettings\", \r\n      \"spawnBiomes\": [\"temperate\",\"jungles\",\"swamps\",\"deserts\"], \r\n      \"health\": 4, \r\n      \"breedingItems\": [\"bug\"] \r\n    }, \r\n    \"LADYBUG\": { \r\n      \"spawnCategory\": \"bugSpawnSettings\", \r\n      \"spawnBiomes\": [\"temperate\",\"jungles\",\"swamps\"], \r\n      \"health\": 4, \r\n      \"breedingItems\": [\"bug\"] \r\n    }, \r\n    \"SUNFLOWERBEETLE\": { \r\n      \"spawnCategory\": \"bugSpawnSettings\", \r\n      \"spawnBiomes\": [\"temperate\",\"jungles\",\"deserts\"], \r\n      \"health\": 4, \r\n      \"breedingItems\": [\"bug\"] \r\n    }, \r\n    \"ANT\": { \r\n      \"spawnCategory\": \"bugSpawnSettings\", \r\n      \"spawnBiomes\": [\"temperate\",\"jungles\",\"deserts\",\"swamps\"], \r\n      \"health\": 4, \r\n      \"breedingItems\": [\"bug\"] \r\n    }, \r\n    \"SPIDER\": { \r\n      \"spawnCategory\": \"bugSpawnSettings\", \r\n      \"spawnBiomes\": [\"temperate\",\"jungles\",\"deserts\"], \r\n      \"health\": 4, \r\n      \"breedingItems\": [\"insectItems\"] \r\n    }, \r\n    \"SNAIL\": { \r\n      \"spawnCategory\": \"bugSpawnSettings\", \r\n      \"spawnBiomes\": [\"temperate\",\"jungles\",\"swamps\"], \r\n      \"health\": 4, \r\n      \"Speed\": 0.01, \r\n      \"breedingItems\": [\"insectItems\"] \r\n    }, \r\n    \"STICKBUG\": { \r\n      \"spawnCategory\": \"bugSpawnSettings\", \r\n      \"spawnBiomes\": [\"temperate\",\"jungles\",\"swamps\"], \r\n      \"health\": 4, \r\n      \"breedingItems\": [\"insectItems\"] \r\n    }, \r\n    \"JUNEBEETLE\": { \r\n      \"spawnCategory\": \"bugSpawnSettings\", \r\n      \"spawnBiomes\": [\"temperate\",\"jungles\",\"swamps\",\"deserts\"], \r\n      \"health\": 4, \r\n      \"breedingItems\": [\"insectItems\"] \r\n    }, \r\n    \"RHINOBEETLE\": { \r\n      \"spawnCategory\": \"bugSpawnSettings\", \r\n      \"spawnBiomes\": [\"temperate\",\"jungles\",\"forests\"], \r\n      \"health\": 4, \r\n      \"breedingItems\": [\"insectItems\"] \r\n    }, \r\n    \"STAGHORNBEETLE\": { \r\n      \"spawnCategory\": \"bugSpawnSettings\", \r\n      \"spawnBiomes\": [\"temperate\",\"jungles\",\"forests\"], \r\n      \"health\": 4, \r\n      \"breedingItems\": [\"insectItems\"] \r\n    }, \r\n    \"BADGER\": { \r\n      \"spawnCategory\": \"mediumAnimalSpawnSettings\", \r\n      \"spawnBiomes\": [\"mountains\",\"forests\"], \r\n      \"health\": 10, \r\n      \"breedingItems\": [\"omnivore\"] \r\n    }, \r\n    \"PORCUPINE\": { \r\n      \"spawnCategory\": \"mediumAnimalSpawnSettings\", \r\n      \"spawnBiomes\": [\"mountains\",\"forests\"], \r\n      \"health\": 10, \r\n      \"breedingItems\": [\"herbivore\"] \r\n    }, \r\n    \"BEAVER\": { \r\n      \"spawnCategory\": \"mediumAnimalSpawnSettings\", \r\n      \"spawnBiomes\": [\"swamps\"], \r\n      \"health\": 10, \r\n      \"breedingItems\": [\"herbivore\"] \r\n    }, \r\n    \"ARMADILLO\": { \r\n      \"spawnCategory\": \"mediumAnimalSpawnSettings\", \r\n      \"spawnBiomes\": [\"deserts\"], \r\n      \"health\": 10, \r\n      \"breedingItems\": [\"scavenger\"] \r\n    }, \r\n    \"ANTEATER\": { \r\n      \"spawnCategory\": \"mediumAnimalSpawnSettings\", \r\n      \"spawnBiomes\": [\"deserts\",\"jungles\"], \r\n      \"health\": 10, \r\n      \"breedingItems\": [\"insectItems\"] \r\n    }, \r\n    \"POSSUM\": { \r\n      \"spawnCategory\": \"mediumAnimalSpawnSettings\", \r\n      \"spawnBiomes\": [\"temperate\",\"mountains\",\"forests\"], \r\n      \"health\": 10, \r\n      \"breedingItems\": [\"scavenger\"] \r\n    }, \r\n    \"CAPYBARA\": { \r\n      \"spawnCategory\": \"mediumAnimalSpawnSettings\", \r\n      \"spawnBiomes\": [\"jungles\"], \r\n      \"health\": 15, \r\n      \"breedingItems\": [\"grassItems\",\"vegetableItems\",\"fruitItems\"] \r\n    }, \r\n    \"BOAR\": { \r\n      \"spawnCategory\": \"mediumAnimalSpawnSettings\", \r\n      \"spawnBiomes\": [\"oldForests\"], \r\n      \"health\": 15, \r\n      \"breedingItems\": [\"heartyHerbivore\"] \r\n    }, \r\n    \"DEER\": { \r\n      \"spawnCategory\": \"mediumAnimalSpawnSettings\", \r\n      \"spawnBiomes\": [\"oldForests\"], \r\n      \"health\": 15, \r\n      \"breedingItems\": [\"herbivore\"] \r\n    }, \r\n    \"MONKEY\": { \r\n      \"spawnCategory\": \"mediumAnimalSpawnSettings\", \r\n      \"spawnBiomes\": [\"jungles\"], \r\n      \"health\": 15, \r\n      \"breedingItems\": [\"fruitItems\",\"egg\"] \r\n    }, \r\n    \"IGUANA\": { \r\n      \"spawnCategory\": \"mediumAnimalSpawnSettings\", \r\n      \"spawnBiomes\": [\"deserts\",\"jungles\"], \r\n      \"health\": 10, \r\n      \"breedingItems\": [\"leafyHerbivore\",\"fruitItems\"] \r\n    }, \r\n    \"CRAB\": { \r\n      \"spawnCategory\": \"beachSpawnSettings\", \r\n      \"spawnBiomes\": [\"shores\"], \r\n      \"health\": 10, \r\n      \"breedingItems\": [\"oceanScavenger\"] \r\n    }, \r\n    \"HERMITCRAB\": { \r\n      \"spawnCategory\": \"beachSpawnSettings\", \r\n      \"spawnBiomes\": [\"shores\"], \r\n      \"health\": 10, \r\n      \"breedingItems\": [\"oceanScavenger\"] \r\n    }, \r\n    \"HEDGEHOG\": { \r\n      \"spawnCategory\": \"smallAnimalSpawnSettings\", \r\n      \"spawnBiomes\": [\"temperate\",\"forests\"], \r\n      \"health\": 10, \r\n      \"breedingItems\": [\"insectItems\",\"heartyHerbivore\"] \r\n    }, \r\n    \"FERRET\": { \r\n      \"spawnCategory\": \"smallAnimalSpawnSettings\", \r\n      \"spawnBiomes\": [\"temperate\",\"mountains\",\"forests\",\"cold\",\"snowy\"], \r\n      \"health\": 10, \r\n      \"breedingItems\": [\"carnivore\"] \r\n    }, \r\n    \"HAMSTER\": { \r\n      \"spawnCategory\": \"smallAnimalSpawnSettings\", \r\n      \"spawnBiomes\": [\"deserts\"], \r\n      \"health\": 10, \r\n      \"breedingItems\": [\"seedItems\",\"heartyHerbivore\"] \r\n    }, \r\n    \"CHAMELEON\": { \r\n      \"spawnCategory\": \"smallAnimalSpawnSettings\", \r\n      \"spawnBiomes\": [\"deserts\",\"jungles\"], \r\n      \"health\": 7, \r\n      \"breedingItems\": [\"insectItems\"] \r\n    }, \r\n    \"GECKO\": { \r\n      \"spawnCategory\": \"smallAnimalSpawnSettings\", \r\n      \"spawnBiomes\": [\"deserts\",\"jungles\",\"temperate\"], \r\n      \"health\": 4, \r\n      \"breedingItems\": [\"insectItems\"] \r\n    }, \r\n    \"GRASS_SNAKE\": { \r\n      \"spawnCategory\": \"mediumAnimalSpawnSettings\", \r\n      \"spawnBiomes\": [\"jungles\",\"temperate\"], \r\n      \"health\": 8, \r\n      \"breedingItems\": [\"insectItems\"] \r\n    }, \r\n    \"KING_SNAKE\": { \r\n      \"spawnCategory\": \"mediumAnimalSpawnSettings\", \r\n      \"spawnBiomes\": [\"jungles\",\"temperate\",\"swamps\",\"deserts\"], \r\n      \"health\": 10, \r\n      \"breedingItems\": [\"carnivore\"] \r\n    }, \r\n    \"MILK_SNAKE\": { \r\n      \"spawnCategory\": \"mediumAnimalSpawnSettings\", \r\n      \"spawnBiomes\": [\"jungles\",\"swamps\",\"deserts\"], \r\n      \"health\": 8, \r\n      \"breedingItems\": [\"insectItems\",\"carnivore\"] \r\n    }, \r\n    \"PYTHON\": { \r\n      \"spawnCategory\": \"mediumAnimalSpawnSettings\", \r\n      \"spawnBiomes\": [\"jungles\",\"swamps\",\"deserts\"], \r\n      \"health\": 15, \r\n      \"breedingItems\": [\"carnivore\"] \r\n    }, \r\n    \"BLUEGILL\": { \r\n      \"spawnCategory\": \"fishSpawnSettings\", \r\n      \"spawnBiomes\": [\"freshWater\"], \r\n      \"health\": 3, \r\n      \"breedingItems\": [\"insectItems\"] \r\n    }, \r\n    \"RAINBOW_TROUT\": { \r\n      \"spawnCategory\": \"fishSpawnSettings\", \r\n      \"spawnBiomes\": [\"freshWater\"], \r\n      \"health\": 3, \r\n      \"breedingItems\": [\"insectItems\"] \r\n    }, \r\n    \"KOI\": { \r\n      \"spawnCategory\": \"fishSpawnSettings\", \r\n      \"spawnBiomes\": [\"freshWater\"], \r\n      \"health\": 3, \r\n      \"breedingItems\": [\"insectItems\"] \r\n    }, \r\n    \"BETTAFISH\": { \r\n      \"spawnCategory\": \"fishSpawnSettings\", \r\n      \"spawnBiomes\": [\"freshWater\"], \r\n      \"health\": 3, \r\n      \"breedingItems\": [\"insectItems\"] \r\n    }, \r\n    \"GOLDFISH\": { \r\n      \"spawnCategory\": \"fishSpawnSettings\", \r\n      \"spawnBiomes\": [\"freshWater\"], \r\n      \"health\": 3, \r\n      \"breedingItems\": [\"insectItems\"] \r\n    }, \r\n    \"PRAWN\": { \r\n      \"spawnCategory\": \"fishSpawnSettings\", \r\n      \"spawnBiomes\": [\"freshWater\"], \r\n      \"health\": 3, \r\n      \"breedingItems\": [\"oceanScavenger\"] \r\n    }, \r\n    \"SHRIMP\": { \r\n      \"spawnCategory\": \"fishSpawnSettings\", \r\n      \"spawnBiomes\": [\"saltWater\"], \r\n      \"health\": 3, \r\n      \"breedingItems\": [\"oceanScavenger\"] \r\n    }, \r\n    \"ANGLERFISH\": { \r\n      \"spawnCategory\": \"fishSpawnSettings\", \r\n      \"spawnBiomes\": [\"deepOcean\"], \r\n      \"health\": 3, \r\n      \"breedingItems\": [\"fishItems\"] \r\n    }, \r\n    \"JELLYFISH\": { \r\n      \"spawnCategory\": \"fishSpawnSettings\", \r\n      \"spawnBiomes\": [\"saltWater\"], \r\n      \"health\": 3, \r\n      \"breedingItems\": [\"fishItems\"] \r\n    }, \r\n    \"GLOW_JELLYFISH\": { \r\n      \"spawnCategory\": \"fishSpawnSettings\", \r\n      \"spawnBiomes\": [\"deepOcean\"], \r\n      \"health\": 3, \r\n      \"breedingItems\": [\"fishItems\"] \r\n    }, \r\n    \"SEAHORSE\": { \r\n      \"spawnCategory\": \"fishSpawnSettings\", \r\n      \"spawnBiomes\": [\"warmOcean\"], \r\n      \"health\": 3, \r\n      \"breedingItems\": [\"fishItems\"] \r\n    }, \r\n    \"STINGRAY\": { \r\n      \"spawnCategory\": \"fishSpawnSettings\", \r\n      \"spawnBiomes\": [\"warmOcean\"], \r\n      \"health\": 3, \r\n      \"breedingItems\": [\"fishItems\"] \r\n    }, \r\n    \"MANTARAY\": { \r\n      \"spawnCategory\": \"fishSpawnSettings\", \r\n      \"spawnBiomes\": [\"warmOcean\"], \r\n      \"health\": 3, \r\n      \"breedingItems\": [\"fishItems\"] \r\n    }, \r\n    \"HAMMERHEAD_SHARK\": { \r\n      \"spawnCategory\": \"fishSpawnSettings\", \r\n      \"spawnBiomes\": [\"warmOcean\"], \r\n      \"health\": 3, \r\n      \"breedingItems\": [\"fishItems\"] \r\n    }, \r\n    \"CLAM\": { \r\n      \"spawnCategory\": \"seaFloorSpawnSettings\", \r\n      \"spawnBiomes\": [\"shores\",\"saltWater\"], \r\n      \"health\": 10, \r\n      \"breedingItems\": [\"oceanScavenger\"] \r\n    }, \r\n    \"SEAURCHIN\": { \r\n      \"spawnCategory\": \"seaFloorSpawnSettings\", \r\n      \"spawnBiomes\": [\"shores\",\"saltWater\"], \r\n      \"health\": 10, \r\n      \"breedingItems\": [\"oceanScavenger\"] \r\n    }, \r\n    \"STARFISH\": { \r\n      \"spawnCategory\": \"seaFloorSpawnSettings\", \r\n      \"spawnBiomes\": [\"shores\",\"saltWater\"], \r\n      \"health\": 10, \r\n      \"breedingItems\": [\"oceanScavenger\"] \r\n    }, \r\n    \"HORSESHOE_CRAB\": { \r\n      \"spawnCategory\": \"seaFloorSpawnSettings\", \r\n      \"spawnBiomes\": [\"shores\",\"shallowOcean\"], \r\n      \"health\": 10, \r\n      \"breedingItems\": [\"oceanScavenger\"] \r\n    }, \r\n    \"SANDDOLLAR\": { \r\n      \"spawnCategory\": \"seaFloorSpawnSettings\", \r\n      \"spawnBiomes\": [\"shores\",\"shallowOcean\"], \r\n      \"health\": 10, \r\n      \"breedingItems\": [\"oceanScavenger\"] \r\n    }, \r\n    \"CATFISH\": { \r\n      \"spawnCategory\": \"fishSpawnSettings\", \r\n      \"spawnBiomes\": [\"freshWater\"], \r\n      \"health\": 3, \r\n      \"breedingItems\": [\"insectItems\"] \r\n    }, \r\n    \"ALLIGATOR\": { \r\n      \"spawnCategory\": \"mediumAnimalSpawnSettings\", \r\n      \"spawnBiomes\": [\"jungles\",\"swamps\",\"deserts\"], \r\n      \"isAggressive\": true, \r\n      \"health\": 25, \r\n      \"breedingItems\": [\"carnivore\"] \r\n    } \r\n  } \r\n}", JsonObject.class)));
                }
                json = (JsonObject)new Gson().fromJson((Reader)new FileReader(filename), JsonObject.class);
                Settings.parseJson(json);
            }
        }
        catch (IOException e) {
            Settings.parseJson("{ \r\n  \"globalSettings\": { \r\n    \"configVersion\": 5, \r\n    \"printBiomes\": false, \r\n    \"globalDebug\": false, \r\n    \"mobCap\": 100, \r\n    \"mobCapRange\": 192 \r\n  }, \r\n  \"biomeGroups\": { \r\n    \"deserts\": [\"mesa\",\"savanna\",\"desert\"], \r\n    \"jungles\": [\"jungles\"], \r\n    \"temperate\": [\"plains\",\"forest\",\"mushroom\"], \r\n    \"shores\": [\"beach\",\"minecraft:stony_shore\",\"minecraft:beach\"], \r\n    \"swamps\": [\"swamp\"], \r\n    \"cold\": [\"mountain\",\"taiga\",\"extreme_hills\"], \r\n    \"snowy\": [\"mountain\",\"icy\"], \r\n    \"mountains\": [\"mountain\",\"extreme_hills\"], \r\n    \"forests\": [\"forest\",\"mushroom\",\"taiga\"], \r\n    \"warmForests\": [\"forest\",\"mushroom\"], \r\n    \"oldForests\": [\"Old Growth Pine Taiga\",\"Old Growth Spruce Taiga\",\"Giant Tree Taiga Hills\",\"Giant Spruce Taiga Hills\",\"Giant Tree Taiga\",\"Giant Spruce Taiga\"], \r\n    \"freshWater\": [\"minecraft:river\",\"minecraft:swamp\"], \r\n    \"saltWater\": [\"ocean\"], \r\n    \"warmOcean\": [\"minecraft:deep_lukewarm_ocean\",\"minecraft:lukewarm_ocean\",\"minecraft:warm_ocean\"], \r\n    \"coldOcean\": [\"minecraft:cold_ocean\",\"minecraft:deep_cold_ocean\",\"minecraft:frozen_ocean\",\"minecraft:deep_frozen_ocean\"], \r\n    \"shallowOcean\": [\"minecraft:ocean\",\"minecraft:frozen_ocean\",\"minecraft:cold_ocean\",\"minecraft:lukewarm_ocean\",\"minecraft:warm_ocean\"], \r\n    \"deepOcean\": [\"minecraft:deep_ocean\",\"minecraft:deep_frozen_ocean\",\"minecraft:deep_cold_ocean\",\"minecraft:deep_lukewarm_ocean\"] \r\n  }, \r\n  \"itemGroups\": { \r\n    \"flowerItems\": [\"sugar\",\"dandelion\",\"poppy\",\"blue_orchid\",\"allium\",\"azure_bluet\",\"red_tulip\",\"orange_tulip\",\"white_tulip\",\"pink_tulip\",\"oxeye_daisy\",\"cornflower\",\"lily_of_the_valley\",\"lilac\",\"rose_bush\",\"peony\",\"flowering_azalea_leaves\"], \r\n    \"grassItems\": [\"hay\",\"grass\",\"fern\",\"tall_grass\",\"large_fern\",\"bamboo\"], \r\n    \"leafItems\": [\"oak_leaves\",\"spruce_leaves\",\"birch_leaves\",\"jungle_leaves\",\"acacia_leaves\",\"dark_oak_leaves\",\"azalea_leaves\",\"flowering_azalea_leaves\",\"lily_pad\",\"small_dripleaf\",\"big_dripleaf\"], \r\n    \"mushroomItems\": [\"brown_mushroom\",\"red_mushroom\",\"crimson_fungus\",\"warped_fungus\"], \r\n    \"rootItems\": [\"cave_vines\",\"vines\",\"hanging_roots\",\"glow_lichen\",\"crimson_roots\",\"warped_roots\",\"nether_wart\",\"cactus\"], \r\n    \"seedItems\": [\"wheat_seeds\",\"melon_seeds\",\"pumpkin_seeds\",\"beetroot_seeds\",\"sweet_berries\"], \r\n    \"vegetableItems\": [\"potato\",\"carrot\",\"beetroot\"], \r\n    \"fruitItems\": [\"sweet_berries\",\"melon_slice\",\"apple\",\"glow_berries\"], \r\n    \"seaweedItems\": [\"seagrass\",\"kelp\",\"tall_seagrass\"], \r\n    \"fishItems\": [\"salmon\",\"cod\",\"tropical_fish\",\"pufferfish\",\"wildlife.raw_anglerfish\",\"wildlife.raw_bettafish\",\"wildlife.raw_bluegill\",\"wildlife.raw_catfish\",\"wildlife.raw_goldfish\",\"wildlife.raw_prawn\",\"wildlife.raw_shrimp\",\"wildlife.raw_rainbow_trout\"], \r\n    \"meatItems\": [\"rabbit\",\"chicken\",\"mutton\",\"beef\",\"porkchop\",\"egg\"], \r\n    \"insectItems\": [\"wildlife:ant\",\"wildlife:cricket\",\"wildlife:dragonfly\",\"wildlife:glasswing_butterfly\",\"wildlife:monarch_butterfly\",\"wildlife:tiger_butterfly\",\"wildlife:spicebush_butterfly\",\"wildlife:morpho_butterfly\",\"wildlife:june_beetle\",\"wildlife:ladybug\",\"wildlife:rhino_beetle\",\"wildlife:snail\",\"wildlife:spider\",\"wildlife:staghorn_beetle\",\"wildlife:stickbug\",\"wildlife:sunflower_beetle\"], \r\n    \"scavengerItems\": [\"egg\",\"rotten_flesh\",\"spider_eye\"] \r\n  }, \r\n  \"itemGroupCategories\": { \r\n    \"nectar\": [\"flowerItems\", \"fruitItems\"], \r\n    \"leafyHerbivore\": [\"grassItems\", \"leafItems\", \"flowerItems\"], \r\n    \"heartyHerbivore\": [\"vegetableItems\", \"fruitItems\", \"mushroomItems\"], \r\n    \"herbivore\": [\"grassItems\", \"leafItems\", \"flowerItems\", \"vegetableItems\", \"fruitItems\", \"mushroomItems\"], \r\n    \"omnivore\": [\"vegetableItems\", \"fruitItems\", \"mushroomItems\", \"meatItems\", \"scavengerItems\"], \r\n    \"carnivore\": [\"meatItems\", \"fishItems\"], \r\n    \"bird\": [\"seedItems\", \"insectItems\"], \r\n    \"bug\": [\"grassItems\", \"leafItems\", \"flowerItems\", \"rootItems\"], \r\n    \"scavenger\": [\"scavengerItems\", \"vegetableItems\", \"fruitItems\", \"mushroomItems\"], \r\n    \"oceanScavenger\": [\"seaweedItems\", \"scavengerItems\", \"fishItems\", \"vegetableItems\"] \r\n  }, \r\n  \"spawnCategories\": { \r\n    \"birdSpawnSettings\": { \r\n      \"shouldSpawn\": true, \r\n      \"spawnDebug\": false, \r\n      \"spawnWeight\": 3, \r\n      \"spawnRandomChance\": 50, \r\n      \"chunkFreq\": 2, \r\n      \"chunkOffset\": 0, \r\n      \"spawnType\": \"overworld\", \r\n      \"minSpawnGroupSize\": 2, \r\n      \"maxSpawnGroupSize\": 4 \r\n    }, \r\n    \"bugSpawnSettings\": { \r\n      \"shouldSpawn\": true, \r\n      \"spawnDebug\": false, \r\n      \"spawnWeight\": 3, \r\n      \"spawnRandomChance\": 50, \r\n      \"chunkFreq\": 2, \r\n      \"chunkOffset\": 1, \r\n      \"spawnType\": \"overworld\", \r\n      \"minSpawnGroupSize\": 2, \r\n      \"maxSpawnGroupSize\": 4 \r\n    }, \r\n    \"smallAnimalSpawnSettings\": { \r\n      \"shouldSpawn\": true, \r\n      \"spawnDebug\": false, \r\n      \"spawnWeight\": 4, \r\n      \"spawnRandomChance\": 50, \r\n      \"chunkFreq\": 3, \r\n      \"chunkOffset\": 0, \r\n      \"spawnType\": \"overworld\", \r\n      \"minSpawnGroupSize\": 2, \r\n      \"maxSpawnGroupSize\": 4 \r\n    }, \r\n    \"mediumAnimalSpawnSettings\": { \r\n      \"shouldSpawn\": true, \r\n      \"spawnDebug\": false, \r\n      \"spawnWeight\": 4, \r\n      \"spawnRandomChance\": 50, \r\n      \"chunkFreq\": 3, \r\n      \"chunkOffset\": 0, \r\n      \"spawnType\": \"overworld\", \r\n      \"minSpawnGroupSize\": 2, \r\n      \"maxSpawnGroupSize\": 4 \r\n    }, \r\n    \"beachSpawnSettings\": { \r\n      \"shouldSpawn\": true, \r\n      \"spawnDebug\": false, \r\n      \"spawnWeight\": 40, \r\n      \"spawnRandomChance\": 100, \r\n      \"chunkFreq\": 1, \r\n      \"chunkOffset\": 0, \r\n      \"spawnType\": \"overworld\", \r\n      \"minSpawnGroupSize\": 4, \r\n      \"maxSpawnGroupSize\": 6 \r\n    }, \r\n    \"seaFloorSpawnSettings\": { \r\n      \"shouldSpawn\": true, \r\n      \"spawnDebug\": false, \r\n      \"spawnWeight\": 20, \r\n      \"spawnRandomChance\": 100, \r\n      \"chunkFreq\": 1, \r\n      \"chunkOffset\": 0, \r\n      \"spawnType\": \"water\", \r\n      \"minSpawnGroupSize\": 2, \r\n      \"maxSpawnGroupSize\": 4 \r\n    }, \r\n    \"fishSpawnSettings\": { \r\n      \"shouldSpawn\": true, \r\n      \"spawnDebug\": false, \r\n      \"spawnWeight\": 10, \r\n      \"spawnRandomChance\": 100, \r\n      \"chunkFreq\": 1, \r\n      \"chunkOffset\": 0, \r\n      \"spawnType\": \"water\", \r\n      \"minSpawnGroupSize\": 3, \r\n      \"maxSpawnGroupSize\": 6 \r\n    } \r\n  }, \r\n  \"mobConfig\": { \r\n    \"SPARROW\": { \r\n      \"spawnCategory\": \"birdSpawnSettings\", \r\n      \"spawnBiomes\": [\"all overworld\"], \r\n      \"health\": 4, \r\n      \"loudness\": 100, \r\n      \"breedingItems\": [\"bird\"] \r\n    }, \r\n    \"COTTONBIRD\": { \r\n      \"spawnCategory\": \"birdSpawnSettings\", \r\n      \"spawnBiomes\": [\"mountains\",\"snowy\"], \r\n      \"health\": 4, \r\n      \"loudness\": 100, \r\n      \"breedingItems\": [\"bird\"] \r\n    }, \r\n    \"WHITE_EYE\": { \r\n      \"spawnCategory\": \"birdSpawnSettings\", \r\n      \"spawnBiomes\": [\"temperate\",\"jungles\",\"swamps\"], \r\n      \"health\": 4, \r\n      \"loudness\": 100, \r\n      \"breedingItems\": [\"bird\"] \r\n    }, \r\n    \"FLYCATCHER\": { \r\n      \"spawnCategory\": \"birdSpawnSettings\", \r\n      \"spawnBiomes\": [\"temperate\",\"jungles\",\"deserts\"], \r\n      \"health\": 4, \r\n      \"loudness\": 100, \r\n      \"breedingItems\": [\"bird\"] \r\n    }, \r\n    \"LARK\": { \r\n      \"spawnCategory\": \"birdSpawnSettings\", \r\n      \"spawnBiomes\": [\"all overworld\"], \r\n      \"health\": 4, \r\n      \"loudness\": 100, \r\n      \"breedingItems\": [\"bird\"] \r\n    }, \r\n    \"ROBIN\": { \r\n      \"spawnCategory\": \"birdSpawnSettings\", \r\n      \"spawnBiomes\": [\"temperate\"], \r\n      \"health\": 4, \r\n      \"loudness\": 100, \r\n      \"breedingItems\": [\"bird\"] \r\n    }, \r\n    \"CHICKADEE\": { \r\n      \"spawnCategory\": \"birdSpawnSettings\", \r\n      \"biomeGroups\": [ \"forests\",\"cold\",\"snowy\",\"mountains\"], \r\n      \"health\": 4, \r\n      \"loudness\": 100, \r\n      \"breedingItems\": [\"bird\"] \r\n    }, \r\n    \"TOWHEE\": { \r\n      \"spawnCategory\": \"birdSpawnSettings\", \r\n      \"spawnBiomes\": [ \"mountains\",\"snowy\",\"cold\"], \r\n      \"health\": 4, \r\n      \"loudness\": 100, \r\n      \"breedingItems\": [\"bird\"] \r\n    }, \r\n    \"WREN\": { \r\n      \"spawnCategory\": \"birdSpawnSettings\", \r\n      \"spawnBiomes\": [\"temperate\",\"jungles\"], \r\n      \"health\": 4, \r\n      \"loudness\": 100, \r\n      \"breedingItems\": [\"bird\"] \r\n    }, \r\n    \"MEADOWLARK\": { \r\n      \"spawnCategory\": \"birdSpawnSettings\", \r\n      \"spawnBiomes\": [\"deserts\",\"cold\"], \r\n      \"spawnWeight\": 3, \r\n      \"health\": 4, \r\n      \"loudness\": 100, \r\n      \"breedingItems\": [\"bird\"] \r\n    }, \r\n    \"ORIOLE\": { \r\n      \"spawnCategory\": \"birdSpawnSettings\", \r\n      \"spawnBiomes\": [\"deserts\",\"jungles\"], \r\n      \"health\": 4, \r\n      \"loudness\": 100, \r\n      \"breedingItems\": [\"bird\"] \r\n    }, \r\n    \"BLUEBIRD\": { \r\n      \"spawnCategory\": \"birdSpawnSettings\", \r\n      \"spawnBiomes\": [\"temperate\",\"mountains\",\"deserts\"], \r\n      \"health\": 4, \r\n      \"loudness\": 100, \r\n      \"breedingItems\": [\"bird\"] \r\n    }, \r\n    \"GOLDFINCH\": { \r\n      \"spawnCategory\": \"birdSpawnSettings\", \r\n      \"spawnBiomes\": [\"temperate\",\"mountains\",\"cold\"], \r\n      \"health\": 4, \r\n      \"loudness\": 100, \r\n      \"breedingItems\": [\"bird\"] \r\n    }, \r\n    \"PHOEBE\": { \r\n      \"spawnCategory\": \"birdSpawnSettings\", \r\n      \"spawnBiomes\": [\"temperate\",\"mountains\",\"cold\",\"snowy\"], \r\n      \"health\": 4, \r\n      \"loudness\": 100, \r\n      \"breedingItems\": [\"bird\"] \r\n    }, \r\n    \"SWALLOW\": { \r\n      \"spawnCategory\": \"birdSpawnSettings\", \r\n      \"spawnBiomes\": [\"swamps\",\"jungles\"], \r\n      \"health\": 4, \r\n      \"loudness\": 100, \r\n      \"breedingItems\": [\"bird\"] \r\n    }, \r\n    \"CRICKET\": { \r\n      \"spawnCategory\": \"bugSpawnSettings\", \r\n      \"spawnBiomes\": [\"temperate\"], \r\n      \"health\": 4, \r\n      \"loudness\": 100, \r\n      \"breedingItems\": [\"bug\"] \r\n    }, \r\n    \"GLASSWING_BUTTERFLY\": { \r\n      \"spawnCategory\": \"bugSpawnSettings\", \r\n      \"spawnBiomes\": [\"temperate\",\"jungles\",\"swamps\",\"deserts\"], \r\n      \"health\": 4, \r\n      \"breedingItems\": [\"nectar\"] \r\n    }, \r\n    \"MONARCH_BUTTERFLY\": { \r\n      \"spawnCategory\": \"bugSpawnSettings\", \r\n      \"spawnBiomes\": [\"temperate\",\"jungles\",\"swamps\",\"warmForests\"], \r\n      \"health\": 4, \r\n      \"breedingItems\": [\"nectar\"] \r\n    }, \r\n    \"MORPHO_BUTTERFLY\": { \r\n      \"spawnCategory\": \"bugSpawnSettings\", \r\n      \"spawnBiomes\": [\"jungles\",\"swamps\"], \r\n      \"health\": 4, \r\n      \"breedingItems\": [\"nectar\"] \r\n    }, \r\n    \"TIGER_BUTTERFLY\": { \r\n      \"spawnCategory\": \"bugSpawnSettings\", \r\n      \"spawnBiomes\": [\"temperate\",\"jungles\",\"swamps\",\"warmForests\"], \r\n      \"health\": 4, \r\n      \"breedingItems\": [\"nectar\"] \r\n    }, \r\n    \"SPICEBUSH_BUTTERFLY\": { \r\n      \"spawnCategory\": \"bugSpawnSettings\", \r\n      \"spawnBiomes\": [\"temperate\",\"jungles\",\"swamps\",\"forests\"], \r\n      \"health\": 4, \r\n      \"breedingItems\": [\"nectar\"] \r\n    }, \r\n    \"DRAGONFLY\": { \r\n      \"spawnCategory\": \"bugSpawnSettings\", \r\n      \"spawnBiomes\": [\"temperate\",\"jungles\",\"swamps\",\"deserts\"], \r\n      \"health\": 4, \r\n      \"breedingItems\": [\"bug\"] \r\n    }, \r\n    \"LADYBUG\": { \r\n      \"spawnCategory\": \"bugSpawnSettings\", \r\n      \"spawnBiomes\": [\"temperate\",\"jungles\",\"swamps\"], \r\n      \"health\": 4, \r\n      \"breedingItems\": [\"bug\"] \r\n    }, \r\n    \"SUNFLOWERBEETLE\": { \r\n      \"spawnCategory\": \"bugSpawnSettings\", \r\n      \"spawnBiomes\": [\"temperate\",\"jungles\",\"deserts\"], \r\n      \"health\": 4, \r\n      \"breedingItems\": [\"bug\"] \r\n    }, \r\n    \"ANT\": { \r\n      \"spawnCategory\": \"bugSpawnSettings\", \r\n      \"spawnBiomes\": [\"temperate\",\"jungles\",\"deserts\",\"swamps\"], \r\n      \"health\": 4, \r\n      \"breedingItems\": [\"bug\"] \r\n    }, \r\n    \"SPIDER\": { \r\n      \"spawnCategory\": \"bugSpawnSettings\", \r\n      \"spawnBiomes\": [\"temperate\",\"jungles\",\"deserts\"], \r\n      \"health\": 4, \r\n      \"breedingItems\": [\"insectItems\"] \r\n    }, \r\n    \"SNAIL\": { \r\n      \"spawnCategory\": \"bugSpawnSettings\", \r\n      \"spawnBiomes\": [\"temperate\",\"jungles\",\"swamps\"], \r\n      \"health\": 4, \r\n      \"Speed\": 0.01, \r\n      \"breedingItems\": [\"insectItems\"] \r\n    }, \r\n    \"STICKBUG\": { \r\n      \"spawnCategory\": \"bugSpawnSettings\", \r\n      \"spawnBiomes\": [\"temperate\",\"jungles\",\"swamps\"], \r\n      \"health\": 4, \r\n      \"breedingItems\": [\"insectItems\"] \r\n    }, \r\n    \"JUNEBEETLE\": { \r\n      \"spawnCategory\": \"bugSpawnSettings\", \r\n      \"spawnBiomes\": [\"temperate\",\"jungles\",\"swamps\",\"deserts\"], \r\n      \"health\": 4, \r\n      \"breedingItems\": [\"insectItems\"] \r\n    }, \r\n    \"RHINOBEETLE\": { \r\n      \"spawnCategory\": \"bugSpawnSettings\", \r\n      \"spawnBiomes\": [\"temperate\",\"jungles\",\"forests\"], \r\n      \"health\": 4, \r\n      \"breedingItems\": [\"insectItems\"] \r\n    }, \r\n    \"STAGHORNBEETLE\": { \r\n      \"spawnCategory\": \"bugSpawnSettings\", \r\n      \"spawnBiomes\": [\"temperate\",\"jungles\",\"forests\"], \r\n      \"health\": 4, \r\n      \"breedingItems\": [\"insectItems\"] \r\n    }, \r\n    \"BADGER\": { \r\n      \"spawnCategory\": \"mediumAnimalSpawnSettings\", \r\n      \"spawnBiomes\": [\"mountains\",\"forests\"], \r\n      \"health\": 10, \r\n      \"breedingItems\": [\"omnivore\"] \r\n    }, \r\n    \"PORCUPINE\": { \r\n      \"spawnCategory\": \"mediumAnimalSpawnSettings\", \r\n      \"spawnBiomes\": [\"mountains\",\"forests\"], \r\n      \"health\": 10, \r\n      \"breedingItems\": [\"herbivore\"] \r\n    }, \r\n    \"BEAVER\": { \r\n      \"spawnCategory\": \"mediumAnimalSpawnSettings\", \r\n      \"spawnBiomes\": [\"swamps\"], \r\n      \"health\": 10, \r\n      \"breedingItems\": [\"herbivore\"] \r\n    }, \r\n    \"ARMADILLO\": { \r\n      \"spawnCategory\": \"mediumAnimalSpawnSettings\", \r\n      \"spawnBiomes\": [\"deserts\"], \r\n      \"health\": 10, \r\n      \"breedingItems\": [\"scavenger\"] \r\n    }, \r\n    \"ANTEATER\": { \r\n      \"spawnCategory\": \"mediumAnimalSpawnSettings\", \r\n      \"spawnBiomes\": [\"deserts\",\"jungles\"], \r\n      \"health\": 10, \r\n      \"breedingItems\": [\"insectItems\"] \r\n    }, \r\n    \"POSSUM\": { \r\n      \"spawnCategory\": \"mediumAnimalSpawnSettings\", \r\n      \"spawnBiomes\": [\"temperate\",\"mountains\",\"forests\"], \r\n      \"health\": 10, \r\n      \"breedingItems\": [\"scavenger\"] \r\n    }, \r\n    \"CAPYBARA\": { \r\n      \"spawnCategory\": \"mediumAnimalSpawnSettings\", \r\n      \"spawnBiomes\": [\"jungles\"], \r\n      \"health\": 15, \r\n      \"breedingItems\": [\"grassItems\",\"vegetableItems\",\"fruitItems\"] \r\n    }, \r\n    \"BOAR\": { \r\n      \"spawnCategory\": \"mediumAnimalSpawnSettings\", \r\n      \"spawnBiomes\": [\"oldForests\"], \r\n      \"health\": 15, \r\n      \"breedingItems\": [\"heartyHerbivore\"] \r\n    }, \r\n    \"DEER\": { \r\n      \"spawnCategory\": \"mediumAnimalSpawnSettings\", \r\n      \"spawnBiomes\": [\"oldForests\"], \r\n      \"health\": 15, \r\n      \"breedingItems\": [\"herbivore\"] \r\n    }, \r\n    \"MONKEY\": { \r\n      \"spawnCategory\": \"mediumAnimalSpawnSettings\", \r\n      \"spawnBiomes\": [\"jungles\"], \r\n      \"health\": 15, \r\n      \"breedingItems\": [\"fruitItems\",\"egg\"] \r\n    }, \r\n    \"IGUANA\": { \r\n      \"spawnCategory\": \"mediumAnimalSpawnSettings\", \r\n      \"spawnBiomes\": [\"deserts\",\"jungles\"], \r\n      \"health\": 10, \r\n      \"breedingItems\": [\"leafyHerbivore\",\"fruitItems\"] \r\n    }, \r\n    \"CRAB\": { \r\n      \"spawnCategory\": \"beachSpawnSettings\", \r\n      \"spawnBiomes\": [\"shores\"], \r\n      \"health\": 10, \r\n      \"breedingItems\": [\"oceanScavenger\"] \r\n    }, \r\n    \"HERMITCRAB\": { \r\n      \"spawnCategory\": \"beachSpawnSettings\", \r\n      \"spawnBiomes\": [\"shores\"], \r\n      \"health\": 10, \r\n      \"breedingItems\": [\"oceanScavenger\"] \r\n    }, \r\n    \"HEDGEHOG\": { \r\n      \"spawnCategory\": \"smallAnimalSpawnSettings\", \r\n      \"spawnBiomes\": [\"temperate\",\"forests\"], \r\n      \"health\": 10, \r\n      \"breedingItems\": [\"insectItems\",\"heartyHerbivore\"] \r\n    }, \r\n    \"FERRET\": { \r\n      \"spawnCategory\": \"smallAnimalSpawnSettings\", \r\n      \"spawnBiomes\": [\"temperate\",\"mountains\",\"forests\",\"cold\",\"snowy\"], \r\n      \"health\": 10, \r\n      \"breedingItems\": [\"carnivore\"] \r\n    }, \r\n    \"HAMSTER\": { \r\n      \"spawnCategory\": \"smallAnimalSpawnSettings\", \r\n      \"spawnBiomes\": [\"deserts\"], \r\n      \"health\": 10, \r\n      \"breedingItems\": [\"seedItems\",\"heartyHerbivore\"] \r\n    }, \r\n    \"CHAMELEON\": { \r\n      \"spawnCategory\": \"smallAnimalSpawnSettings\", \r\n      \"spawnBiomes\": [\"deserts\",\"jungles\"], \r\n      \"health\": 7, \r\n      \"breedingItems\": [\"insectItems\"] \r\n    }, \r\n    \"GECKO\": { \r\n      \"spawnCategory\": \"smallAnimalSpawnSettings\", \r\n      \"spawnBiomes\": [\"deserts\",\"jungles\",\"temperate\"], \r\n      \"health\": 4, \r\n      \"breedingItems\": [\"insectItems\"] \r\n    }, \r\n    \"GRASS_SNAKE\": { \r\n      \"spawnCategory\": \"mediumAnimalSpawnSettings\", \r\n      \"spawnBiomes\": [\"jungles\",\"temperate\"], \r\n      \"health\": 8, \r\n      \"breedingItems\": [\"insectItems\"] \r\n    }, \r\n    \"KING_SNAKE\": { \r\n      \"spawnCategory\": \"mediumAnimalSpawnSettings\", \r\n      \"spawnBiomes\": [\"jungles\",\"temperate\",\"swamps\",\"deserts\"], \r\n      \"health\": 10, \r\n      \"breedingItems\": [\"carnivore\"] \r\n    }, \r\n    \"MILK_SNAKE\": { \r\n      \"spawnCategory\": \"mediumAnimalSpawnSettings\", \r\n      \"spawnBiomes\": [\"jungles\",\"swamps\",\"deserts\"], \r\n      \"health\": 8, \r\n      \"breedingItems\": [\"insectItems\",\"carnivore\"] \r\n    }, \r\n    \"PYTHON\": { \r\n      \"spawnCategory\": \"mediumAnimalSpawnSettings\", \r\n      \"spawnBiomes\": [\"jungles\",\"swamps\",\"deserts\"], \r\n      \"health\": 15, \r\n      \"breedingItems\": [\"carnivore\"] \r\n    }, \r\n    \"BLUEGILL\": { \r\n      \"spawnCategory\": \"fishSpawnSettings\", \r\n      \"spawnBiomes\": [\"freshWater\"], \r\n      \"health\": 3, \r\n      \"breedingItems\": [\"insectItems\"] \r\n    }, \r\n    \"RAINBOW_TROUT\": { \r\n      \"spawnCategory\": \"fishSpawnSettings\", \r\n      \"spawnBiomes\": [\"freshWater\"], \r\n      \"health\": 3, \r\n      \"breedingItems\": [\"insectItems\"] \r\n    }, \r\n    \"KOI\": { \r\n      \"spawnCategory\": \"fishSpawnSettings\", \r\n      \"spawnBiomes\": [\"freshWater\"], \r\n      \"health\": 3, \r\n      \"breedingItems\": [\"insectItems\"] \r\n    }, \r\n    \"BETTAFISH\": { \r\n      \"spawnCategory\": \"fishSpawnSettings\", \r\n      \"spawnBiomes\": [\"freshWater\"], \r\n      \"health\": 3, \r\n      \"breedingItems\": [\"insectItems\"] \r\n    }, \r\n    \"GOLDFISH\": { \r\n      \"spawnCategory\": \"fishSpawnSettings\", \r\n      \"spawnBiomes\": [\"freshWater\"], \r\n      \"health\": 3, \r\n      \"breedingItems\": [\"insectItems\"] \r\n    }, \r\n    \"PRAWN\": { \r\n      \"spawnCategory\": \"fishSpawnSettings\", \r\n      \"spawnBiomes\": [\"freshWater\"], \r\n      \"health\": 3, \r\n      \"breedingItems\": [\"oceanScavenger\"] \r\n    }, \r\n    \"SHRIMP\": { \r\n      \"spawnCategory\": \"fishSpawnSettings\", \r\n      \"spawnBiomes\": [\"saltWater\"], \r\n      \"health\": 3, \r\n      \"breedingItems\": [\"oceanScavenger\"] \r\n    }, \r\n    \"ANGLERFISH\": { \r\n      \"spawnCategory\": \"fishSpawnSettings\", \r\n      \"spawnBiomes\": [\"deepOcean\"], \r\n      \"health\": 3, \r\n      \"breedingItems\": [\"fishItems\"] \r\n    }, \r\n    \"JELLYFISH\": { \r\n      \"spawnCategory\": \"fishSpawnSettings\", \r\n      \"spawnBiomes\": [\"saltWater\"], \r\n      \"health\": 3, \r\n      \"breedingItems\": [\"fishItems\"] \r\n    }, \r\n    \"GLOW_JELLYFISH\": { \r\n      \"spawnCategory\": \"fishSpawnSettings\", \r\n      \"spawnBiomes\": [\"deepOcean\"], \r\n      \"health\": 3, \r\n      \"breedingItems\": [\"fishItems\"] \r\n    }, \r\n    \"SEAHORSE\": { \r\n      \"spawnCategory\": \"fishSpawnSettings\", \r\n      \"spawnBiomes\": [\"warmOcean\"], \r\n      \"health\": 3, \r\n      \"breedingItems\": [\"fishItems\"] \r\n    }, \r\n    \"STINGRAY\": { \r\n      \"spawnCategory\": \"fishSpawnSettings\", \r\n      \"spawnBiomes\": [\"warmOcean\"], \r\n      \"health\": 3, \r\n      \"breedingItems\": [\"fishItems\"] \r\n    }, \r\n    \"MANTARAY\": { \r\n      \"spawnCategory\": \"fishSpawnSettings\", \r\n      \"spawnBiomes\": [\"warmOcean\"], \r\n      \"health\": 3, \r\n      \"breedingItems\": [\"fishItems\"] \r\n    }, \r\n    \"HAMMERHEAD_SHARK\": { \r\n      \"spawnCategory\": \"fishSpawnSettings\", \r\n      \"spawnBiomes\": [\"warmOcean\"], \r\n      \"health\": 3, \r\n      \"breedingItems\": [\"fishItems\"] \r\n    }, \r\n    \"CLAM\": { \r\n      \"spawnCategory\": \"seaFloorSpawnSettings\", \r\n      \"spawnBiomes\": [\"shores\",\"saltWater\"], \r\n      \"health\": 10, \r\n      \"breedingItems\": [\"oceanScavenger\"] \r\n    }, \r\n    \"SEAURCHIN\": { \r\n      \"spawnCategory\": \"seaFloorSpawnSettings\", \r\n      \"spawnBiomes\": [\"shores\",\"saltWater\"], \r\n      \"health\": 10, \r\n      \"breedingItems\": [\"oceanScavenger\"] \r\n    }, \r\n    \"STARFISH\": { \r\n      \"spawnCategory\": \"seaFloorSpawnSettings\", \r\n      \"spawnBiomes\": [\"shores\",\"saltWater\"], \r\n      \"health\": 10, \r\n      \"breedingItems\": [\"oceanScavenger\"] \r\n    }, \r\n    \"HORSESHOE_CRAB\": { \r\n      \"spawnCategory\": \"seaFloorSpawnSettings\", \r\n      \"spawnBiomes\": [\"shores\",\"shallowOcean\"], \r\n      \"health\": 10, \r\n      \"breedingItems\": [\"oceanScavenger\"] \r\n    }, \r\n    \"SANDDOLLAR\": { \r\n      \"spawnCategory\": \"seaFloorSpawnSettings\", \r\n      \"spawnBiomes\": [\"shores\",\"shallowOcean\"], \r\n      \"health\": 10, \r\n      \"breedingItems\": [\"oceanScavenger\"] \r\n    }, \r\n    \"CATFISH\": { \r\n      \"spawnCategory\": \"fishSpawnSettings\", \r\n      \"spawnBiomes\": [\"freshWater\"], \r\n      \"health\": 3, \r\n      \"breedingItems\": [\"insectItems\"] \r\n    }, \r\n    \"ALLIGATOR\": { \r\n      \"spawnCategory\": \"mediumAnimalSpawnSettings\", \r\n      \"spawnBiomes\": [\"jungles\",\"swamps\",\"deserts\"], \r\n      \"isAggressive\": true, \r\n      \"health\": 25, \r\n      \"breedingItems\": [\"carnivore\"] \r\n    } \r\n  } \r\n}");
            try {
                ConfigFileHelper.createDefaultSettings();
                System.out.println("No config file found. Created new config file for wildlife mod.");
            }
            catch (IOException ioException) {
                System.out.println("Warning: Was not able to find or create a config file for wildlife mod. Using built-in settings.");
            }
        }
    }

    private static JsonObject mergeJson(JsonObject oldJson, JsonObject newJson) {
        String[] sections = new String[]{"globalSettings", "biomeGroups", "itemGroups", "itemGroupCategories", "spawnCategories", "mobConfig"};
        JsonObject mergedJson = new JsonObject();
        for (int i = 0; i < sections.length; ++i) {
            if (oldJson.has(sections[i]) && oldJson.get(sections[i]).isJsonObject()) {
                mergedJson.add(sections[i], (JsonElement)Settings.mergeSubJson(oldJson.get(sections[i]).getAsJsonObject(), newJson.get(sections[i]).getAsJsonObject()));
                continue;
            }
            if (!newJson.has(sections[i]) || !newJson.get(sections[i]).isJsonObject()) continue;
            mergedJson.add(sections[i], newJson.get(sections[i]));
        }
        return mergedJson;
    }

    private static JsonObject mergeSubJson(JsonObject oldJson, JsonObject newJson) {
        JsonElement element;
        JsonObject mergedJson = new JsonObject();
        Set oldKeySet = oldJson.keySet();
        Set newKeySet = newJson.keySet();
        for (String key : oldKeySet) {
            element = oldJson.get(key);
            if ("configVersion".equals(key)) {
                element = newJson.get(key);
            }
            mergedJson.add(key, element);
        }
        for (String key : newKeySet) {
            element = newJson.get(key);
            if (mergedJson.has(key)) continue;
            mergedJson.add(key, element);
        }
        return mergedJson;
    }

    private static void parseJson(String jsonStr) {
        JsonObject json = (JsonObject)new Gson().fromJson(jsonStr, JsonObject.class);
        Settings.parseJson(json);
    }

    private static void parseJson(JsonObject json) {
        JsonObject globalJson = json.getAsJsonObject("globalSettings");
        globalSettings = new GlobalSettings(globalJson);
        biomeJson = json.getAsJsonObject("biomeGroups");
        spawnCategories = json.getAsJsonObject("spawnCategories");
        itemGroupJson = json.getAsJsonObject("itemGroups");
        itemGroupCategoryJson = json.getAsJsonObject("itemGroupCategories");
        mobJson = json.getAsJsonObject("mobGroups");
        JsonObject mobJson = json.getAsJsonObject("mobConfig");
        for (Entities.EntityKey key : Entities.EntityKey.values()) {
            if (!mobJson.has(key.toString())) continue;
            settings.put(key, new EntitySettings(key, mobJson.getAsJsonObject(key.toString())));
        }
    }

    public static boolean parseBool(boolean defaultVal, JsonElement e) {
        return e != null ? e.getAsBoolean() : defaultVal;
    }

    public static int parseInt(int defaultVal, JsonElement e) {
        return e != null ? e.getAsInt() : defaultVal;
    }

    public static double parseDouble(double defaultVal, JsonElement e) {
        return e != null ? e.getAsDouble() : defaultVal;
    }

    public static String parseString(String defaultVal, JsonElement e) {
        return e != null ? e.getAsString() : defaultVal;
    }

    public static class_1792 parseMinecraftItem(String itemName) {
        if (!"none".equals(itemName.trim().toLowerCase(Locale.ROOT))) {
            try {
                class_1792 item = (class_1792)class_7923.field_41178.method_10223(new class_2960(itemName));
                if (item != null && !item.equals(class_2246.field_10124.method_8389())) {
                    return item;
                }
            }
            catch (Exception e) {
                System.out.println("WARNING: " + itemName + " is not a valid Minecraft item (skipping). [You can fix this by editing/removing the references to " + itemName + " in wildlife's config file]");
            }
        }
        return null;
    }

    public static class_1299 parseMinecraftEntity(String entityName) {
        String entityName2 = entityName.trim();
        if (!"none".equals(entityName2)) {
            Optional type = class_1299.method_5898((String)entityName2);
            if (type.isPresent()) {
                return (class_1299)type.get();
            }
            System.out.println("WARNING: " + entityName2 + " is not a valid Minecraft entity type (skipping). [You can fix this by editing/removing the references to " + entityName + " in wildlife's config file]");
        }
        return null;
    }

    public static class_1792[] parseCompoundItems(JsonObject json, String attributeName) {
        ArrayList<class_1792> parsedItems = new ArrayList<class_1792>();
        if (json.get(attributeName) != null && json.get(attributeName).isJsonArray()) {
            for (JsonElement str : json.getAsJsonArray(attributeName)) {
                String itemElementName = str.getAsString();
                if (itemGroupCategoryJson.get(itemElementName) != null && itemGroupCategoryJson.get(itemElementName).isJsonArray()) {
                    for (JsonElement itemGroup : itemGroupCategoryJson.get(itemElementName).getAsJsonArray()) {
                        if (itemGroupJson.get(itemGroup.getAsString()) == null) continue;
                        for (JsonElement item : itemGroupJson.get(itemGroup.getAsString()).getAsJsonArray()) {
                            class_1792 i = Settings.parseMinecraftItem(item.getAsString());
                            if (i == null) continue;
                            parsedItems.add(i);
                        }
                    }
                    continue;
                }
                if (itemGroupJson.get(itemElementName) != null) {
                    for (JsonElement item : itemGroupJson.get(itemElementName).getAsJsonArray()) {
                        class_1792 i = Settings.parseMinecraftItem(item.getAsString());
                        if (i == null) continue;
                        parsedItems.add(i);
                    }
                    continue;
                }
                class_1792 i = Settings.parseMinecraftItem(itemElementName);
                if (i == null) continue;
                parsedItems.add(i);
            }
        }
        class_1792[] items = new class_1792[parsedItems.size()];
        items = parsedItems.toArray(items);
        return items;
    }

    public static class GlobalSettings {
        public int configVersion = 0;
        public boolean disableGravity = false;
        public boolean mountedFlightAllowed = true;
        public boolean printBiomes = false;
        public boolean enable3rdPersonFlying = false;
        public boolean disableUiOverlay = false;
        public boolean debug = false;
        public int mobCap = 100;
        public int mobCapRange = 192;
        public class_1792 commandItem = class_1802.field_8600;

        public GlobalSettings(JsonObject json) {
            this.configVersion = Settings.parseInt(this.configVersion, json.get("configVersion"));
            this.mobCap = Settings.parseInt(this.mobCap, json.get("mobCap"));
            this.mobCapRange = Settings.parseInt(this.mobCapRange, json.get("mobCapRange"));
            this.printBiomes = Settings.parseBool(this.printBiomes, json.get("printBiomes"));
            this.disableGravity = !Settings.parseBool(this.disableGravity, json.get("enableFlyingGravity"));
            this.enable3rdPersonFlying = Settings.parseBool(this.enable3rdPersonFlying, json.get("enable3rdPersonFlying"));
            this.mountedFlightAllowed = Settings.parseBool(this.mountedFlightAllowed, json.get("mountedFlightAllowed"));
            this.disableUiOverlay = Settings.parseBool(this.disableUiOverlay, json.get("disableUiOverlay"));
            this.debug = Settings.parseBool(this.debug, json.get("globalDebug"));
            String item = Settings.parseString("minecraft:stick", json.get("commandItem"));
            this.commandItem = Settings.parseMinecraftItem(item);
        }
    }

    public static class EntitySettings {
        public boolean shouldSpawn = true;
        public boolean spawnDebug = false;
        public int spawnWeight = 5;
        public int spawnRandomChance = 5;
        public int spawnYCeiling = 50000;
        public int spawnYFloor = -50000;
        public int minSpawnGroupSize = 1;
        public int maxSpawnGroupSize = 3;
        public int maxIn256Region = -1;
        public String diet = "omnivore";
        public String spawnType = "overworld";
        public String temperature = "all";
        public String precipitation = "all";
        public int inventorySize = 3;
        public int chunkFreq = 0;
        public int chunkOffset = 0;
        public double attack = 1.0;
        public double speed = 0.2;
        public double health = 4.0;
        public boolean fleeFromPlayer = false;
        public boolean playerHostile = false;
        public boolean isAggressive = false;
        public boolean battleWithOwner = true;
        public boolean followOwner = false;
        public int tamingChance = 33;
        public double volume = 25.0;
        public boolean specialAbilitiesEnabled = true;
        public String[] spawnBiomes = new String[0];
        public String[] spawnBlocks = new String[0];
        public String[] seekingBlocks = new String[0];
        public class_1299[] mobHostile = new class_1299[0];
        public class_1792[] tamingItems = new class_1792[0];
        public class_1792[] breedingItems = new class_1792[0];
        public class_1792[] foodItems = new class_1792[0];

        public EntitySettings(Entities.EntityKey entityKey, JsonObject json) {
            this.isAggressive = Settings.parseBool(this.isAggressive, json.get("isAggressive"));
            this.fleeFromPlayer = Settings.parseBool(this.fleeFromPlayer, json.get("fleeFromPlayer"));
            this.playerHostile = Settings.parseBool(this.playerHostile, json.get("playerHostile"));
            this.battleWithOwner = Settings.parseBool(this.battleWithOwner, json.get("battleWithOwner"));
            this.followOwner = Settings.parseBool(this.followOwner, json.get("followOwner"));
            this.attack = Settings.parseDouble(this.attack, json.get("attack"));
            this.health = Settings.parseDouble(this.health, json.get("health"));
            this.speed = Settings.parseDouble(this.speed, json.get("speed"));
            this.volume = Settings.parseDouble(this.volume, json.get("loudness"));
            this.diet = Settings.parseString(this.diet, json.get("diet"));
            this.inventorySize = Settings.parseInt(this.inventorySize, json.get("inventorySize"));
            this.tamingChance = Settings.parseInt(this.tamingChance, json.get("tamingChance"));
            if (json.get("spawnCategory") != null && spawnCategories != null && spawnCategories.getAsJsonObject(json.get("spawnCategory").getAsString()) != null) {
                JsonObject spawnJson = spawnCategories.getAsJsonObject(json.get("spawnCategory").getAsString());
                this.shouldSpawn = Settings.parseBool(this.shouldSpawn, spawnJson.get("shouldSpawn"));
                this.shouldSpawn = Settings.parseBool(this.shouldSpawn, spawnJson.get("shouldSpawn"));
                this.specialAbilitiesEnabled = Settings.parseBool(this.specialAbilitiesEnabled, spawnJson.get("specialAbilitiesEnabled"));
                this.spawnWeight = Settings.parseInt(this.spawnWeight, spawnJson.get("spawnWeight"));
                this.spawnRandomChance = Settings.parseInt(this.spawnRandomChance, spawnJson.get("spawnRandomChance"));
                this.spawnYCeiling = Settings.parseInt(this.spawnYCeiling, spawnJson.get("spawnYCeiling"));
                this.spawnYFloor = Settings.parseInt(this.spawnYFloor, spawnJson.get("spawnYFloor"));
                this.minSpawnGroupSize = Settings.parseInt(this.minSpawnGroupSize, spawnJson.get("minSpawnGroupSize"));
                this.maxSpawnGroupSize = Settings.parseInt(this.maxSpawnGroupSize, spawnJson.get("maxSpawnGroupSize"));
                this.maxIn256Region = Settings.parseInt(this.maxIn256Region, spawnJson.get("maxIn256Region"));
                this.chunkFreq = Settings.parseInt(this.chunkFreq, spawnJson.get("chunkFreq"));
                this.chunkOffset = Settings.parseInt(this.chunkOffset, spawnJson.get("chunkOffset"));
                this.spawnType = Settings.parseString(this.spawnType, spawnJson.get("spawnType"));
                this.temperature = Settings.parseString(this.temperature, spawnJson.get("temperature"));
                this.precipitation = Settings.parseString(this.precipitation, spawnJson.get("precipitation"));
                if (this.minSpawnGroupSize > this.maxSpawnGroupSize) {
                    System.out.println("WARNING: minSpawnGroupSize should be <= maxSpawnGroupSize for " + entityKey + "'s spawnCategory " + json.getAsJsonObject("spawnCategory") + ". [You can fix this in wildlife's config file]");
                    this.maxSpawnGroupSize = this.minSpawnGroupSize;
                }
                if (this.spawnYFloor > this.spawnYCeiling) {
                    System.out.println("WARNING: spawnYFloor should be <= spawnYCeiling for " + entityKey + "'s spawnCategory " + json.getAsJsonObject("spawnCategory") + ". [You can fix this in wildlife's config file]");
                    this.spawnYCeiling = this.spawnYFloor;
                }
            } else {
                System.out.println("WARNING: No spawnCategory defined for " + entityKey + ". [You can fix this by adding a category to this mob's settings in wildlife's config file]");
            }
            ArrayList<String> parsedBiomes = new ArrayList<String>();
            if (json.get("spawnBiomes") != null && json.get("spawnBiomes").isJsonArray()) {
                for (Object str : json.getAsJsonArray("spawnBiomes")) {
                    String biomeElementName = str.getAsString();
                    if (biomeJson.get(biomeElementName) != null) {
                        for (JsonElement biome : biomeJson.get(biomeElementName).getAsJsonArray()) {
                            parsedBiomes.add(biome.getAsString());
                        }
                        continue;
                    }
                    parsedBiomes.add(biomeElementName);
                }
            }
            this.spawnBiomes = new String[parsedBiomes.size()];
            this.spawnBiomes = parsedBiomes.toArray(this.spawnBiomes);
            ArrayList<String> parsedBlocks = new ArrayList<String>();
            if (json.get("spawnBlocks") != null) {
                for (JsonElement block : json.get("spawnBlocks").getAsJsonArray()) {
                    parsedBlocks.add(block.getAsString());
                }
            }
            this.spawnBlocks = new String[parsedBlocks.size()];
            this.spawnBlocks = parsedBlocks.toArray(this.spawnBlocks);
            parsedBlocks = new ArrayList();
            if (json.get("seekingBlocks") != null) {
                for (JsonElement block : json.get("seekingBlocks").getAsJsonArray()) {
                    parsedBlocks.add(block.getAsString());
                }
            }
            this.seekingBlocks = new String[parsedBlocks.size()];
            this.seekingBlocks = parsedBlocks.toArray(this.seekingBlocks);
            this.breedingItems = Settings.parseCompoundItems(json, "breedingItems");
            this.tamingItems = Settings.parseCompoundItems(json, "tamingItems");
            this.foodItems = Settings.parseCompoundItems(json, "foodItems");
            ArrayList<class_1299> parsedEntities = new ArrayList<class_1299>();
            if (json.get("hostileToMobs") != null && json.get("hostileToMobs").isJsonArray()) {
                for (JsonElement str : json.getAsJsonArray("hostileToMobs")) {
                    String mobElementName = str.getAsString();
                    if (mobJson != null && mobJson.get(mobElementName) != null) {
                        for (JsonElement entity : mobJson.get(mobElementName).getAsJsonArray()) {
                            class_1299 e = Settings.parseMinecraftEntity(entity.getAsString());
                            if (e == null) continue;
                            parsedEntities.add(e);
                        }
                        continue;
                    }
                    class_1299 e = Settings.parseMinecraftEntity(mobElementName);
                    if (e == null) continue;
                    parsedEntities.add(e);
                }
            }
            this.mobHostile = new class_1299[parsedEntities.size()];
            this.mobHostile = parsedEntities.toArray(this.mobHostile);
        }

        public String toString() {
            return "shouldSpawn: " + this.shouldSpawn + "\nspawnCategory: " + this.spawnDebug + "\nspawnDebug: " + this.spawnDebug + "\nspawnType: " + this.spawnType + "\nspawnWeight: " + this.spawnWeight + "\nspawnRandomChance: " + this.spawnRandomChance + "; spawnYCeiling: " + this.spawnYCeiling + "\nmaxIn256Region: " + this.maxIn256Region + "\nchunkFreq: " + this.chunkFreq + " ; chunkOffset: " + this.chunkOffset + "\nminSpawnGroupSize: " + this.minSpawnGroupSize + " ; maxSpawnGroupSize: " + this.maxSpawnGroupSize + "\ntemperature: " + this.temperature + " ; precipitation: " + this.precipitation + "\ntamingChance: " + this.tamingChance + "; inventorySize: " + this.inventorySize + "; attack: " + this.attack + "; speed: " + this.speed + "; health: " + this.health + "; diet: " + this.diet + "\nfleeFromPlayer: " + this.fleeFromPlayer + "; playerHostile: " + this.playerHostile + "; isAggressive: " + this.isAggressive + "; battleWithOwner: " + this.battleWithOwner + "; followOwner: " + this.followOwner + "; specialAbilitiesEnabled: " + this.specialAbilitiesEnabled + "\nvolume: " + this.volume + "\nspawnBiomes: " + Arrays.toString(this.spawnBiomes) + "\nspawnBlocks: " + Arrays.toString(this.spawnBlocks) + "\nseekingBlocks: " + Arrays.toString(this.seekingBlocks) + "\ntamingItems: " + Arrays.toString(this.tamingItems) + "\nbreedingItems: " + Arrays.toString(this.breedingItems) + "\nfoodItems: " + Arrays.toString(this.foodItems);
        }
    }
}

