/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.chirpycricket.wildlife.entity;

import com.yahoo.chirpycricket.wildlife.config.Settings;
import com.yahoo.chirpycricket.wildlife.entity.WildlifeData;
import com.yahoo.chirpycricket.wildlife.entity.ai.WildlifeAnimationManager;
import com.yahoo.chirpycricket.wildlife.registry.Entities;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1338;
import net.minecraft.class_1341;
import net.minecraft.class_1347;
import net.minecraft.class_1348;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1374;
import net.minecraft.class_1376;
import net.minecraft.class_1379;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1429;
import net.minecraft.class_1493;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3730;
import net.minecraft.class_4538;
import net.minecraft.class_4802;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5354;
import net.minecraft.class_5398;
import net.minecraft.class_5425;
import net.minecraft.class_6019;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class WildlifeEntity
extends class_1429
implements GeoEntity,
class_5354 {
    public class_1299<? extends class_1429> entityType;
    public Entities.EntityKey entityKey;
    protected Settings.EntitySettings settings;
    protected Predicate<class_1309> PREY_PREDICATE;
    protected Predicate<class_1309> PLAYER_PREDICATE;
    protected Predicate<class_1309> ATTACKER_PREDICATE;
    protected Wander wanderFrequency = Wander.INFREQUENTLY;
    public boolean shouldSwim = true;
    public boolean isAggressive = false;
    public boolean shouldSwimInLava = true;
    public boolean songPlaying = false;
    public boolean isTranslucent = false;
    public class_1792 wildlifeEntityItem;
    public class_1792 wildlifeEntityItemAlbino;
    public class_1792 wildlifeEntityItemBucket;
    protected class_1792[] breedingItems;
    class_1379 wanderGoal;
    public int animationReset;
    @Nullable
    private class_2338 songSource;
    public WildlifeAnimationManager mountAnimationManager;
    private final AnimatableInstanceCache factory;
    protected float soundVolume;
    private static final class_2940<String> TEXTURE_VARIANT = class_2945.method_12791(WildlifeEntity.class, (class_2941)class_2943.field_13326);
    private static final class_2940<Integer> TINT = class_2945.method_12791(WildlifeEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> SPECIAL_NUM = class_2945.method_12791(WildlifeEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Float> SCALE = class_2945.method_12791(WildlifeEntity.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Integer> ANGER_TIME = class_2945.method_12791(class_1493.class, (class_2941)class_2943.field_13327);
    private static final class_6019 ANGER_TIME_RANGE = class_4802.method_24505((int)20, (int)39);
    public boolean varyScale;
    public float scale;
    public float childScale;
    public float childHeadScale;
    protected int[] tints;
    public ArrayList<String> textures;
    @Nullable
    private UUID angryAt;
    protected float leashYOffset;
    protected float leashZOffset;

    public WildlifeEntity(class_1299<? extends class_1429> type, class_1937 worldIn, Entities.EntityKey mountKey) {
        super(type, worldIn);
        this.wildlifeEntityItem = Entities.entityMap.get((Object)((Object)Entities.EntityKey.CRICKET)).item;
        this.wildlifeEntityItemAlbino = null;
        this.wildlifeEntityItemBucket = null;
        this.breedingItems = new class_1792[]{class_1802.field_8071};
        this.animationReset = 0;
        this.factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
        this.soundVolume = 0.25f;
        this.varyScale = false;
        this.scale = 1.0f;
        this.childScale = 1.0f;
        this.childHeadScale = 1.0f;
        this.tints = new int[]{0xFFFFFF};
        this.textures = new ArrayList();
        this.leashYOffset = 0.5f;
        this.leashZOffset = 0.4f;
        this.init(mountKey, type, true, true);
    }

    public WildlifeEntity(class_1299<? extends class_1429> type, class_1937 worldIn, Entities.EntityKey mountKey, boolean shouldSwim, boolean shouldSwimInLava) {
        super(type, worldIn);
        this.wildlifeEntityItem = Entities.entityMap.get((Object)((Object)Entities.EntityKey.CRICKET)).item;
        this.wildlifeEntityItemAlbino = null;
        this.wildlifeEntityItemBucket = null;
        this.breedingItems = new class_1792[]{class_1802.field_8071};
        this.animationReset = 0;
        this.factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
        this.soundVolume = 0.25f;
        this.varyScale = false;
        this.scale = 1.0f;
        this.childScale = 1.0f;
        this.childHeadScale = 1.0f;
        this.tints = new int[]{0xFFFFFF};
        this.textures = new ArrayList();
        this.leashYOffset = 0.5f;
        this.leashZOffset = 0.4f;
        this.init(mountKey, type, shouldSwim, shouldSwimInLava);
    }

    private void init(Entities.EntityKey mountKey, class_1299<? extends class_1429> type, boolean shouldSwim, boolean shouldSwimInLava) {
        this.entityType = type;
        this.mountAnimationManager = new WildlifeAnimationManager(this);
        this.entityKey = mountKey;
        this.settings = Settings.settings.get((Object)mountKey);
        this.method_5834(this.settings.spawnDebug || Settings.globalSettings.debug);
        this.soundVolume = (float)(this.settings.volume / 100.0);
        this.breedingItems = this.settings.breedingItems;
        this.isTranslucent = Entities.entityMap.get((Object)((Object)this.entityKey)).isTranslucent;
        this.shouldSwim = shouldSwim;
        this.shouldSwimInLava = shouldSwimInLava;
        this.isAggressive = this.settings.isAggressive;
        this.initConfigurableGoals();
    }

    protected void method_5959() {
        this.field_6201.method_6277(2, (class_1352)new class_1341((class_1429)this, 1.0, WildlifeEntity.class));
        this.field_6201.method_6277(15, (class_1352)new class_1361((class_1308)this, class_1309.class, 20.0f));
        this.field_6201.method_6277(16, (class_1352)new class_1376((class_1308)this));
    }

    public void initConfigurableGoals() {
        this.PREY_PREDICATE = livingEntity -> {
            for (class_1299 c : this.settings.mobHostile) {
                if (!c.equals(livingEntity.method_5864())) continue;
                return true;
            }
            return false;
        };
        this.PLAYER_PREDICATE = livingEntity -> livingEntity instanceof class_1657;
        this.ATTACKER_PREDICATE = livingEntity -> livingEntity == this.method_6065();
        switch (this.wanderFrequency) {
            case INFREQUENTLY: {
                this.wanderGoal = new class_1379((class_1314)this, 1.0, 500);
            }
            case FREQUENTLY: {
                this.wanderGoal = new class_1379((class_1314)this, 1.0, 150);
            }
            case CONTINUALLY: {
                this.wanderGoal = new class_1379((class_1314)this, 1.0, 80);
            }
        }
        this.field_6201.method_6277(7, (class_1352)this.wanderGoal);
        if (this.shouldSwim) {
            this.field_6201.method_6277(1, (class_1352)new class_1347((class_1308)this));
        }
        if (this.isAggressive) {
            this.field_6201.method_6277(5, (class_1352)new class_1366((class_1314)this, 2.0, true));
            this.field_6185.method_6277(4, (class_1352)new class_1400((class_1308)this, class_1309.class, 10, true, false, this.ATTACKER_PREDICATE));
            this.field_6185.method_6277(3, (class_1352)new class_1399((class_1314)this, new Class[0]));
            this.field_6185.method_6277(3, (class_1352)new class_1348((class_1308)this, 1.0, 0.0f, 16.0f));
            this.field_6185.method_6277(1, (class_1352)new class_5398((class_1308)this, false));
        } else {
            this.field_6201.method_6277(1, (class_1352)new class_1374((class_1314)this, 1.25));
            this.field_6201.method_6277(16, (class_1352)new class_1338((class_1314)this, class_1657.class, 16.0f, 0.8, 1.33));
        }
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1792 newBook;
        if (hand.ordinal() == 1) {
            return class_1269.field_5814;
        }
        class_1799 itemStack = player.method_5998(hand);
        class_1792 item = itemStack.method_7909();
        if (this.method_37908().field_9236) {
            return class_1269.field_5811;
        }
        if (item != null && item.equals(class_1802.field_8529) && (itemStack.method_7969() == null || itemStack.method_7969().method_33133()) && (newBook = Settings.parseMinecraftItem("patchouli:guide_book")) != null) {
            class_1799 stack = newBook.method_7854();
            if (stack.method_7969() == null) {
                stack.method_7948();
            }
            stack.method_7969().method_10582("patchouli:book", "wildlife:encyclopedia_of_wildlife");
            itemStack.method_7934(1);
            player.method_7270(stack);
            return class_1269.field_5812;
        }
        return super.method_5992(player, hand);
    }

    public void method_5773() {
        super.method_5773();
        if (!this.method_37908().field_9236) {
            if (this.method_5851() && !this.settings.spawnDebug && !Settings.globalSettings.debug) {
                this.method_5834(false);
            }
            if ((this.wanderFrequency == Wander.CONTINUALLY || this.wanderFrequency == Wander.FREQUENTLY && Math.random() > (double)0.99f) && this.wanderGoal != null) {
                this.wanderGoal.method_6304();
            }
        }
        if (this.songSource == null || !this.songSource.method_19769((class_2374)this.method_19538(), 20.0) || !this.method_37908().method_8320(this.songSource).method_27852(class_2246.field_10223)) {
            this.songPlaying = false;
            this.songSource = null;
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        this.mountAnimationManager.registerControllers(controllers);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    public RawAnimation getWalkAnimation() {
        return RawAnimation.begin().thenLoop("animation.entity.walk");
    }

    public RawAnimation getFlopAnimation() {
        return this.getWalkAnimation();
    }

    public RawAnimation getIdleAnimation() {
        return RawAnimation.begin().thenLoop("animation.entity.idle");
    }

    public RawAnimation getBlinkAnimation() {
        return RawAnimation.begin().thenLoop("animation.entity.blink");
    }

    public RawAnimation getDanceAnimation() {
        return this.getIdleAnimation();
    }

    public void method_6006(class_2338 songPosition, boolean playing) {
        this.songPlaying = playing;
        this.songSource = songPosition;
    }

    protected float method_6107() {
        return 0.05f * this.soundVolume;
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
    }

    protected class_3414 method_5994() {
        return null;
    }

    protected class_3414 method_6011(class_1282 source) {
        return class_3417.field_14940;
    }

    protected class_3414 method_6002() {
        return class_3417.field_14732;
    }

    public boolean method_6481(class_1799 stack) {
        return Arrays.asList(this.breedingItems).contains(stack.method_7909());
    }

    @Nullable
    public class_1296 method_5613(class_3218 world, class_1296 entity) {
        WildlifeEntity childEntity = (WildlifeEntity)entity.method_5864().method_5883((class_1937)world);
        WildlifeEntity e = this;
        if (entity instanceof WildlifeEntity) {
            e = (WildlifeEntity)entity;
        }
        if (this.field_5974.method_43058() < 0.5) {
            if (this.field_5974.method_43056()) {
                childEntity.setVariant(this.getVariant());
            } else {
                childEntity.setVariant(e.getVariant());
            }
        } else {
            childEntity.setVariant(childEntity.getRandomTexture());
        }
        if (this.field_5974.method_43058() < 0.5) {
            if (this.field_5974.method_43056()) {
                childEntity.setScale(this.getEntitySize());
            } else {
                childEntity.setScale(e.getEntitySize());
            }
        } else {
            childEntity.setScale(this.getEntitySize());
        }
        WildlifeEntity.createWildlifeAttributes(this.entityKey);
        return childEntity;
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(TEXTURE_VARIANT, (Object)"");
        this.field_6011.method_12784(TINT, (Object)0xFFFFFF);
        this.field_6011.method_12784(SCALE, (Object)Float.valueOf(1.0f));
        this.field_6011.method_12784(SPECIAL_NUM, (Object)this.field_5974.method_43054());
        this.field_6011.method_12784(ANGER_TIME, (Object)0);
    }

    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData, @Nullable class_2487 entityTag) {
        if (!(entityData instanceof WildlifeData)) {
            entityData = new WildlifeData(this.getVariant(), this.tints[(int)(Math.random() * (double)this.tints.length)], this.getEntitySize(), this.field_5974.method_43054());
        }
        WildlifeData data = (WildlifeData)((Object)entityData);
        data.read(this);
        float rot = this.field_5974.method_43057() * 360.0f;
        this.method_36456(rot);
        this.field_6036 = rot;
        this.field_6283 = rot;
        this.field_6220 = rot;
        this.field_6241 = rot;
        this.field_6259 = rot;
        this.method_5808(this.method_23317() + 0.5, this.method_23318() + 1.0, this.method_23321() + 0.5, rot, 0.0f);
        return super.method_5943(world, difficulty, spawnReason, entityData, entityTag);
    }

    public class_1315 initialize(class_1936 world, class_1266 difficulty, class_3730 spawnReason, class_1315 entityData, class_2487 entityTag) {
        if (!(entityData instanceof WildlifeData)) {
            entityData = new WildlifeData(this.getVariant(), this.tints[(int)(Math.random() * (double)this.tints.length)], this.getEntitySize(), this.field_5974.method_43054());
        }
        WildlifeData data = (WildlifeData)((Object)entityData);
        data.read(this);
        this.method_36456(this.field_5974.method_43057());
        this.method_5636(this.field_5974.method_43057());
        this.method_5847(this.field_5974.method_43057());
        this.method_5725(this.method_24515(), this.field_5974.method_43057(), this.method_36455());
        return super.method_5943((class_5425)world, difficulty, spawnReason, entityData, entityTag);
    }

    public static class_5132.class_5133 createWildlifeAttributes(Entities.EntityKey mountKey) {
        return WildlifeEntity.method_26828().method_26868(class_5134.field_23719, Settings.settings.get((Object)((Object)mountKey)).speed).method_26868(class_5134.field_23720, (double)0.6f).method_26868(class_5134.field_23721, 1.0).method_26868(class_5134.field_23716, Settings.settings.get((Object)((Object)mountKey)).health);
    }

    public float getEntitySize() {
        return 1.0f;
    }

    public float getScale() {
        return ((Float)this.field_6011.method_12789(SCALE)).floatValue();
    }

    public void setScale(float scale) {
        this.field_6011.method_12778(SCALE, (Object)Float.valueOf(scale));
        this.scale = scale;
    }

    public int getTint() {
        return (Integer)this.field_6011.method_12789(TINT);
    }

    public void setTint(int tint) {
        this.field_6011.method_12778(TINT, (Object)tint);
    }

    public String getDefaultTexture() {
        return "bugs.png";
    }

    public String getTextureFile() {
        return this.getVariant();
    }

    public int getSpecialNum() {
        return (Integer)this.field_6011.method_12789(SPECIAL_NUM);
    }

    public void setSpecialNum(int num) {
        this.field_6011.method_12778(SPECIAL_NUM, (Object)num);
    }

    public void setAlbino() {
        this.field_6011.method_12778(TEXTURE_VARIANT, (Object)this.textures.get(this.textures.size() - 1));
        this.setTint(0xFFFFFF);
    }

    public void setVariant(String variant) {
        this.field_6011.method_12778(TEXTURE_VARIANT, (Object)variant);
    }

    public String getVariant() {
        String res = (String)this.field_6011.method_12789(TEXTURE_VARIANT);
        if (res.length() <= 0 && !this.method_37908().method_8608()) {
            res = this.getRandomTexture();
            this.setVariant(res);
            this.setScale(this.getEntitySize());
        }
        return res;
    }

    protected String getRandomTexture() {
        if (Math.random() > 0.99) {
            this.setTint(0xFFFFFF);
            return this.textures.get(this.textures.size() - 1);
        }
        if (this.textures.size() > 1) {
            return this.textures.get(this.field_5974.method_39332(0, this.textures.size() - 1 - 1));
        }
        return this.textures.get(0);
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        tag.method_10582("Variant", this.getVariant());
        tag.method_10569("Tint", this.getTint());
        tag.method_10548("Scale", this.getScale());
        tag.method_10569("SpecialNum", this.getSpecialNum());
    }

    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        this.setVariant(tag.method_10558("Variant"));
        this.setTint(tag.method_10550("Tint"));
        this.setScale(tag.method_10583("Scale"));
        this.setSpecialNum(tag.method_10550("SpecialNum"));
    }

    public boolean method_5747(float fallDistance, float damageMultiplier, class_1282 damageSource) {
        int i = this.method_23329(fallDistance, damageMultiplier);
        if (i <= 0) {
            return false;
        }
        if (this.method_5782()) {
            for (class_1297 entity : this.method_5736()) {
                entity.method_5643(this.method_37908().method_48963().method_48827(), (float)i);
            }
        }
        this.method_23328();
        return false;
    }

    public boolean method_5979(class_1936 world, class_3730 spawnReason) {
        return true;
    }

    public boolean method_5957(class_4538 world) {
        return true;
    }

    public int method_29507() {
        return (Integer)this.field_6011.method_12789(ANGER_TIME);
    }

    public void method_29514(int angerTime) {
        this.field_6011.method_12778(ANGER_TIME, (Object)angerTime);
    }

    public void method_29509() {
        this.method_29514(ANGER_TIME_RANGE.method_35008(this.field_5974));
    }

    @Nullable
    public UUID method_29508() {
        return this.angryAt;
    }

    public void method_29513(@Nullable UUID angryAt) {
        this.angryAt = angryAt;
    }

    protected boolean canEatFood(class_1792 item) {
        return this.method_6481(item.method_7854());
    }

    public class_243 getLeashAttachPoint() {
        class_243 attachPoint = new class_243(0.0, (double)this.method_5751() * (double)this.leashYOffset, (double)(this.method_17681() * this.leashZOffset));
        return attachPoint;
    }

    protected void showEmoteParticle(boolean positive) {
        class_2400 particleEffect = class_2398.field_11201;
        if (!positive) {
            particleEffect = class_2398.field_11251;
        }
        for (int i = 0; i < 7; ++i) {
            double d = this.field_5974.method_43059() * 0.02;
            double e = this.field_5974.method_43059() * 0.02;
            double f = this.field_5974.method_43059() * 0.02;
            if (this.method_37908().method_8608()) continue;
            ((class_3218)this.method_37908()).method_14199((class_2394)particleEffect, this.method_23322(1.0), this.method_23319() + 0.5, this.method_23325(1.0), 1, d, e, f, 0.005);
        }
    }

    protected static enum Wander {
        INFREQUENTLY,
        FREQUENTLY,
        CONTINUALLY;

    }
}

